/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.domain.status.dto.CrossValidateResDto;
import kd.hr.ham.common.dispatch.bean.PosPatternConfig;
import kd.hr.ham.common.dispatch.bean.PosPatternConfigBean;
import kd.hr.ham.common.dispatch.constants.AffactionConstants;
import kd.hr.ham.common.dispatch.constants.DispatchMQConstants;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class PersonAboutServiceImpl
implements IPersonAboutService {
    private static final Log log = LogFactory.getLog(PersonAboutServiceImpl.class);
    public static final String DOT_ID = ".id";
    public static final String DOT_BOID = ".boid";

    @Override
    public Map<String, Map<String, Object>> buildPersonChangeParams(Map<String, Object> cardFields) {
        Map<String, Object> personCardParams = this.buildPersonCardParams(cardFields);
        Map<String, Object> initParams = this.buildInitParams(cardFields);
        HashMap<String, Map<String, Object>> personChangeMap = new HashMap<String, Map<String, Object>>();
        personChangeMap.put("personCardParams", personCardParams);
        personChangeMap.put("initParams", initParams);
        return personChangeMap;
    }

    @Override
    public Map<String, Object> buildPersonCardParams(DynamicObject billObject) {
        Map<String, Object> cardFields = this.getCardFields(billObject);
        return this.buildPersonCardParams(cardFields);
    }

    @Override
    public Map<String, Object> getCardFields(DynamicObject billObject) {
        long pkValue = billObject.getLong("ermanfile.id");
        return this.getCardFields(pkValue);
    }

    @Override
    public Map<String, Object> getCardFields(long id) {
        List maps = (List)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{id})});
        if (CollectionUtils.isEmpty((Collection)maps)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5230\u4eba\u5458\u5361\u7247\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonAboutServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]));
        }
        return (Map)maps.get(0);
    }

    @Override
    public DynamicObject getPrimaryErManFile(long employeeId) {
        Map idMap = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getErmanFileIdByEmployeeId", (Object[])new Object[]{Collections.singletonList(employeeId), true});
        DynamicObject[] dys = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"getErManFile", (Object[])new Object[]{null, null, new QFilter("id", "=", idMap.get(employeeId))});
        return dys.length > 0 ? dys[0] : null;
    }

    @Override
    public Map<String, Object> getPrimaryInfo(long employeeId) {
        if (employeeId == 0L) {
            log.warn("getPrimaryInfo erManFileId is 0");
            return Collections.emptyMap();
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try {
            DynamicObject primaryErManFile = this.getPrimaryErManFile(employeeId);
            if (HRObjectUtils.isEmpty((Object)primaryErManFile)) {
                log.warn("getPrimaryInfo primaryErManFile is null");
                return Collections.emptyMap();
            }
            map.put("pcmpemp", primaryErManFile.get("cmpemp.managingscope"));
            DynamicObject empPosRel = primaryErManFile.getDynamicObject("empposrel");
            map.put("company", empPosRel.get("company"));
            map.put("adminorg", empPosRel.get("adminorg"));
            map.put("position", empPosRel.get("position"));
            map.put("porgleader", this.getMainInCharge(primaryErManFile));
            map.put("psuperior", this.getSupervisor(primaryErManFile));
            map.put("primarycity", empPosRel.get("workplace"));
            map.put("stdposition", empPosRel.get("stdposition"));
            map.put("job", empPosRel.get("job"));
            map.put("pospattern", empPosRel.get("apositiontype"));
        }
        catch (Exception exception) {
            log.error("getPrimaryInfo error: ", (Throwable)exception);
        }
        return map;
    }

    @Override
    public DynamicObject[] getErManFileByDeptEmpId(List<Long> ids) {
        return (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"getErmanFileByDepempId", (Object[])new Object[]{ids});
    }

    private Map<String, Object> buildPersonCardParams(Map<String, Object> cardFields) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String languageName = RequestContext.get().getLang().name();
        Object person = cardFields.get("person_id");
        if (ObjectUtils.isEmpty((Object)person)) {
            return null;
        }
        Object headPic = cardFields.get("headsculpture");
        params.put("avatar", headPic);
        Object name = cardFields.get("name");
        params.put("personname", name);
        Object number = cardFields.get("number");
        params.put("personnumber", number);
        params.put("personsex", cardFields.get("gender"));
        params.put("laborreltype", cardFields.get("laborreltype"));
        params.put("laborrelstatus", cardFields.get("laborrelstatus"));
        params.put("postype", cardFields.get("postype"));
        params.put("company", cardFields.get("company"));
        params.put("department", cardFields.get("adminorg"));
        params.put("position", cardFields.get("position"));
        params.put("stdposition", cardFields.get("stdposition"));
        return params;
    }

    @Override
    public Map<String, Object> buildInitParams(Map<String, Object> cardFields) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("countryout", cardFields.get("location_country_id"));
        params.put("companyout", cardFields.get("company_id"));
        params.put("deptout", cardFields.get("adminorg_id"));
        params.put("positionout", cardFields.get("position_id"));
        params.put("standardposout", cardFields.get("stdposition_id"));
        params.put("pospatternout", cardFields.get("apositiontype"));
        params.put("jobout", cardFields.get("job_id"));
        params.put("orgout", cardFields.get("org_id"));
        params.put("adminorgout", cardFields.get("affiliateadminorg_id"));
        params.put("empgroupout", cardFields.get("empgroup_id"));
        params.put("cmpempout", cardFields.get("managingscope_id"));
        params.put("dispatchasuperior", cardFields.get("superiorinfo"));
        params.put("dispatchaincharge", cardFields.get("chargeinfo"));
        params.put("person", cardFields.get("person_id"));
        params.put("laborrelstatus", cardFields.get("laborrelstatus_id"));
        return params;
    }

    @Override
    public CrossValidateResDto buildCrossValidateParams(CrossValidateParamDto crossValidateParam) {
        IDispatchPersonChangeService dispatchPersonChangeService = ServiceFactory.getService(IDispatchPersonChangeService.class);
        boolean isNewChgAction = HPFSTemplatePropertyHandler.isNewChgAction("ham_dispatch_hpfs_new");
        if (isNewChgAction) {
            crossValidateParam.setActionId(String.valueOf(AffactionConstants.DISP_AFFACTION_NEW));
        } else {
            crossValidateParam.setActionId(DispatchMQConstants.DISPATCH_ACTIONID.toString());
        }
        CrossValidateResDto crossValidateRes = dispatchPersonChangeService.excutePersonOverlapCheckByParam(crossValidateParam);
        log.info("crossValidate: {}", crossValidateRes.getMsgs());
        return crossValidateRes;
    }

    @Override
    public CrossValidateParamDto getCrossValidateParamByCardFields(Map<String, Object> cardFields) {
        CrossValidateParamDto crossValidateParam = new CrossValidateParamDto();
        crossValidateParam.setBillId(0L);
        crossValidateParam.setPersonName(String.valueOf(cardFields.get("name")));
        crossValidateParam.setPersonId(String.valueOf(cardFields.get("person_id")));
        crossValidateParam.setEmployeeId(String.valueOf(cardFields.get("employee_id")));
        crossValidateParam.setManagingScopeId(String.valueOf(cardFields.get("cmpemp_id")));
        crossValidateParam.setDepEmpId(String.valueOf(cardFields.get("depemp_id")));
        crossValidateParam.setEffectTime(System.currentTimeMillis());
        return crossValidateParam;
    }

    @Override
    public CrossValidateParamDto getCrossValidateParamByCardFields(DynamicObject obj, String type) {
        PosPatternConfigBean configBean = (PosPatternConfigBean)PosPatternConfig.CONFIG.get(type);
        HamNPEExpUtil.throwExp((Object)configBean, (String)"getCrossValidateParamByCardFields_PosPatternConfig null");
        DynamicObject fileObj = obj.getDynamicObject("ermanfile");
        CrossValidateParamDto crossValidateParam = new CrossValidateParamDto();
        if (HRObjectUtils.isEmpty((Object)fileObj)) {
            return crossValidateParam;
        }
        boolean isNewChgAction = HPFSTemplatePropertyHandler.isNewChgAction("ham_dispatch_hpfs_new");
        if (isNewChgAction) {
            crossValidateParam.setActionId(String.valueOf(AffactionConstants.DISP_AFFACTION_NEW));
        } else {
            crossValidateParam.setActionId(DispatchMQConstants.DISPATCH_ACTIONID.toString());
        }
        crossValidateParam.setPosType(obj.getString(configBean.getPatternKey()));
        crossValidateParam.setStdpositionId(obj.getLong(configBean.getStdPosKey() + DOT_ID));
        crossValidateParam.setPositionId(obj.getLong(configBean.getPosKey() + DOT_ID));
        crossValidateParam.setJobId(obj.getLong(configBean.getJobKey() + DOT_ID));
        crossValidateParam.setStdpositionBoId(obj.getLong(configBean.getStdPosKey() + DOT_BOID));
        crossValidateParam.setPositionBoId(obj.getLong(configBean.getPosKey() + DOT_BOID));
        crossValidateParam.setJobBoId(obj.getLong(configBean.getJobKey() + DOT_BOID));
        crossValidateParam.setDeptinId(obj.getLong(configBean.getDeptKey() + DOT_ID));
        crossValidateParam.setBillId(obj.getLong("id"));
        crossValidateParam.setPersonName(fileObj.getString("name"));
        crossValidateParam.setPersonId(String.valueOf(fileObj.getLong("person_id")));
        crossValidateParam.setEmployeeId(String.valueOf(fileObj.getLong("employee_id")));
        crossValidateParam.setManagingScopeId(String.valueOf(fileObj.getLong("cmpemp_id")));
        crossValidateParam.setDepEmpId(String.valueOf(fileObj.getLong("depemp_id")));
        crossValidateParam.setEffectTime(System.currentTimeMillis());
        return crossValidateParam;
    }

    private DynamicObjectCollection getSupervisor(DynamicObject primaryErManFile) {
        log.info("HamgetSupervisor start");
        try {
            Map superiorInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperiorByDepempId", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{primaryErManFile.getDynamicObject("depemp").getLong("id")})});
            log.info("getSupervisor: {}", (Object)SerializationUtils.toJsonString((Object)superiorInfo));
            if (CollectionUtils.isEmpty((Map)superiorInfo)) {
                return new DynamicObjectCollection();
            }
            ArrayList personIds = new ArrayList(16);
            superiorInfo.values().forEach(value -> {
                List collect = value.stream().map(map -> map.get("person.id")).collect(Collectors.toList());
                personIds.addAll(collect);
            });
            QFilter qFilter = new QFilter("id", "in", personIds);
            return new HRBaseServiceHelper("hrpi_person").queryOriginalCollection("id,name,number", qFilter.toArray());
        }
        catch (Exception e) {
            log.error("HamgetSupervisor error: ", (Throwable)e);
            return new DynamicObjectCollection();
        }
    }

    private DynamicObjectCollection getMainInCharge(DynamicObject primaryErManFile) {
        log.info("HamgetMainInCharge start");
        try {
            long adminOrg = primaryErManFile.getDynamicObject("empposrel.adminorg").getLong("id");
            List chargeInfoList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getMainChargeInfoByOrg", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{adminOrg}), new Date()});
            log.info("getMainInCharge: {}", (Object)SerializationUtils.toJsonString((Object)chargeInfoList));
            if (CollectionUtils.isEmpty((Collection)chargeInfoList)) {
                return new DynamicObjectCollection();
            }
            List personIds = chargeInfoList.stream().map(map -> map.get("person")).collect(Collectors.toList());
            log.info("getMainInCharge personIds:{}", personIds);
            QFilter qFilter = new QFilter("id", "in", personIds);
            log.info("getMainInCharge qFilter:{}", (Object)qFilter.toString());
            return new HRBaseServiceHelper("hrpi_person").queryOriginalCollection("id,name,number", qFilter.toArray());
        }
        catch (Exception e) {
            log.error("HamgetMainInCharge error: ", (Throwable)e);
            return new DynamicObjectCollection();
        }
    }
}

