/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.service.common.IShowPageByBillService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.ham.common.dispatch.utils.HamNPEExpUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ShowPageByBillServiceImpl
implements IShowPageByBillService {
    private static final Log log = LogFactory.getLog(ShowPageByBillServiceImpl.class);

    @Override
    public Map<String, Object> buildBillHeadParams(DynamicObject bill, String billFormId) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        String name = bill.getDynamicObjectType().getExtendName();
        String billLabel = HRStringUtils.equals((String)billFormId, (String)"ham_dispatchout") || HRStringUtils.equals((String)billFormId, (String)"ham_dispatchinlayout") ? ResManager.loadKDString((String)"\u6d3e\u51fa", (String)"ShowPageByBillServiceImpl_12", (String)"hr-ham-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d3e\u5165", (String)"ShowPageByBillServiceImpl_13", (String)"hr-ham-business", (Object[])new Object[0]);
        params.put("billtype", billLabel);
        switch (name) {
            case "ham_dispatchout": {
                params.put("billstatus", this.getType(name, bill.getString("outstatus")));
                break;
            }
            case "ham_dispatchin": {
                params.put("billstatus", this.getType(name, bill.getString("instatus")));
                break;
            }
            case "ham_dispback": {
                params.put("billtype", ResManager.loadKDString((String)"\u6d3e\u8fd4", (String)"ShowPageByBillServiceImpl_14", (String)"hr-ham-business", (Object[])new Object[0]));
                params.put("billstatus", DispatchBackStatusEnum.getName((String)bill.getString("backstatus")));
                break;
            }
            case "ham_dispatchrecordchg": {
                params.put("billtype", ResManager.loadKDString((String)"\u53d8\u66f4", (String)"ShowPageByBillServiceImpl_15", (String)"hr-ham-business", (Object[])new Object[0]));
                params.put("billstatus", RecordChangeStatusEnum.getName((String)bill.getString("changestatus")));
                break;
            }
        }
        params.put("billno", bill.getString("billno"));
        params.put("creator", bill.getString("creator.name"));
        Date date = bill.getDate("createtime");
        params.put("createtime", HRInteDateTimeUtil.formatDate((String)name, (String)"createtime", (Date)date));
        if (HRStringUtils.equals((String)"ham_dispatchin", (String)name) || HRStringUtils.equals((String)"ham_dispatchout", (String)name)) {
            params.put("dispatchstatus", bill.getString("dispatchstatus"));
            params.put("dispatchtype", bill.getString("disptype.name"));
        } else if ("ham_dispback".equals(name)) {
            params.put("dispatchstatus", bill.getString("backstatus"));
            params.put("dispatchtype", bill.getString("backstatus"));
        } else {
            params.put("dispatchtype", bill.getString("changestatus"));
            params.put("dispatchstatus", bill.getString("changestatus"));
        }
        String personName = bill.getString("person.name");
        params.put("org", bill.getString("org.name"));
        params.put("ermanfile", personName);
        return params;
    }

    @Override
    public Map<String, Object> buildCompareInfo(DynamicObject bill, String formId) {
        String billName = bill.getDynamicObjectType().getExtendName();
        HashMap compareInfo = Maps.newHashMapWithExpectedSize((int)16);
        String inStatus = bill.getString("instatus");
        log.info("billName: {} in status : {}", (Object)billName, (Object)inStatus);
        String outInOrder = bill.getString("disoutinorder");
        this.setLeftValue(bill, compareInfo);
        if (!HRStringUtils.equals((String)outInOrder, (String)"1") || !HRStringUtils.equals((String)"ham_dispatchout", (String)formId)) {
            compareInfo.put("righttitle", ResManager.loadKDString((String)"\u6d3e\u5165\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]));
            this.setRightValue(bill, compareInfo);
        } else {
            this.setPlanRightValue(bill, compareInfo);
        }
        return compareInfo;
    }

    @Override
    public Map<String, Object> buildCompareBackInfo(DynamicObject bill, String formId) {
        String billName = bill.getDynamicObjectType().getExtendName();
        HashMap compareInfo = Maps.newHashMapWithExpectedSize((int)16);
        compareInfo.put("billFormId", billName);
        this.setLeftMapValue(bill, compareInfo, Lists.newArrayList((Object[])new String[]{"countryback", "companyback", "deptback", "cmpempback", "poststandardback", "positionback", "jobback", "superiorback", "inchargeback"}), bill.getDynamicObject("cmpempback"));
        compareInfo.put("lefttitle", ResManager.loadKDString((String)"\u6d3e\u8fd4\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_5", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("righttitle", ResManager.loadKDString((String)"\u5f53\u524d\u5916\u6d3e\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]));
        String cmpEmpKey = ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\uff1a", (String)"ShowPageByBillServiceImpl_11", (String)"hr-ham-business", (Object[])new Object[0]);
        compareInfo.put("leftmanscopkey", cmpEmpKey);
        compareInfo.put("rightmanscopkey", cmpEmpKey);
        this.setRightMapValue(bill, compareInfo, Lists.newArrayList((Object[])new String[]{"countryin", "companyin", "deptin", "positionin", "jobin", "poststandardin", "cmpempin", "insuperior", "inincharge"}));
        return compareInfo;
    }

    @Override
    public Map<String, Object> buildCompareChangeInfo(DynamicObject bill, String formId) {
        String billName = bill.getDynamicObjectType().getExtendName();
        HashMap compareInfo = Maps.newHashMapWithExpectedSize((int)16);
        compareInfo.put("billFormId", billName);
        compareInfo.put("lefttitle", ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_3", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("righttitle", ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_4", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("leftcountrykey", ResManager.loadKDString((String)"\u5916\u6d3e\u7c7b\u578b\uff1a", (String)"ShowPageByBillServiceImpl_7", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("leftcompanykey", ResManager.loadKDString((String)"\u5916\u6d3e\u5f00\u59cb\u65e5\u671f\uff1a", (String)"ShowPageByBillServiceImpl_8", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("leftdepkey", ResManager.loadKDString((String)"\u8ba1\u5212\u5916\u6d3e\u7ed3\u675f\u65e5\u671f\uff1a", (String)"ShowPageByBillServiceImpl_9", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("leftdatekey", ResManager.loadKDString((String)"\u8ba1\u5212\u5916\u6d3e\u65f6\u957f\uff1a", (String)"ShowPageByBillServiceImpl_10", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("rightcountrykey", ResManager.loadKDString((String)"\u5916\u6d3e\u7c7b\u578b\uff1a", (String)"ShowPageByBillServiceImpl_7", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("rightcompanykey", ResManager.loadKDString((String)"\u5916\u6d3e\u5f00\u59cb\u65e5\u671f\uff1a", (String)"ShowPageByBillServiceImpl_8", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("rightdepkey", ResManager.loadKDString((String)"\u8ba1\u5212\u5916\u6d3e\u7ed3\u675f\u65e5\u671f\uff1a", (String)"ShowPageByBillServiceImpl_9", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("rightdatekey", ResManager.loadKDString((String)"\u8ba1\u5212\u5916\u6d3e\u65f6\u957f\uff1a", (String)"ShowPageByBillServiceImpl_10", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("changecompareinfoflex", "1");
        compareInfo.put("leftcountryvalue", bill.getString("bdisptype.name"));
        compareInfo.put("leftcompanyvalue", Objects.isNull(bill.getDate("startdate")) ? null : HRInteDateTimeUtil.formatDate((String)billName, (String)"startdate", (Date)bill.getDate("startdate")));
        compareInfo.put("leftdepvalue", Objects.isNull(bill.getDate("enddate")) ? null : HRInteDateTimeUtil.formatDate((String)billName, (String)"enddate", (Date)bill.getDate("enddate")));
        compareInfo.put("leftdatevalue", bill.getInt("duration") + "");
        compareInfo.put("rightcountryvalue", bill.getString("plandisptype.name"));
        compareInfo.put("rightcompanyvalue", Objects.isNull(bill.getDate("planstartdate")) ? null : HRInteDateTimeUtil.formatDate((String)billName, (String)"planstartdate", (Date)bill.getDate("planstartdate")));
        compareInfo.put("rightdepvalue", Objects.isNull(bill.getDate("planenddate")) ? null : HRInteDateTimeUtil.formatDate((String)billName, (String)"planenddate", (Date)bill.getDate("planenddate")));
        compareInfo.put("rightdatevalue", bill.getInt("planduration") + "");
        return compareInfo;
    }

    public String getFmtDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    @Override
    public Map<String, Object> buildCompareDispatchInfo(DynamicObject bill, String formId) {
        String billName = bill.getDynamicObjectType().getExtendName();
        HashMap compareInfo = Maps.newHashMapWithExpectedSize((int)16);
        compareInfo.put("billFormId", billName);
        DynamicObject dispatchErmanFile = bill.getDynamicObject("ermanfile");
        HamNPEExpUtil.throwExp((Object)dispatchErmanFile, (String)"getErmanFile by Change Bill fail");
        long dispatchErmanFileId = dispatchErmanFile.getLong("id");
        log.info("buildCompareDispatchInfo.dispatchErmanFileId:{}", (Object)dispatchErmanFileId);
        DynamicObject recordEntity = DispatchRecordService.getInstance().queryOneDispatchRecord(dispatchErmanFileId);
        log.info("buildCompareDispatchInfo.recordEntity:{}", recordEntity.getPkValue());
        DynamicObject hbssManScopeDy = bill.getDynamicObject("cmpempback");
        ArrayList dispatchFields = Lists.newArrayList((Object[])new String[]{"countryout", "companyout", "deptout", "cmpempback", "standardposout", "positionout", "jobout", "outsuperior", "outincharge", "leavedate"});
        this.setLeftMapValue(recordEntity, compareInfo, dispatchFields, hbssManScopeDy);
        this.setRightMapValue(recordEntity, compareInfo, Lists.newArrayList((Object[])new String[]{"countryin", "companyin", "deptin", "positionin", "jobin", "standardposin", "cmpempin", "insuperior", "inincharge", "reachdate"}));
        compareInfo.put("lefttitle", ResManager.loadKDString((String)"\u6d3e\u51fa\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_1", (String)"hr-ham-business", (Object[])new Object[0]));
        compareInfo.put("righttitle", ResManager.loadKDString((String)"\u6d3e\u5165\u4fe1\u606f", (String)"ShowPageByBillServiceImpl_2", (String)"hr-ham-business", (Object[])new Object[0]));
        return compareInfo;
    }

    private void setMapValue(DynamicObject obj, Map<String, Object> compareInfo, List<String> fields, List<String> mappingFields, DynamicObject hbssManScopeDy) {
        String entityNumber = obj.getDataEntityType().getExtendName();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            String mappingFiled = mappingFields.get(i);
            Object fieldObj = "cmpempback".equals(field) ? hbssManScopeDy : obj.get(field);
            if (fieldObj instanceof DynamicObject) {
                Object fieldDyObj = fieldObj;
                compareInfo.put(mappingFiled, fieldDyObj.getString("name"));
                continue;
            }
            if (fieldObj instanceof DynamicObjectCollection) {
                String dynamicColName = this.getDynamicColName(obj, field);
                compareInfo.put(mappingFiled, dynamicColName);
                continue;
            }
            if (fieldObj instanceof Date) {
                Date fieldDate = obj.getDate(field);
                String fmtDate = null;
                if (!Objects.isNull(fieldDate)) {
                    fmtDate = HRInteDateTimeUtil.formatDate((String)entityNumber, (String)field, (Date)fieldDate);
                }
                compareInfo.put(mappingFiled, fmtDate);
                continue;
            }
            compareInfo.put(mappingFiled, null);
        }
    }

    private void setLeftMapValue(DynamicObject obj, Map<String, Object> compareInfo, List<String> fields, DynamicObject hbssManScopeDy) {
        ArrayList mappingFields = Lists.newArrayList((Object[])new String[]{"leftcountryvalue", "leftcompanyvalue", "leftdepvalue", "leftmanscopvalue", "leftstandardposvalue", "leftposvalue", "leftjobvalue", "leftsuperiorvalue", "leftinchargevalue", "leftdatevalue"});
        this.setMapValue(obj, compareInfo, fields, mappingFields, hbssManScopeDy);
    }

    private void setRightMapValue(DynamicObject obj, Map<String, Object> compareInfo, List<String> fields) {
        ArrayList mappingFields = Lists.newArrayList((Object[])new String[]{"rightcountryvalue", "rightcompanyvalue", "rightdepvalue", "rightposvalue", "rightjobvalue", "rightstandardposvalue", "rightmanscopvalue", "rightsuperiorvalue", "rightinchargevalue", "rightdatevalue"});
        this.setMapValue(obj, compareInfo, fields, mappingFields, null);
    }

    private void setLeftValue(DynamicObject bill, Map<String, Object> compareInfo) {
        compareInfo.put("leftcountryvalue", this.getDyObjName(bill.getDynamicObject("countryout")));
        compareInfo.put("leftcompanyvalue", this.getDyObjName(bill.getDynamicObject("companyout")));
        compareInfo.put("leftdepvalue", this.getDyObjName(bill.getDynamicObject("deptout")));
        compareInfo.put("leftmanscopvalue", this.getDyObjName(bill.getDynamicObject("cmpempout")));
        compareInfo.put("leftstandardposvalue", this.getDyObjName(bill.getDynamicObject("standardposout")));
        compareInfo.put("leftposvalue", this.getDyObjName(bill.getDynamicObject("positionout")));
        compareInfo.put("leftjobvalue", this.getDyObjName(bill.getDynamicObject("jobout")));
        compareInfo.put("leftsuperiorvalue", this.getDynamicColName(bill, "dispatchasuperior"));
        compareInfo.put("leftinchargevalue", this.getDynamicColName(bill, "dispatchaincharge"));
        Date leaveDate = bill.getDate("leavedate");
        String fmtLeaveDate = !Objects.isNull(leaveDate) ? HRInteDateTimeUtil.formatDate((String)bill.getDynamicObjectType().getExtendName(), (String)"leavedate", (Date)leaveDate) : null;
        compareInfo.put("leftdatevalue", fmtLeaveDate);
    }

    private void setPlanRightValue(DynamicObject bill, Map<String, Object> compareInfo) {
        compareInfo.put("planflag", "1");
        compareInfo.put("rightcountryvalue", this.getDyObjName(bill.getDynamicObject("plancountry")));
        compareInfo.put("rightcompanyvalue", this.getDyObjName(bill.getDynamicObject("plancompanyin")));
        compareInfo.put("rightdepvalue", this.getDyObjName(bill.getDynamicObject("plandepin")));
        compareInfo.put("rightmanscopvalue", this.getDyObjName(bill.getDynamicObject("plancmpempin")));
        compareInfo.put("rightstandardposvalue", this.getDyObjName(bill.getDynamicObject("planstandardposin")));
        compareInfo.put("rightposvalue", this.getDyObjName(bill.getDynamicObject("planpositionin")));
        compareInfo.put("rightjobvalue", this.getDyObjName(bill.getDynamicObject("planjob")));
        compareInfo.put("rightsuperiorvalue", this.getDynamicColName(bill, "dispatchplansup"));
        compareInfo.put("rightinchargevalue", this.getDynamicColName(bill, "dispatchplanincha"));
        Date planReachDate = bill.getDate("planreachdate");
        String fmtLeaveDate = !Objects.isNull(planReachDate) ? HRInteDateTimeUtil.formatDate((String)bill.getDynamicObjectType().getExtendName(), (String)"planreachdate", (Date)planReachDate) : null;
        compareInfo.put("rightdatevalue", fmtLeaveDate);
    }

    private void setRightValue(DynamicObject bill, Map<String, Object> compareInfo) {
        compareInfo.put("rightcountryvalue", this.getDyObjName(bill.getDynamicObject("countryin")));
        compareInfo.put("rightcompanyvalue", this.getDyObjName(bill.getDynamicObject("companyin")));
        compareInfo.put("rightdepvalue", this.getDyObjName(bill.getDynamicObject("deptin")));
        compareInfo.put("rightmanscopvalue", this.getDyObjName(bill.getDynamicObject("cmpempin")));
        compareInfo.put("rightstandardposvalue", this.getDyObjName(bill.getDynamicObject("standardposin")));
        compareInfo.put("rightposvalue", this.getDyObjName(bill.getDynamicObject("positionin")));
        compareInfo.put("rightjobvalue", this.getDyObjName(bill.getDynamicObject("jobin")));
        compareInfo.put("rightsuperiorvalue", this.getDynamicColName(bill, "dispatchinsuperior"));
        compareInfo.put("rightinchargevalue", this.getDynamicColName(bill, "dispatchinincharge"));
        Date leaveDate = bill.getDate("reachdate");
        String fmtReachDate = !Objects.isNull(leaveDate) ? HRInteDateTimeUtil.formatDate((String)bill.getDynamicObjectType().getExtendName(), (String)"reachdate", (Date)leaveDate) : null;
        compareInfo.put("rightdatevalue", fmtReachDate);
    }

    public String getDynamicColName(DynamicObject dataEntity, String key) {
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection(key);
        return col.stream().filter(ob -> !HRObjectUtils.isEmpty((Object)ob.getDynamicObject("fbasedataid"))).map(obj -> obj.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(","));
    }

    private String getDyObjProp(DynamicObject dynamicObject, String key) {
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        if (HRObjectUtils.isEmpty((Object)dynamicObject.getString(key))) {
            return null;
        }
        return dynamicObject.getString(key);
    }

    private String getDyObjName(DynamicObject dynamicObject) {
        return this.getDyObjProp(dynamicObject, "name");
    }

    private String getDyObjId(DynamicObject dynamicObject) {
        return this.getDyObjProp(dynamicObject, "id");
    }

    private String getType(String billName, String typeCode) {
        if (HRStringUtils.equals((String)"ham_dispatchout", (String)billName)) {
            return DispatchInStatusEnum.getName((String)typeCode);
        }
        return DispatchOutStatusEnum.getName((String)typeCode);
    }
}

