/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.record;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.ham.business.domain.repository.PostTypeRepository;
import kd.hr.ham.business.domain.service.common.IDispatchHRCSService;
import kd.hr.ham.business.domain.service.history.HamHistoryModelService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.TermRecordSource;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.DyObjOperateUtils;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.init.InitOutMessage;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DispatchRecordInitDataService
extends AbstractInitDomainDataService {
    private static final Log LOG = LogFactory.getLog(DispatchRecordInitDataService.class);
    private static final String PATTERN = "yyyy-MM-dd";
    private static final Date FUTURE_DATE = DispatchDateUtils.getDate((Object)"2999-12-31", (String)"yyyy-MM-dd");
    private Map<String, DispatchInfo> dispatchInfoMap;
    private List<Long> depEmpIds;
    private List<Long> adminOrgIds;
    private Set<Long> workPlaceIds;
    private Map<Long, Set<Long>> orgId2BusinessType;

    public void validate() {
        Map<String, DispatchInfo> dispatchInfoMap = this.getDispatchInfoMap();
        if (CollectionUtils.isEmpty(dispatchInfoMap)) {
            Map infoWithMap = this.getInfoWithMap();
            List data = (List)infoWithMap.get("data");
            data.stream().forEach(item -> {
                String startDateStr = DateFormatUtils.format((Date)DispatchDateUtils.getDate(item.get("startdate"), (String)PATTERN), (String)PATTERN);
                Date endDate = DispatchDateUtils.getDate(item.get("enddate"), (String)PATTERN);
                String msg = endDate == null || DateUtils.isSameDay((Date)FUTURE_DATE, (Date)endDate) ? String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u7b26\u5408\u4ee5\u4e0b\u8d77\u6b62\u65e5\u671f\u7684\u5916\u6d3e\u4efb\u804c\u7ecf\u5386\uff1a%s \u81f3\u4eca", (String)"DispatchRecordInitDataService_3", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr) : String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u7b26\u5408\u4ee5\u4e0b\u8d77\u6b62\u65e5\u671f\u7684\u5916\u6d3e\u4efb\u804c\u7ecf\u5386\uff1a%1$s \u81f3 %2$s", (String)"DispatchRecordInitDataService_4", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr, DateFormatUtils.format((Date)endDate, (String)PATTERN));
                this.getInitOutParam().addErrorMsg((Long)item.get("id"), msg);
            });
            return;
        }
        for (DispatchInfo dispatchInfo : dispatchInfoMap.values()) {
            int size;
            int dispatchSize;
            String msg;
            Date dispatchEndDate = dispatchInfo.getDispatchEndDate();
            boolean isFuture = HRDateTimeUtils.isAfterNow((Date)dispatchEndDate);
            boolean isFutureEndDate = DateUtils.isSameDay((Date)FUTURE_DATE, (Date)dispatchEndDate);
            if (isFuture && !isFutureEndDate) {
                msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u586b\u5199\u672a\u6765\u7684\u7ed3\u675f\u65e5\u671f\uff0c\u7ed3\u675f\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u521d\u59cb\u5316\u5bfc\u5165\u65e5\u671f\u3002\u5982\u679c\u5916\u6d3e\u751f\u6548\u4e2d\uff0c\u8bf7\u586b\u5165\u201c2999-12-31\u201d\uff1b\u5982\u679c\u5916\u6d3e\u5df2\u7ed3\u675f\uff0c\u8bf7\u5982\u5b9e\u586b\u5165\u65e5\u671f\u3002", (String)"DispatchRecordInitDataService_0", (String)"hr-ham-business", (Object[])new Object[0]);
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            if (!isFuture && HRStringUtils.isEmpty((String)dispatchInfo.getDispatchBackReason())) {
                msg = ResManager.loadKDString((String)"\u5916\u6d3e\u7ed3\u675f\u65e5\u671f\u4e3a\u201c2999-12-31\u201d\u6216\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u201c\u6d3e\u8fd4\u539f\u56e0\u7f16\u7801\u201d\u3002", (String)"DispatchRecordInitDataService_1", (String)"hr-ham-business", (Object[])new Object[0]);
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            List<DynamicObject> dispatchErManFileList = dispatchInfo.getDispatchErManFileList();
            Date startDate = dispatchInfo.getDispatchStartDate();
            String startDateStr = DateFormatUtils.format((Date)startDate, (String)PATTERN);
            int n = dispatchSize = dispatchErManFileList == null ? 0 : dispatchErManFileList.size();
            if (dispatchSize > 1) {
                msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u5f00\u59cb\u65e5\u671f\u4e3a\u201c%1$s\u201d\u7684\u5916\u6d3e\u4efb\u804c\u7ecf\u5386\u6709\u8bef\u3002\uff08\u9519\u8bef\u6761\u6570\uff1a%2$s\uff09", (String)"DispatchRecordInitDataService_2", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr, dispatchSize);
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            if (dispatchErManFileList == null || dispatchSize == 0 || !DateUtils.isSameDay((Date)dispatchErManFileList.get(0).getDate("enddate"), (Date)dispatchEndDate)) {
                msg = isFutureEndDate ? String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u7b26\u5408\u4ee5\u4e0b\u8d77\u6b62\u65e5\u671f\u7684\u5916\u6d3e\u4efb\u804c\u7ecf\u5386\uff1a%s \u81f3\u4eca", (String)"DispatchRecordInitDataService_3", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr) : String.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\u7b26\u5408\u4ee5\u4e0b\u8d77\u6b62\u65e5\u671f\u7684\u5916\u6d3e\u4efb\u804c\u7ecf\u5386\uff1a%1$s \u81f3 %2$s", (String)"DispatchRecordInitDataService_4", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr, DateFormatUtils.format((Date)dispatchEndDate, (String)PATTERN));
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            List<DynamicObject> erManFileList = dispatchInfo.getErManFileList();
            int n2 = size = erManFileList == null ? 0 : erManFileList.size();
            if (erManFileList == null || size != 1) {
                msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u5305\u542b\u201c%1$s\u201d\u7684\u4e3b\u4efb\u804c\u7ecf\u5386\u6709\u8bef\uff08\u6761\u6570\uff1a{%2$s}\uff09\u3002", (String)"DispatchRecordInitDataService_5", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr, size);
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            Long depEmpId = erManFileList.get(0).getLong("depemp.id");
            List<DynamicObject> recordList = this.getDispatchRecords().get(depEmpId);
            if (recordList != null && recordList.stream().filter(dy -> DateUtils.isSameDay((Date)startDate, (Date)dy.getDate("startdate"))).findAny().isPresent()) {
                msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458\u5df2\u5b58\u5728\u5916\u6d3e\u5f00\u59cb\u65e5\u671f\u4e3a%s\u7684\u5916\u6d3e\u6863\u6848", (String)"DispatchRecordInitDataService_6", (String)"hr-ham-business", (Object[])new Object[0]), startDateStr);
                this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), msg);
                continue;
            }
            this.getInitOutParam().addSuccessMsg(dispatchInfo.getMidTableId(), "", "");
        }
    }

    public void save() {
        this.validate();
        Map infoWithDynamicObject = this.getInfoWithDynamicObject();
        Map<String, DispatchInfo> dispatchInfoMap = this.getDispatchInfoMap();
        if (CollectionUtils.isEmpty((Map)infoWithDynamicObject) || CollectionUtils.isEmpty(dispatchInfoMap)) {
            return;
        }
        List dataList = (List)infoWithDynamicObject.get("data");
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(dataList.size());
        Map<Long, InitOutMessage> initOutMessageMap = this.getInitOutParam().getData().entrySet().stream().filter(item -> ((InitOutMessage)item.getValue()).getSuccess() == false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map superiorInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperiorByDepempId", (Object[])new Object[]{this.depEmpIds});
        Map chargeInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargeWithParentByOrgId", (Object[])new Object[]{this.adminOrgIds, new Date()});
        List<Map<String, Long>> hrbuList = IDispatchHRCSService.getInstance().invokeGetHrBuByBusinessType(this.orgId2BusinessType, 1010L);
        HashMap adminOrgIdMap = ObjectUtils.isEmpty(hrbuList) ? new HashMap() : hrbuList.stream().collect(Collectors.toMap(temp -> (Long)temp.get("adminOrgId"), temp -> (Long)temp.get("hrBuId"), (k1, k2) -> k1));
        dataList.stream().forEach(item -> {
            this.workPlaceIds.add(item.getLong("baselocationin.id"));
            this.workPlaceIds.add(item.getLong("baselocationback.id"));
        });
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_workplace", (String)"country.id,country.name,country.number", (QFilter[])new QFilter[]{new QFilter("id", "in", this.workPlaceIds)});
        for (DynamicObject dynamicObject : dataList) {
            String personNumber = dynamicObject.getString("personnumber");
            String personName = dynamicObject.getString("personname");
            Date dispatchStartDate = dynamicObject.getDate("startdate");
            DispatchInfo dispatchInfo = dispatchInfoMap.get(personNumber + personName + HRDateTimeUtils.format((Date)dispatchStartDate));
            if (dispatchInfo == null || initOutMessageMap.containsKey(dispatchInfo.getMidTableId())) continue;
            DynamicObject dispatchErManFile = dispatchInfo.getDispatchErManFileList().get(0);
            dynamicObject.set("org_id", dispatchErManFile.get("org.id"));
            dynamicObject.set("ermanfile_id", dispatchErManFile.get("id"));
            Date endDate = dispatchInfo.getDispatchEndDate();
            dynamicObject.set("enddate", (Object)endDate);
            dynamicObject.set("dispstatus", (Object)this.getDispatchStatus(endDate));
            this.setLongValue("dependency.id", dispatchErManFile, "dependencyin_id", dynamicObject);
            this.setLongValue("dependencytype.id", dispatchErManFile, "dependencytypein_id", dynamicObject);
            dynamicObject.set("cmpempin_id", dispatchErManFile.get("hbsscmpemp.id"));
            this.setLongValue("empgroup.id", dispatchErManFile, "empgroupin_id", dynamicObject);
            dynamicObject.set("companyin_id", dispatchErManFile.get("empposrel.company.id"));
            long deptIn = dispatchErManFile.getLong("empposrel.adminorg.id");
            if (deptIn != 0L) {
                dynamicObject.set("deptin_id", (Object)deptIn);
                dynamicObject.set("adminorgin_id", (Object)deptIn);
                dynamicObject.set("orgin_id", adminOrgIdMap.get(deptIn));
            }
            this.setMultiBaseDataProp(dynamicObject, "insuperior", superiorInfo.get(dispatchErManFile.getLong("depemp.id")));
            this.setMultiBaseDataProp(dynamicObject, "inincharge", chargeInfo.get(deptIn));
            long workPlaceId = dispatchErManFile.getLong("empposrel.workplace.id");
            if (workPlaceId != 0L) {
                dynamicObject.set("baselocationin_id", (Object)workPlaceId);
            } else {
                workPlaceId = dynamicObject.getLong("baselocationin.id");
            }
            this.setCountryId(dynamicObject, "countryin_id", (DynamicObject)entityCfMap.get(workPlaceId));
            dynamicObject.set("pospatternin", dispatchErManFile.get("empposrel.apositiontype"));
            dynamicObject.set("standardposin_id", dispatchErManFile.get("empposrel.stdposition.id"));
            dynamicObject.set("jobin_id", dispatchErManFile.get("empposrel.job.id"));
            dynamicObject.set("indarkposition_id", dispatchErManFile.get("empposrel.darkposition.id"));
            dynamicObject.set("positionin_id", dispatchErManFile.get("empposrel.position.id"));
            Date startDate = dynamicObject.getDate("startdate");
            Date planEndDate = dynamicObject.getDate("planenddate");
            if (!DateUtils.isSameDay((Date)FUTURE_DATE, (Date)planEndDate)) {
                dynamicObject.set("planduration", (Object)HRDateTimeUtils.getDurationToDatabase((Date)startDate, (Date)planEndDate));
            }
            dynamicObject.set("reachdate", (Object)startDate);
            DynamicObject mainErManFile = dispatchInfo.getErManFileList().get(0);
            dynamicObject.set("companyout_id", mainErManFile.get("empposrel.company.id"));
            long deptOut = mainErManFile.getLong("empposrel.adminorg.id");
            dynamicObject.set("deptout_id", (Object)deptOut);
            dynamicObject.set("adminorgout_id", (Object)deptOut);
            dynamicObject.set("standardposout_id", mainErManFile.get("empposrel.stdposition.id"));
            dynamicObject.set("positionout_id", mainErManFile.get("empposrel.position.id"));
            dynamicObject.set("jobout_id", mainErManFile.get("empposrel.job.id"));
            long depEmpId = mainErManFile.getLong("depemp.id");
            dynamicObject.set("depemp_id", (Object)depEmpId);
            dynamicObject.set("orgout_id", mainErManFile.get("org.id"));
            dynamicObject.set("empgroupout_id", mainErManFile.get("empgroup.id"));
            long workPlaceOut = mainErManFile.getLong("empposrel.workplace.id");
            if (workPlaceOut != 0L) {
                this.setCountryId(dynamicObject, "countryout_id", (DynamicObject)entityCfMap.get(workPlaceOut));
            }
            this.setMultiBaseDataProp(dynamicObject, "outsuperior", superiorInfo.get(depEmpId));
            this.setMultiBaseDataProp(dynamicObject, "outincharge", chargeInfo.get(deptOut));
            Date leaveDate = dynamicObject.getDate("leavedate");
            if (leaveDate == null) {
                dynamicObject.set("leavedate", (Object)startDate);
            }
            if (HRStringUtils.equals((String)dynamicObject.getString("dispstatus"), (String)DispatchRecordStatusEnum.INVALID.getCode())) {
                int size;
                List<DynamicObject> backErManFileList = dispatchInfo.getBackErManFileList();
                int n = size = backErManFileList == null ? 0 : backErManFileList.size();
                if (backErManFileList == null || size != 1) {
                    this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), String.format(ResManager.loadKDString((String)"\u6d3e\u8fd4\u4e3b\u4efb\u804c\u7ecf\u5386\u5b58\u5728\u95ee\u9898\u3002\uff08\u5b58\u5728\u95ee\u9898\u7684\u6570\u636e\u6761\u6570\uff1a%s)", (String)"DispatchRecordInitDataService_7", (String)"hr-ham-business", (Object[])new Object[0]), size));
                    continue;
                }
                DynamicObject backDy = backErManFileList.get(0);
                dynamicObject.set("companyback_id", backDy.get("empposrel.company.id"));
                Object deptBack = backDy.get("empposrel.adminorg.id");
                dynamicObject.set("deptback_id", deptBack);
                dynamicObject.set("adminorgback_id", deptBack);
                dynamicObject.set("positionback_id", backDy.get("empposrel.position.id"));
                dynamicObject.set("jobback_id", backDy.get("empposrel.job.id"));
                dynamicObject.set("poststandardback_id", backDy.get("empposrel.stdposition.id"));
                long workPlace = backDy.getLong("empposrel.workplace.id");
                if (!ObjectUtils.isEmpty((Object)workPlace)) {
                    dynamicObject.set("baselocationback_id", (Object)workPlace);
                } else {
                    if (ObjectUtils.isEmpty((Object)dynamicObject.get("baselocationback"))) {
                        this.getInitOutParam().addErrorMsg(dispatchInfo.getMidTableId(), ResManager.loadKDString((String)"\u672a\u586b\u5199\u6216\u65e0\u6cd5\u83b7\u53d6\u6d3e\u8fd4\u5e38\u9a7b\u5730\uff0c\u8bf7\u8865\u5145\u6216\u68c0\u67e5\u6d3e\u8fd4\u5e38\u9a7b\u5730\u7f16\u7801\u540e\u518d\u8bd5\u3002", (String)"DispatchRecordInitDataService_8", (String)"hr-ham-business", (Object[])new Object[0]));
                        continue;
                    }
                    workPlace = dynamicObject.getLong("baselocationback.id");
                }
                dynamicObject.set("termsource", (Object)TermRecordSource.DISPATCH_BACK.getCode());
                this.setCountryId(dynamicObject, "countryback_id", (DynamicObject)entityCfMap.get(workPlace));
                dynamicObject.set("orgback", backDy.get("org.id"));
                dynamicObject.set("empgroupback_id", backDy.get("empgroup.id"));
                dynamicObject.set("backdate", (Object)endDate);
                if (Objects.nonNull(endDate) && !DateUtils.isSameDay((Date)FUTURE_DATE, (Date)endDate)) {
                    dynamicObject.set("duration", (Object)HRDateTimeUtils.getDurationToDatabase((Date)startDate, (Date)endDate));
                } else {
                    dynamicObject.set("enddate", (Object)FUTURE_DATE);
                }
            } else {
                dynamicObject.set("countryback_id", null);
                dynamicObject.set("companyback_id", null);
                dynamicObject.set("deptback_id", null);
                dynamicObject.set("poststandardback_id", null);
                dynamicObject.set("positionback_id", null);
                dynamicObject.set("baselocationback_id", null);
                dynamicObject.set("backdate", null);
                dynamicObject.set("dispbackreason_id", null);
                dynamicObject.set("duration", null);
                dynamicObject.set("deptlongnumbackvid", null);
                dynamicObject.set("orgback_id", null);
                dynamicObject.set("adminorgback_id", null);
                dynamicObject.set("empgroupback_id", null);
                dynamicObject.set("orglongnumbackvid", null);
                dynamicObject.set("adminorglongnumbackvid", null);
                dynamicObject.set("dispback", null);
            }
            this.getInitOutParam().addSuccessMsg(dispatchInfo.getMidTableId(), "", "");
            dynamicObjectList.add(dynamicObject);
        }
        if (!CollectionUtils.isEmpty(dynamicObjectList)) {
            this.setInitDefalutValue(dynamicObjectList);
            long userId = RequestContext.get().getCurrUserId();
            Date now = DispatchDateUtils.now();
            dynamicObjectList.forEach(dy -> DyObjOperateUtils.updateOperateInfo((DynamicObject)dy, (Date)now, (long)userId));
            HamHistoryModelService.getInstance().noLineTimeHisSave(dynamicObjectList.toArray(new DynamicObject[0]));
        }
    }

    private Map<String, DispatchInfo> getDispatchInfoMap() {
        if (!CollectionUtils.isEmpty(this.dispatchInfoMap)) {
            return this.dispatchInfoMap;
        }
        Map infoWithMap = this.getInfoWithMap();
        List data = (List)infoWithMap.get("data");
        Map initOutMessageMap = this.getInitOutParam().getData();
        data = data.stream().filter(info -> !initOutMessageMap.containsKey(info.get("id"))).collect(Collectors.toList());
        int size = data.size();
        ArrayList personNumberList = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList personNameList = Lists.newArrayListWithExpectedSize((int)size);
        data.stream().forEach(item -> {
            personNumberList.add((String)item.get("personnumber"));
            personNameList.add((String)item.get("personname"));
        });
        DynamicObject[] erManFileDys = this.getErManFile(personNumberList, personNameList);
        if (erManFileDys.length == 0) {
            return new HashMap<String, DispatchInfo>();
        }
        HashMap erManFileMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap orgId2BusinessType = Maps.newHashMapWithExpectedSize((int)size);
        ArrayList depEmpIds = Lists.newArrayListWithExpectedSize((int)size);
        ArrayList adminOrgIds = Lists.newArrayListWithExpectedSize((int)size);
        HashSet workPlaceIds = Sets.newHashSetWithExpectedSize((int)size);
        HashSet<Long> businessTypeIds = new HashSet<Long>(2);
        businessTypeIds.add(103010L);
        Arrays.stream(erManFileDys).forEach(dy -> {
            String key = dy.getString("number") + dy.getString("name");
            erManFileMap.put(key, this.setList((List)erManFileMap.get(key), (DynamicObject)dy));
            depEmpIds.add(dy.getLong("depemp.id"));
            long adminOrgId = dy.getLong("empposrel.adminorg.id");
            if (adminOrgId != 0L) {
                adminOrgIds.add(adminOrgId);
                orgId2BusinessType.put(adminOrgId, businessTypeIds);
            }
            workPlaceIds.add(dy.getLong("empposrel.workplace.id"));
        });
        this.depEmpIds = depEmpIds;
        this.adminOrgIds = adminOrgIds;
        this.workPlaceIds = workPlaceIds;
        this.orgId2BusinessType = orgId2BusinessType;
        Map<Long, Long> categoryMap = PostTypeRepository.getInstance().getCategoryMap();
        HashMap dispatchInfoMap = Maps.newHashMapWithExpectedSize((int)data.size());
        for (Map excelData : data) {
            DispatchInfo dispatchInfo = new DispatchInfo();
            dispatchInfo.setMidTableId((Long)excelData.get("id"));
            dispatchInfo.setDispatchBackReason((String)excelData.get("dispbackreason"));
            Date dispatchStartDate = DispatchDateUtils.getDate(excelData.get("startdate"), (String)PATTERN);
            dispatchInfo.setDispatchStartDate(dispatchStartDate);
            Date dispatchEndDate = DispatchDateUtils.getDate(excelData.get("enddate"), (String)PATTERN);
            if (dispatchEndDate == null) {
                dispatchEndDate = FUTURE_DATE;
            }
            dispatchInfo.setDispatchEndDate(dispatchEndDate);
            String number = (String)excelData.get("personnumber");
            String name = (String)excelData.get("personname");
            dispatchInfoMap.put(number + name + HRDateTimeUtils.format((Date)dispatchStartDate), dispatchInfo);
            List erManFileList = (List)erManFileMap.get(number + name);
            if (erManFileList == null) continue;
            for (DynamicObject dy2 : erManFileList) {
                Long categoryId = categoryMap.get(dy2.getLong("empposrel.postype.id"));
                String isPrimary = dy2.getString("empposrel.isprimary");
                Date startDate = DispatchRecordInitDataService.formateDate(dy2.getDate("startdate"), PATTERN);
                Date endDate = DispatchRecordInitDataService.formateDate(dy2.getDate("enddate"), PATTERN);
                if ("1".equals(isPrimary) && 1010L == categoryId) {
                    if (!HRDateTimeUtils.dayAfter((Date)startDate, (Date)dispatchStartDate) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)dispatchStartDate)) {
                        dispatchInfo.setErManFileList(this.setList(dispatchInfo.getErManFileList(), dy2));
                    }
                    if (!HRDateTimeUtils.dayAfter((Date)startDate, (Date)dispatchEndDate) && !HRDateTimeUtils.dayBefore((Date)endDate, (Date)dispatchEndDate)) {
                        dispatchInfo.setBackErManFileList(this.setList(dispatchInfo.getBackErManFileList(), dy2));
                    }
                }
                if (1040L != categoryId || !HRDateTimeUtils.dayEquals((Date)startDate, (Date)dispatchStartDate)) continue;
                dispatchInfo.setDispatchErManFileList(this.setList(dispatchInfo.getDispatchErManFileList(), dy2));
            }
        }
        this.dispatchInfoMap = dispatchInfoMap;
        return dispatchInfoMap;
    }

    private DynamicObject[] getErManFile(List<String> personNumberList, List<String> personNameList) {
        QFilter filter = new QFilter("datastatus", "=", (Object)"1").and(new QFilter("initstatus", "=", (Object)"2")).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("filetype.erfiletypeassign", "!=", (Object)1030L));
        QFilter personFilter = new QFilter("number", "in", personNumberList).and(new QFilter("name", "in", personNameList));
        DynamicObject[] dys = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"getErManFile", (Object[])new Object[]{null, null, filter.and(personFilter)});
        LOG.info("dispatchRecordInit->getErManFile person number:{},person name:{}, result:{}", new Object[]{personNumberList, personNameList, dys});
        return dys;
    }

    private Map<Long, List<DynamicObject>> getDispatchRecords() {
        DynamicObject[] dys = DispatchRecordService.getInstance().listDisRecord(this.depEmpIds);
        HashMap recordMap = Arrays.stream(dys).collect(Collectors.groupingBy(dy -> dy.getLong("depemp.id")));
        return recordMap == null ? new HashMap() : recordMap;
    }

    private String getDispatchStatus(Date endDate) {
        if (HRDateTimeUtils.isAfterNow((Date)endDate)) {
            return DispatchRecordStatusEnum.VALID.getCode();
        }
        return DispatchRecordStatusEnum.INVALID.getCode();
    }

    private static Date formateDate(Date date, String format) {
        Date result = date;
        try {
            result = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)date, (String)format));
        }
        catch (ParseException exception) {
            LOG.error((Throwable)exception);
        }
        return result;
    }

    private void setLongValue(String oldKey, DynamicObject oldDy, String newKey, DynamicObject newDy) {
        long value = oldDy.getLong(oldKey);
        if (value != 0L) {
            newDy.set(newKey, (Object)value);
        }
    }

    private void setCountryId(DynamicObject dy, String key, DynamicObject workPlace) {
        if (workPlace != null) {
            dy.set(key, workPlace.get("country.id"));
        }
    }

    private List<DynamicObject> setList(List<DynamicObject> list, DynamicObject dy) {
        if (list == null) {
            list = new ArrayList<DynamicObject>();
        }
        list.add(dy);
        return list;
    }

    private void setMultiBaseDataProp(DynamicObject dynamicObject, String prop, Object obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        List infoList = (List)obj;
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(prop);
        DynamicObjectType dynamicObjectType = dynamicObjectCollection.getDynamicObjectType();
        for (Map info : infoList) {
            DynamicObject dy = new DynamicObject(dynamicObjectType);
            Object value = info.get("person");
            Object v = value = value == null ? info.get("person.id") : value;
            if (value == null) continue;
            dy.set("fbasedataid_id", value);
            dynamicObjectCollection.add((Object)dy);
        }
    }

    private static class DispatchInfo {
        private Long midTableId;
        private Date dispatchStartDate;
        private Date dispatchEndDate;
        private String dispatchBackReason;
        private List<DynamicObject> dispatchErManFileList;
        private List<DynamicObject> erManFileList;
        private List<DynamicObject> backErManFileList;

        private DispatchInfo() {
        }

        public Long getMidTableId() {
            return this.midTableId;
        }

        public void setMidTableId(Long midTableId) {
            this.midTableId = midTableId;
        }

        public List<DynamicObject> getErManFileList() {
            return this.erManFileList;
        }

        public void setErManFileList(List<DynamicObject> erManFileList) {
            this.erManFileList = erManFileList;
        }

        public List<DynamicObject> getBackErManFileList() {
            return this.backErManFileList;
        }

        public void setBackErManFileList(List<DynamicObject> backErManFileList) {
            this.backErManFileList = backErManFileList;
        }

        public Date getDispatchStartDate() {
            return this.dispatchStartDate;
        }

        public DispatchInfo setDispatchStartDate(Date dispatchStartDate) {
            this.dispatchStartDate = dispatchStartDate;
            return this;
        }

        public Date getDispatchEndDate() {
            return this.dispatchEndDate;
        }

        public void setDispatchEndDate(Date dispatchEndDate) {
            this.dispatchEndDate = dispatchEndDate;
        }

        public List<DynamicObject> getDispatchErManFileList() {
            return this.dispatchErManFileList;
        }

        public DispatchInfo setDispatchErManFileList(List<DynamicObject> dispatchErManFileList) {
            this.dispatchErManFileList = dispatchErManFileList;
            return this;
        }

        public String getDispatchBackReason() {
            return this.dispatchBackReason;
        }

        public void setDispatchBackReason(String dispatchBackReason) {
            this.dispatchBackReason = dispatchBackReason;
        }
    }
}

