/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.impl.record;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordBusEventRepository;
import kd.hr.ham.business.domain.repository.dispatchrecord.DispatchRecordRepository;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.common.IPersonAboutService;
import kd.hr.ham.business.domain.service.common.IPersonalChangeExternalService;
import kd.hr.ham.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.ham.business.domain.service.history.HamHistoryModelService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.business.domain.service.validator.ValidateProducer;
import kd.hr.ham.common.dispatch.bean.CreateRecordDto;
import kd.hr.ham.common.dispatch.constants.AffactionConstants;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.DispatchRecordStatusEnum;
import kd.hr.ham.common.dispatch.enums.record.TermRecordTaskStatus;
import kd.hr.ham.common.dispatch.utils.DyObjOperateUtils;
import kd.hr.ham.common.dispatch.utils.HamResultUtils;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisTransRevocationListBo;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.http.util.Asserts;

public class DispatchRecordServiceImpl
implements DispatchRecordService {
    private static final Log LOG = LogFactory.getLog(DispatchRecordServiceImpl.class);
    private static final DispatchRecordRepository RECORD_REPOSITORY = DispatchRecordRepository.getInstance();

    @Override
    public Map<String, Object> createRecord(CreateRecordDto createRecordDto) {
        Map<String, Object> checkResult = this.checkCreateParam(createRecordDto);
        if (!HamResultUtils.isSuccess(checkResult)) {
            return checkResult;
        }
        DynamicObject dispatchDt = DispatchRepository.getInstance().queryOne(createRecordDto.getDispatchId());
        if (dispatchDt == null) {
            LOG.warn("createRecord no dispatch\uff1a", (Object)createRecordDto.toString());
            return HamResultUtils.fail((Object)"createRecord no dispatch");
        }
        LOG.info("createRecord start\uff1a", (Object)createRecordDto.toString());
        try {
            DynamicObject record = this.createRecord(dispatchDt, createRecordDto.getNewErmanFileId());
            HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{record});
            return HamResultUtils.success((Object)record);
        }
        catch (Exception exception) {
            LOG.error("createRecord error: ", (Throwable)exception);
            return HamResultUtils.fail((Object)exception.getMessage());
        }
    }

    @Override
    public DyObjValidateContext dispatchBackValidate(DynamicObject dynamicObject) {
        DyObjValidateContext dyObjValidateContext = ValidateProducer.init(dynamicObject);
        String recordStatusErrorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]);
        String termTaskStatusMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]);
        ValidateProducer.produce("dispstatus", recordStatusErrorMsg, context -> {
            DynamicObject dy = context.getDynamicObject();
            return HRStringUtils.equals((String)dy.getString("dispstatus"), (String)DispatchRecordStatusEnum.VALID.getCode());
        }).and(ValidateProducer.produce("termtaskstatus", termTaskStatusMsg, context -> {
            DynamicObject dy = context.getDynamicObject();
            return !HRStringUtils.equals((String)dy.getString("termtaskstatus"), (String)TermRecordTaskStatus.PROCESSING.getCode());
        })).and(context -> {
            DynamicObject dy = context.getDynamicObject();
            boolean hasTempRecord = RECORD_REPOSITORY.hasTempRecord(dy.getLong("boid"));
            if (!hasTempRecord) {
                return true;
            }
            context.getValidatorContext().setResult("termtaskstatus", termTaskStatusMsg);
            return false;
        }).test(dyObjValidateContext);
        return dyObjValidateContext;
    }

    @Override
    public DyObjValidateContext changeRecordValidate(DynamicObject dynamicObject) {
        DyObjValidateContext dyObjValidateContext = ValidateProducer.init(dynamicObject);
        String recordStatusErrorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]);
        String termTaskStatusMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]);
        ValidateProducer.produce("dispstatus", recordStatusErrorMsg, context -> {
            DynamicObject dy = context.getDynamicObject();
            return HRStringUtils.equals((String)dy.getString("dispstatus"), (String)DispatchRecordStatusEnum.VALID.getCode());
        }).and(context -> {
            DynamicObject dy = context.getDynamicObject();
            boolean hasTempRecord = RECORD_REPOSITORY.hasTempRecord(dy.getLong("boid"));
            if (!hasTempRecord) {
                return true;
            }
            context.getValidatorContext().setResult("termtaskstatus", recordStatusErrorMsg);
            return false;
        }).test(dyObjValidateContext);
        return dyObjValidateContext;
    }

    @Override
    public DyObjValidateContext terminateRecordValidate(DynamicObject dynamicObject) {
        DyObjValidateContext dyObjValidateContext = ValidateProducer.init(dynamicObject);
        String recordStatusErrorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0]);
        String termTaskStatusMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5b58\u5728\u201c\u5f85\u751f\u6548\u201d\u7684\u7ec8\u6b62\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_6", (String)"hr-ham-business", (Object[])new Object[0]);
        ValidateProducer.produce("dispstatus", recordStatusErrorMsg, context -> {
            DynamicObject dy = context.getDynamicObject();
            return HRStringUtils.equals((String)dy.getString("dispstatus"), (String)DispatchRecordStatusEnum.VALID.getCode());
        }).and(ValidateProducer.produce("termtaskstatus", termTaskStatusMsg, context -> {
            DynamicObject dy = context.getDynamicObject();
            String termTaskStatus = dy.getString("termtaskstatus");
            return !HRStringUtils.equals((String)termTaskStatus, (String)TermRecordTaskStatus.PROCESSING.getCode());
        })).and(context -> {
            DynamicObject dy = context.getDynamicObject();
            boolean hasTempRecord = RECORD_REPOSITORY.hasTempRecord(dy.getLong("boid"));
            if (!hasTempRecord) {
                return true;
            }
            context.getValidatorContext().setResult("termtaskstatus", termTaskStatusMsg);
            return false;
        }).and(context -> {
            DynamicObject dy = context.getDynamicObject();
            DynamicObject recordChange = RecordChangeRepository.getInstance().queryProcessingByRecord(dy.getLong("id"));
            if (Objects.isNull(recordChange)) {
                return true;
            }
            String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u6863\u6848\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u4e8e\u53d8\u66f4\u5355\u636e\u201c%2$s\u201d\u4e2d\u3002", (String)"DispatchRecordServiceImpl_5", (String)"hr-ham-business", (Object[])new Object[0]);
            String name = recordChange.getDynamicObject("person").getString("name");
            context.getValidatorContext().setResult("dispchangenow", String.format(errorMsg, name, recordChange.getString("billno")));
            return false;
        }).and(context -> {
            DynamicObject dy = context.getDynamicObject();
            DynamicObject dispatchBack = DispatchBackRepository.getInstance().queryUsefulByRecord(dy.getLong("id"));
            if (Objects.isNull(dispatchBack)) {
                return true;
            }
            String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4eba\u5458\u5df2\u6709\u5ba1\u6279\u4e2d\u7684\u6d3e\u8fd4\u5355\u201c%s\u201d\u3002", (String)"DispatchRecordServiceImpl_1", (String)"hr-ham-business", (Object[])new Object[0]);
            if (HRStringUtils.equals((String)dispatchBack.getString("billstatus"), (String)DispatchAuditStatusEnum.APPROVEPASSED.getCode())) {
                errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4eba\u5458\u5df2\u6709\u5f85\u751f\u6548\u7684\u6d3e\u8fd4\u5355\u201c%s\u201d\u3002", (String)"DispatchRecordServiceImpl_2", (String)"hr-ham-business", (Object[])new Object[0]);
            }
            context.getValidatorContext().setResult("dispback", String.format(Locale.ROOT, errorMsg, dispatchBack.getString("billno")), Boolean.FALSE);
            return false;
        }).test(dyObjValidateContext);
        return dyObjValidateContext;
    }

    @Override
    public boolean terminateRecord(DynamicObject dispatchBack) {
        long erManFile = dispatchBack.getDynamicObject("ermanfile").getLong("id");
        Throwable throwable = null;
        try (TXHandle txHandle = TX.required((String)"terminateRecord");){
            LOG.info("terminateRecord erManFile:{},dispatchBack:{}", (Object)erManFile, (Object)dispatchBack.getLong("id"));
            DynamicObject dispRecord = RECORD_REPOSITORY.queryCurrentValidOneByErFileId(erManFile);
            if (dispRecord.getBoolean("ismodify")) {
                DynamicObject tempRecord = RECORD_REPOSITORY.queryTempByBoId(dispRecord.getLong("boid"));
                tempRecord.set("termtaskstatus", (Object)"2");
                this.updateBack2Record(dispatchBack, tempRecord);
                HamHistoryModelService.getInstance().noLineTimeHisEffectTemp(new DynamicObject[]{tempRecord});
            } else {
                this.updateBack2Record(dispatchBack, dispRecord);
                dispRecord.set("dispstatus", (Object)DispatchRecordStatusEnum.INVALID.getCode());
                dispRecord.set("termsource", (Object)"1");
                DyObjOperateUtils.updateModifyInfo((DynamicObject)dispRecord);
                HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{dispRecord}, true);
            }
            dispatchBack.set("effectstatus", (Object)"2");
            dispatchBack.set("effecttime", (Object)new Date());
            dispatchBack.set("auditstatus", (Object)DisAuditStatusEnum.PROCESSED.getCode());
            DispatchBackRepository.getInstance().saveOne(dispatchBack);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            txHandle.markRollback();
            LOG.error("terminate record error: ", (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public boolean termBeforePersonTransValidByErManFile(long erManFileId, Object backLocation, Date endDate, Object termReason) {
        try {
            DynamicObject dispRecord = RECORD_REPOSITORY.queryCurrentValidOneByErFileId(erManFileId);
            LOG.info("termBeforePersonTransValid erManFileId:{},dispatchRecord:{}", (Object)erManFileId, (Object)dispRecord.getLong("id"));
            DispatchBackRepository backRepository = DispatchBackRepository.getInstance();
            DynamicObject newDispBack = backRepository.generateEmptyDynamicObject();
            DynamicObject dispBack = DispatchBackRepository.getInstance().queryUsefulByErManFile(erManFileId);
            if (Objects.nonNull(dispBack)) {
                IDispatchBackBillService.getInstance().terminate(dispBack, ResManager.loadKDString((String)"\u5916\u6d3e\u6863\u6848\u64cd\u4f5c\u7ec8\u6b62\uff0c\u5728\u9014\u6d3e\u8fd4\u5355\u6267\u884c\u201c\u5e9f\u5f03\u201d\u64cd\u4f5c\u3002", (String)"DispatchRecordServiceImpl_4", (String)"hr-ham-business", (Object[])new Object[0]));
                HRDynamicObjectUtils.copy((DynamicObject)dispBack, (DynamicObject)newDispBack);
            }
            newDispBack.set("id", (Object)ORM.create().genLongId(backRepository.getEntityName()));
            newDispBack.set("genbytermrecord", (Object)"0");
            newDispBack.set("baselocationback", backLocation);
            newDispBack.set("backstatus", (Object)DispatchBackStatusEnum.PASS.getCode());
            newDispBack.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)backRepository.getEntityName(), (DynamicObject)newDispBack, null));
            newDispBack.set("dispatchrecord", (Object)dispRecord.getLong("id"));
            newDispBack.set("ermanfile", dispRecord.get("ermanfile"));
            newDispBack.set("startdate", dispRecord.get("startdate"));
            DynamicObjectType dynamicObjectType = newDispBack.getDynamicObjectType();
            BasedataProp affAction = (BasedataProp)dynamicObjectType.getProperty("affaction");
            boolean businessValue = HPFSTemplatePropertyHandler.isNewChgAction("ham_dispatch_hpfs_new");
            if (businessValue) {
                newDispBack.set(affAction.getName(), (Object)AffactionConstants.DISP_END_AFFACTION_NEW);
                DynamicObject primaryErManFile = IPersonAboutService.getInstance().getPrimaryErManFile(dispRecord.getDynamicObject("ermanfile").getLong("employee_id"));
                if (primaryErManFile == null) {
                    LOG.error("DispatchRecordServiceImpl.termBeforePersonTransValidByErManFile CAN NOT FIND primaryErManFile");
                } else {
                    long mainErmanFile = primaryErManFile.getLong("id");
                    Map<String, Object> params = IPersonAboutService.getInstance().getCardFields(mainErmanFile);
                    Map<String, Object> backInitParam = IDispatchBackBillService.getInstance().buildBackAreaParam(params);
                    backInitParam.forEach((key, value) -> newDispBack.set(key, value));
                    Map<String, Object> recordInitParam = IDispatchBackBillService.getInstance().buildRecordAreaParam(dispRecord);
                    recordInitParam.forEach((key, value) -> newDispBack.set(key, value));
                }
            } else {
                Optional.ofNullable(affAction.getDefValue2()).flatMap(obj -> Optional.ofNullable(obj.getFuncParameter())).ifPresent(param -> newDispBack.set(affAction.getName(), JSON.parseObject((String)param).get((Object)"id")));
            }
            newDispBack.set("enddate", (Object)endDate);
            newDispBack.set("effectstatus", (Object)"0");
            newDispBack.set("submitnoticstatus", (Object)"0");
            newDispBack.set("stopnoticstatus", (Object)"0");
            DyObjOperateUtils.updateOperateInfo((DynamicObject)newDispBack);
            backRepository.saveOne(newDispBack);
            LOG.info("termBeforePersonTransValid invoke PersonChange, dispatchBack:{}", (Object)newDispBack.getLong("id"));
            IDispabackPersonChangeService.getInstance().disprecordPersonChangeNoticeStop(new DynamicObject[]{newDispBack});
            this.updateBack2Record(newDispBack, dispRecord);
            dispRecord.set("dispreasonend", termReason);
            dispRecord.set("dispstatus", (Object)DispatchRecordStatusEnum.INVALID.getCode());
            dispRecord.set("termtaskstatus", (Object)TermRecordTaskStatus.PROCESSING.getCode());
            dispRecord.set("termsource", (Object)"2");
            HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{dispRecord}, false);
        }
        catch (Exception exception) {
            LOG.info("termBeforePersonTransValid error: ", (Object)exception);
            return false;
        }
        return true;
    }

    @Override
    public boolean terminateRecordByPerson(long personId, Object termReason, Date endDate) {
        try (TXHandle txHandle = TX.required((String)"terminateRecordByPerson");){
            DynamicObject dispRecord = RECORD_REPOSITORY.queryCurrentValidOneByPerson(personId);
            if (Objects.isNull(dispRecord)) {
                LOG.warn("terminateRecordByPerson dispRecord is null, personId:{}", (Object)personId);
                boolean bl = false;
                return bl;
            }
            try {
                if (dispRecord.getBoolean("ismodify")) {
                    DynamicObject tempRecord = RECORD_REPOSITORY.queryTempByBoId(dispRecord.getLong("boid"));
                    tempRecord.set("termtaskstatus", (Object)"2");
                    tempRecord.set("enddate", (Object)endDate);
                    HamHistoryModelService.getInstance().noLineTimeHisEffectTemp(new DynamicObject[]{tempRecord});
                } else {
                    dispRecord.set("enddate", (Object)endDate);
                    dispRecord.set("dispstatus", (Object)DispatchRecordStatusEnum.INVALID.getCode());
                    dispRecord.set("termsource", (Object)"2");
                    dispRecord.set("dispreasonend", termReason);
                    DyObjOperateUtils.updateOperateInfo((DynamicObject)dispRecord);
                    HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{dispRecord});
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOG.info("termBeforePersonTransValid error: ", (Object)exception);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public boolean changeRecord(DynamicObject recordChange) {
        if (Objects.isNull(recordChange)) {
            return false;
        }
        DynamicObject recordFormChange = recordChange.getDynamicObject("dispatchrecord");
        if (Objects.isNull(recordFormChange)) {
            return false;
        }
        LOG.info("changeRecord, recordChangeId:{}", (Object)recordChange.getLong("id"));
        DynamicObject dispatchRecord = DispatchRecordRepository.getInstance().queryCurrentOneByRecord(recordFormChange.getLong("id"));
        if (dispatchRecord.getBoolean("ismodify")) {
            throw new KDBizException(String.format(Locale.ROOT, "record:{%s} is changing", dispatchRecord.getString("id")));
        }
        dispatchRecord.set("disptype", recordChange.get("plandisptype"));
        dispatchRecord.set("startdate", recordChange.get("planstartdate"));
        dispatchRecord.set("planenddate", recordChange.get("planenddate"));
        dispatchRecord.set("planduration", recordChange.get("planduration"));
        dispatchRecord.set("dispchangenow", recordChange.get("id"));
        DyObjOperateUtils.updateModifyInfo((DynamicObject)dispatchRecord);
        HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{dispatchRecord});
        return true;
    }

    @Override
    public boolean backPreValid(DynamicObject dispatchBack) {
        long erManFileId = dispatchBack.getDynamicObject("ermanfile").getLong("id");
        DynamicObject dispatchRecord = RECORD_REPOSITORY.queryCurrentValidOneByErFileId(erManFileId);
        this.updateBack2Record(dispatchBack, dispatchRecord);
        dispatchRecord.set("dispstatus", (Object)DispatchRecordStatusEnum.INVALID.getCode());
        dispatchRecord.set("termtaskstatus", (Object)TermRecordTaskStatus.PROCESSING.getCode());
        dispatchRecord.set("termsource", (Object)"1");
        HamHistoryModelService.getInstance().noLineTimeHisSave(new DynamicObject[]{dispatchRecord}, false);
        return false;
    }

    private Map<String, Object> checkCreateParam(CreateRecordDto createRecordDto) {
        if (createRecordDto == null) {
            LOG.warn("createRecord param cannot be null");
            return HamResultUtils.fail((Object)"createRecordDto is null");
        }
        Long dispatchId = createRecordDto.getDispatchId();
        if (Objects.isNull(dispatchId)) {
            LOG.warn("createRecord dispatchId cannot be null");
            return HamResultUtils.fail((Object)"dispatchId is null");
        }
        if (Objects.isNull(createRecordDto.getNewErmanFileId())) {
            LOG.warn("createRecord newErmanFileId cannot be null");
            return HamResultUtils.fail((Object)"newErmanFileId is null");
        }
        if (DispatchRecordRepository.getInstance().hasValidRecordByDispatch(dispatchId)) {
            LOG.warn("createRecord hasValidDispatchRecord, dispatchId:{}", (Object)dispatchId);
            return HamResultUtils.fail((Object)"hasValidDispatchRecord");
        }
        return HamResultUtils.success();
    }

    private DynamicObject createRecord(DynamicObject dispatchBill, long newErmanFileId) {
        DynamicObject dispatchRecord = RECORD_REPOSITORY.generateEmptyDynamicObject();
        dispatchRecord.set("id", (Object)ORM.create().genLongId(RECORD_REPOSITORY.getEntityName()));
        DynamicObject erManFile = dispatchBill.getDynamicObject("ermanfile");
        dispatchRecord.set("name", erManFile.getDynamicObject("filetype").get("name"));
        dispatchRecord.set("dispatch", (Object)dispatchBill.getLong("id"));
        dispatchRecord.set("org", dispatchBill.get("org"));
        dispatchRecord.set("ermanfile", (Object)newErmanFileId);
        dispatchRecord.set("dispstatus", (Object)DispatchRecordStatusEnum.VALID.getCode());
        dispatchRecord.set("depemp", erManFile.get("depemp"));
        dispatchRecord.set("countryout", dispatchBill.get("countryout"));
        dispatchRecord.set("companyout", dispatchBill.get("companyout"));
        dispatchRecord.set("deptout", dispatchBill.get("deptout"));
        dispatchRecord.set("standardposout", dispatchBill.get("standardposout"));
        dispatchRecord.set("leavedate", dispatchBill.get("leavedate"));
        dispatchRecord.set("positionout", dispatchBill.get("positionout"));
        dispatchRecord.set("outincharge", dispatchBill.get("dispatchaincharge"));
        dispatchRecord.set("outsuperior", dispatchBill.get("dispatchasuperior"));
        dispatchRecord.set("deptlongnumoutvid", dispatchBill.get("deptlongnumoutvid"));
        dispatchRecord.set("orgout", dispatchBill.get("orgout"));
        dispatchRecord.set("adminorgout", dispatchBill.get("adminorgout"));
        dispatchRecord.set("empgroupout", dispatchBill.get("empgroupout"));
        dispatchRecord.set("orglongnumoutvid", dispatchBill.get("orglongnumoutvid"));
        dispatchRecord.set("adminorglongnumoutvid", dispatchBill.get("adminorglongnumoutvid"));
        dispatchRecord.set("jobout", dispatchBill.get("jobout"));
        dispatchRecord.set("disptype", dispatchBill.get("disptype"));
        dispatchRecord.set("dispreason", dispatchBill.get("dispreason"));
        dispatchRecord.set("dependencyin", dispatchBill.get("dependencyin"));
        dispatchRecord.set("dependencytypein", dispatchBill.get("dependencytypein"));
        dispatchRecord.set("cmpempin", dispatchBill.get("cmpempin"));
        dispatchRecord.set("countryin", dispatchBill.get("countryin"));
        dispatchRecord.set("companyin", dispatchBill.get("companyin"));
        dispatchRecord.set("deptin", dispatchBill.get("deptin"));
        dispatchRecord.set("standardposin", dispatchBill.get("standardposin"));
        dispatchRecord.set("positionin", dispatchBill.get("positionin"));
        dispatchRecord.set("baselocationin", dispatchBill.get("baselocationin"));
        dispatchRecord.set("reachdate", dispatchBill.get("reachdate"));
        dispatchRecord.set("startdate", dispatchBill.get("startdate"));
        dispatchRecord.set("planenddate", dispatchBill.get("enddate"));
        dispatchRecord.set("planduration", dispatchBill.get("duration"));
        dispatchRecord.set("insuperior", dispatchBill.get("dispatchinsuperior"));
        dispatchRecord.set("inincharge", dispatchBill.get("dispatchinincharge"));
        dispatchRecord.set("deptlongnuminvid", dispatchBill.get("deptlongnuminvid"));
        dispatchRecord.set("orgin", dispatchBill.get("orgin"));
        dispatchRecord.set("adminorgin", dispatchBill.get("adminorgin"));
        dispatchRecord.set("empgroupin", dispatchBill.get("empgroupin"));
        dispatchRecord.set("orglongnuminvid", dispatchBill.get("orglongnuminvid"));
        dispatchRecord.set("adminorglongnuminvid", dispatchBill.get("adminorglongnuminvid"));
        dispatchRecord.set("jobin", dispatchBill.get("jobin"));
        dispatchRecord.set("pospatternin", dispatchBill.get("inradiogroupfield"));
        dispatchRecord.set("indarkposition", dispatchBill.get("indarkposition"));
        DyObjOperateUtils.updateOperateInfo((DynamicObject)dispatchRecord);
        return dispatchRecord;
    }

    private void updateBack2Record(DynamicObject dispatchBack, DynamicObject dispatchRecord) {
        Asserts.notNull((Object)dispatchBack, (String)"dispatchBack");
        Asserts.notNull((Object)dispatchRecord, (String)"dispatchRecord");
        dispatchRecord.set("countryback", dispatchBack.get("countryback"));
        dispatchRecord.set("companyback", dispatchBack.get("companyback"));
        dispatchRecord.set("adminorgback", dispatchBack.get("adminorgback"));
        dispatchRecord.set("poststandardback", dispatchBack.get("poststandardback"));
        dispatchRecord.set("positionback", dispatchBack.get("positionback"));
        dispatchRecord.set("baselocationback", dispatchBack.get("baselocationback"));
        dispatchRecord.set("backdate", dispatchBack.get("backdate"));
        dispatchRecord.set("dispbackreason", dispatchBack.get("dispbackreason"));
        dispatchRecord.set("duration", dispatchBack.get("duration"));
        dispatchRecord.set("deptlongnumbackvid", dispatchBack.get("deptlongnumbackvid"));
        dispatchRecord.set("orgback", dispatchBack.get("orgback"));
        dispatchRecord.set("adminorgback", dispatchBack.get("adminorgback"));
        dispatchRecord.set("empgroupback", dispatchBack.get("empgroupback"));
        dispatchRecord.set("adminorglongnumbackvid", dispatchBack.get("adminorglongnumbackvid"));
        dispatchRecord.set("dispback", dispatchBack.get("id"));
        dispatchRecord.set("enddate", dispatchBack.get("enddate"));
    }

    @Override
    public DynamicObject[] getRecordByDispatchIds(List<Long> ids) {
        QFilter statusFilter = new QFilter("dispstatus", "in", (Object)DispatchRecordStatusEnum.VALID.getCode());
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return DispatchRecordRepository.getInstance().query("dispstatus,dispatch,ermanfile,depemp", new QFilter[]{new QFilter("depemp.id", "in", ids), statusFilter.and(curVersion)});
    }

    @Override
    public DynamicObject queryOneDispatchRecord(Long ermanFileId) {
        return DispatchRecordRepository.getInstance().loadCurrentValidOneByErFileId(ermanFileId);
    }

    @Override
    public void rollbackDispatchRecord(Long recordId) {
        Map<String, Object> recordMap = IPersonalChangeExternalService.getInstance().getChgDetailByRecordId(recordId);
        if (ObjectUtils.isEmpty(recordMap)) {
            LOG.info("DispatchRecordServiceImpl.rollbackDispatchRecord can not find record,recordId:{}", (Object)recordId);
            return;
        }
        LOG.info("DispatchRecordServiceImpl.rollbackDispatchRecord query person info end:[{}]", recordMap);
        Map dataMap = (Map)recordMap.get("data");
        List peronInfoMap = (List)dataMap.get("data");
        List<Object> ermanfileIds = peronInfoMap.stream().filter(item -> "hspm_ermanfile".equals(item.get("entity")) && "2".equals(item.get("chgmode"))).map(item -> item.get("idafter")).collect(Collectors.toList());
        DynamicObject dy = DispatchRecordRepository.getInstance().queryInValidByErFileId(ermanfileIds);
        if (dy == null) {
            LOG.info("DispatchRecordServiceImpl.rollbackDispatchRecord end,can not find dispatch record.record={}", (Object)recordId);
            return;
        }
        DynamicObject busEventDy = DispatchRecordBusEventRepository.getInstance().getBusEvent(dy.getLong("id"));
        Long eventId = busEventDy.getLong("event");
        if (eventId != null && eventId != 0L) {
            HisTransRevocationListBo listHisBo = new HisTransRevocationListBo();
            listHisBo.setEventId(eventId);
            listHisBo.setResisterEventGroupAppId("1WXBRRPS+/I5");
            HisModelController.getInstance().revocationEvent(listHisBo);
        }
        LOG.info("DispatchRecordServiceImpl.rollbackDispatchRecord end,eventId:{}", (Object)eventId);
    }

    @Override
    public DynamicObject[] listDisRecord(Set<Long> depemps, Set<Date> dispatchStartDate) {
        QFilter depempFilter = new QFilter("depemp", "in", depemps);
        QFilter dispatchStartDateFilter = new QFilter("startdate", "in", dispatchStartDate);
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return DispatchRecordRepository.getInstance().query("depemp,startdate", new QFilter[]{depempFilter, dispatchStartDateFilter, curVersion});
    }

    @Override
    public DynamicObject[] listDisRecord(List<Long> depemps) {
        QFilter depempFilter = new QFilter("depemp", "in", depemps);
        QFilter curVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        return DispatchRecordRepository.getInstance().query("depemp,startdate", new QFilter[]{depempFilter, curVersion});
    }
}

