/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.service.invoke;

import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.service.invoke.InvokeParam;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class InvokeHandler<T> {
    private static final Log LOGGER = LogFactory.getLog(InvokeHandler.class);
    private static final InvokeHandler invokeHandler = new InvokeHandler();

    private InvokeHandler() {
    }

    public static InvokeHandler getInstance() {
        return invokeHandler;
    }

    public T invokeService(InvokeParam invokeParam, Object ... param) {
        return this.invokeService(param).apply(invokeParam);
    }

    private Function<InvokeParam, T> invokeService(Object ... param) {
        return invokeParam -> {
            StopWatch stopWatch = new StopWatch(invokeParam.getMethodId());
            try {
                stopWatch.start();
                LOGGER.info("InvokeHandler start invoke " + invokeParam.getMethodId());
                Object invokeResult = HRMServiceHelper.invokeBizService((String)invokeParam.getCloudId(), (String)invokeParam.getAppId(), (String)invokeParam.getServiceId(), (String)invokeParam.getMethodId(), (Object[])param);
                LOGGER.info("InvokeHandler invoke {} result :{} ", (Object)invokeParam.getMethodId(), (Object)invokeResult.toString());
                Object object = invokeResult;
                return object;
            }
            catch (Exception e) {
                LOGGER.error("InvokeHandler Invoke " + invokeParam.getMethodId() + " error info: " + e.getMessage());
            }
            finally {
                stopWatch.stop();
                LOGGER.info("InvokeHandler finish invoke +" + invokeParam.getMethodId() + "cost time : " + stopWatch.getNanoTime());
            }
            return null;
        };
    }
}

