/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.status.config;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ham.business.domain.status.config.OperateConfig;
import kd.hr.ham.business.domain.status.dto.StatusFieldDto;
import kd.hr.ham.common.dispatch.constants.operate.DispBackOpCode;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispBackOperateConfig
implements OperateConfig,
DispBackOpCode {
    private static DispBackOperateConfig CONFIG = new DispBackOperateConfig();
    private Map<String, List<StatusFieldDto>> map = Maps.newHashMapWithExpectedSize((int)6);

    private DispBackOperateConfig() {
        this.init("wfauditing", DispatchAuditStatusEnum.APPROVING, DispatchBackStatusEnum.APPROVING);
        this.init("submit", DispatchAuditStatusEnum.ALREADYSUBMIT, DispatchBackStatusEnum.ALR_SUBMIT);
        this.init("wfrejecttosubmit", DispatchAuditStatusEnum.WAITRESUBMIT, DispatchBackStatusEnum.WAIT_RESUBMIT);
        this.init("audit", DispatchAuditStatusEnum.APPROVEPASSED, DispatchBackStatusEnum.PASS);
        this.init("wfauditnotpass", DispatchAuditStatusEnum.APPROVEREJECTED, DispatchBackStatusEnum.NOT_PASS);
        this.init("discard_bill", DispatchAuditStatusEnum.STOPED, DispatchBackStatusEnum.DISCARD);
        this.init("unsubmit", DispatchAuditStatusEnum.TEMPSTORAGE, DispatchBackStatusEnum.WAIT_SUBMIT);
    }

    public static DispBackOperateConfig getInstance() {
        return CONFIG;
    }

    @Override
    public List<DynamicObject> execute(String operateCode, List<DynamicObject> operateDyObjects) {
        List statusFieldDtos = this.map.getOrDefault(operateCode, new ArrayList(0));
        this.buildData(operateDyObjects, statusFieldDtos);
        return operateDyObjects;
    }

    private void init(String operateCode, DispatchAuditStatusEnum auditStatusEnum, DispatchBackStatusEnum backStatus) {
        ArrayList<StatusFieldDto> statusFieldDtos = new ArrayList<StatusFieldDto>(2);
        statusFieldDtos.add(new StatusFieldDto("billstatus", auditStatusEnum.getCode()));
        statusFieldDtos.add(new StatusFieldDto("backstatus", backStatus.getCode()));
        if (HRStringUtils.equals((String)operateCode, (String)"discard_bill")) {
            statusFieldDtos.add(new StatusFieldDto("auditstatus", DisAuditStatusEnum.STOPED.getCode()));
        }
        this.map.put(operateCode, statusFieldDtos);
    }
}

