/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.status.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.status.config.OperateConfig;
import kd.hr.ham.business.domain.status.dto.StatusFieldDto;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchBillOperateConfig
implements OperateConfig {
    private static final Map<String, List<StatusFieldDto>> code2Fields = Maps.newHashMapWithExpectedSize((int)16);
    private static DispatchBillOperateConfig operateConfig = new DispatchBillOperateConfig();

    public DispatchBillOperateConfig() {
        this.config("out_fir_out_save", DispatchAuditStatusEnum.TEMPSTORAGE.getCode(), DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode(), "", DispatchStatusEnum.WAIT_DISPATCH.getCode());
        this.config("out_fir_out_submit", DispatchAuditStatusEnum.ALREADYSUBMIT.getCode(), DispatchOutStatusEnum.SUBMIT_DISPATCHOUT.getCode(), "", DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("out_fir_out_rollback", DispatchAuditStatusEnum.TEMPSTORAGE.getCode(), DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode(), "", DispatchStatusEnum.WAIT_DISPATCH.getCode());
        this.config("out_fir_out_stop", DispatchAuditStatusEnum.STOPED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("out_fir_out_work_fir_reject", DispatchAuditStatusEnum.WAITRESUBMIT.getCode(), DispatchOutStatusEnum.WAITRESUBMIT_DISPATCHOUT.getCode(), "", DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("out_fir_out_work_no_pass", DispatchAuditStatusEnum.APPROVEREJECTED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHOUT.getCode(), "", DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("out_fir_out_work_approving", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVING_DISPATCHOUT.getCode(), "", DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("out_fir_out_work_last_pass", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode(), "");
        this.config("out_fir_in_submit", DispatchAuditStatusEnum.APPROVING.getCode(), "", DispatchInStatusEnum.SUBMIT_DISPATCHIN.getCode(), "");
        this.config("out_fir_in_rollback", DispatchAuditStatusEnum.APPROVING.getCode(), "", DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode(), "");
        this.config("out_fir_in_stop", DispatchAuditStatusEnum.STOPED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("out_fir_workflow_timer", DispatchAuditStatusEnum.APPROVING.getCode(), "", DispatchInStatusEnum.APPROVING_DISPATCHIN.getCode(), "");
        this.config("out_fir_in_work_fir_reject", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.WAITRESUBMIT_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("out_fir_in_work_no_pass", DispatchAuditStatusEnum.APPROVEREJECTED.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHIN.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("out_fir_in_work_approving", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVING_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("out_fir_in_work_last_pass", DispatchAuditStatusEnum.APPROVEPASSED.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode());
        this.config("in_fir_in_save", DispatchAuditStatusEnum.TEMPSTORAGE.getCode(), "", DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode(), DispatchStatusEnum.WAIT_DISPATCH.getCode());
        this.config("in_fir_in_submit", DispatchAuditStatusEnum.ALREADYSUBMIT.getCode(), "", DispatchInStatusEnum.SUBMIT_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("in_fir_in_rollback", DispatchAuditStatusEnum.TEMPSTORAGE.getCode(), "", DispatchInStatusEnum.WAITSUBMIT_DISPATCHIN.getCode(), DispatchStatusEnum.WAIT_DISPATCH.getCode());
        this.config("in_fir_in_stop", DispatchAuditStatusEnum.STOPED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("in_fir_in_work_fir_reject", DispatchAuditStatusEnum.WAITRESUBMIT.getCode(), "", DispatchInStatusEnum.WAITRESUBMIT_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("in_fir_in_work_no_pass", DispatchAuditStatusEnum.APPROVEREJECTED.getCode(), "", DispatchInStatusEnum.SUSPEND_DISPATCHIN.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("in_fir_in_work_approving", DispatchAuditStatusEnum.APPROVING.getCode(), "", DispatchInStatusEnum.APPROVING_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("in_fir_in_work_last_pass", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), "");
        this.config("in_fir_out_submit", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.SUBMIT_DISPATCHOUT.getCode(), "", "");
        this.config("in_fir_out_rollback", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.WAITSUBMIT_DISPATCHOUT.getCode(), "", "");
        this.config("in_fir_out_stop", DispatchAuditStatusEnum.STOPED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("in_fir_workflow_timer", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVING_DISPATCHOUT.getCode(), "", "");
        this.config("in_fir_out_work_fir_reject", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.WAITRESUBMIT_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("in_fir_out_work_no_pass", DispatchAuditStatusEnum.APPROVEREJECTED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
        this.config("in_fir_out_work_approving", DispatchAuditStatusEnum.APPROVING.getCode(), DispatchOutStatusEnum.APPROVING_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), DispatchStatusEnum.APPROVING_DISPATCH.getCode());
        this.config("in_fir_out_work_last_pass", DispatchAuditStatusEnum.APPROVEPASSED.getCode(), DispatchOutStatusEnum.APPROVED_DISPATCHOUT.getCode(), DispatchInStatusEnum.APPROVED_DISPATCHIN.getCode(), DispatchStatusEnum.WAITEFFECT_DISPATCH.getCode());
        this.config("quit_stop", DispatchAuditStatusEnum.STOPED.getCode(), DispatchOutStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchInStatusEnum.SUSPEND_DISPATCHALL.getCode(), DispatchStatusEnum.STOPED_DISPATCH.getCode());
    }

    public static DispatchBillOperateConfig getInstance() {
        return operateConfig;
    }

    @Override
    public List<DynamicObject> execute(String operateCode, List<DynamicObject> operateDyObjects) {
        List<StatusFieldDto> statusFieldDtos = code2Fields.get(operateCode);
        if (CollectionUtils.isEmpty(statusFieldDtos)) {
            return operateDyObjects;
        }
        this.buildData(operateDyObjects, statusFieldDtos);
        return operateDyObjects;
    }

    private void config(String operateCode, String auditStatus, String outStatus, String inStatus, String dispatchStatus) {
        ArrayList statusFieldDtos = Lists.newArrayListWithExpectedSize((int)4);
        if (HRStringUtils.isNotEmpty((String)auditStatus)) {
            statusFieldDtos.add(new StatusFieldDto("billstatus", auditStatus));
        }
        if (HRStringUtils.isNotEmpty((String)outStatus)) {
            statusFieldDtos.add(new StatusFieldDto("outstatus", outStatus));
        }
        if (HRStringUtils.isNotEmpty((String)inStatus)) {
            statusFieldDtos.add(new StatusFieldDto("instatus", inStatus));
        }
        if (HRStringUtils.isNotEmpty((String)dispatchStatus)) {
            statusFieldDtos.add(new StatusFieldDto("dispatchstatus", dispatchStatus));
        }
        HashSet stopCodeSet = Sets.newHashSetWithExpectedSize((int)5);
        stopCodeSet.add("out_fir_out_stop");
        stopCodeSet.add("out_fir_in_stop");
        stopCodeSet.add("in_fir_in_stop");
        stopCodeSet.add("in_fir_out_stop");
        stopCodeSet.add("quit_stop");
        if (stopCodeSet.contains(operateCode)) {
            statusFieldDtos.add(new StatusFieldDto("auditstatus", DisAuditStatusEnum.STOPED.getCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)statusFieldDtos)) {
            code2Fields.put(operateCode, statusFieldDtos);
        }
    }
}

