/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.status.config;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ham.business.domain.status.config.OperateConfig;
import kd.hr.ham.business.domain.status.dto.StatusFieldDto;
import kd.hr.ham.common.dispatch.constants.operate.RecordChangeOpCode;
import kd.hr.ham.common.dispatch.enums.DisAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class RecordChangeOperateConfig
implements OperateConfig,
RecordChangeOpCode {
    private static RecordChangeOperateConfig CONFIG = new RecordChangeOperateConfig();
    private Map<String, List<StatusFieldDto>> map = Maps.newHashMapWithExpectedSize((int)6);

    private RecordChangeOperateConfig() {
        this.init("wfauditing", DispatchAuditStatusEnum.APPROVING, RecordChangeStatusEnum.APPROVING);
        this.init("submit", DispatchAuditStatusEnum.ALREADYSUBMIT, RecordChangeStatusEnum.ALR_SUBMIT);
        this.init("wfrejecttosubmit", DispatchAuditStatusEnum.WAITRESUBMIT, RecordChangeStatusEnum.WAIT_RESUBMIT);
        this.init("audit", DispatchAuditStatusEnum.APPROVEPASSED, RecordChangeStatusEnum.PASS);
        this.init("wfauditnotpass", DispatchAuditStatusEnum.APPROVEREJECTED, RecordChangeStatusEnum.NOT_PASS);
        this.init("discard_bill", DispatchAuditStatusEnum.STOPED, RecordChangeStatusEnum.DISCARD);
        this.init("unsubmit", DispatchAuditStatusEnum.TEMPSTORAGE, RecordChangeStatusEnum.WAIT_SUBMIT);
    }

    public static RecordChangeOperateConfig getInstance() {
        return CONFIG;
    }

    @Override
    public List<DynamicObject> execute(String operateCode, List<DynamicObject> operateDyObjects) {
        List statusFieldDtos = this.map.getOrDefault(operateCode, new ArrayList(0));
        this.buildData(operateDyObjects, statusFieldDtos);
        return operateDyObjects;
    }

    private void init(String operateCode, DispatchAuditStatusEnum auditStatusEnum, RecordChangeStatusEnum recordChgStatus) {
        ArrayList<StatusFieldDto> statusFieldDtos = new ArrayList<StatusFieldDto>(2);
        statusFieldDtos.add(new StatusFieldDto("billstatus", auditStatusEnum.getCode()));
        statusFieldDtos.add(new StatusFieldDto("changestatus", recordChgStatus.getCode()));
        if (HRStringUtils.equals((String)operateCode, (String)"discard_bill")) {
            statusFieldDtos.add(new StatusFieldDto("auditstatus", DisAuditStatusEnum.STOPED.getCode()));
        }
        this.map.put(operateCode, statusFieldDtos);
    }
}

