/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.status.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.status.dto.CrossValidateMsg;
import kd.hr.ham.business.domain.status.dto.CrossValidateParamDto;
import kd.hr.ham.business.util.PromptUtil;
import kd.hr.ham.common.dispatch.constants.PrompConstants;
import kd.hr.ham.common.dispatch.enums.CrossActionEnum;
import kd.hr.ham.common.dispatch.enums.DispBackCrossActionEnum;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonChangeUtils {
    private static final Log LOGGER = LogFactory.getLog(PersonChangeUtils.class);

    public static Map<String, Object> getCheckParam(CrossValidateParamDto crossValidateParam) {
        HashMap<String, Object> checkParams = new HashMap<String, Object>();
        checkParams.put("actionId", crossValidateParam.getActionId());
        checkParams.put("effectTime", crossValidateParam.getEffectTime());
        checkParams.put("personId", crossValidateParam.getPersonId());
        checkParams.put("employeeId", crossValidateParam.getEmployeeId());
        checkParams.put("managingScopeId", crossValidateParam.getManagingScopeId());
        checkParams.put("depEmpId", crossValidateParam.getDepEmpId());
        return checkParams;
    }

    public static List<Map<String, Object>> getCheckParamList(List<CrossValidateParamDto> crossValidateParam) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(crossValidateParam.size());
        for (CrossValidateParamDto crossValidate : crossValidateParam) {
            Map<String, Object> checkParams = PersonChangeUtils.getCheckParam(crossValidate);
            if (result.contains(checkParams)) continue;
            result.add(checkParams);
        }
        return result;
    }

    public static boolean checkPerChgCrossValidateResult(Map<String, Object> perChgResult) {
        if (ObjectUtils.isEmpty(perChgResult)) {
            return false;
        }
        return (Boolean)perChgResult.get("success");
    }

    public static CrossValidateMsg dispatchGetCrossValidateMsg(String persionName, Map<String, Object> validateResult, Long promptId, CrossActionEnum actionEnum) {
        CrossValidateMsg msg = new CrossValidateMsg();
        msg.setMsgType(PersonChangeUtils.getMsgType(validateResult));
        String prompt = PromptUtil.getPromptById(promptId);
        LOGGER.info("dispatchGetCrossValidateMsg PromptUtil  getPromptById is : {}", (Object)prompt);
        if (prompt != null) {
            String msgInfo;
            if (actionEnum == CrossActionEnum.DISPATCH_REG) {
                msgInfo = MessageFormat.format(prompt, persionName);
            } else if (actionEnum == CrossActionEnum.DISPATCH_QUIT) {
                msg.setMsgType("error");
                msgInfo = MessageFormat.format(prompt, persionName, validateResult.get("billNo").toString());
            } else {
                msgInfo = MessageFormat.format(prompt, persionName, validateResult.get("billNo").toString());
            }
            LOGGER.info("dispatchGetCrossValidateMsg msgInfo is : {}", (Object)msgInfo);
            msg.setMsgInfo(msgInfo);
        }
        return msg;
    }

    public static CrossValidateMsg commonCrossValidateMsg(String persionName, Map<String, Object> validateResult) {
        CrossValidateMsg msg = new CrossValidateMsg();
        String type = PersonChangeUtils.getMsgType(validateResult);
        msg.setMsgType(type);
        Long promptId = "warn".equals(type) ? PrompConstants.WARN_PROMPFID : PrompConstants.ERROR_PROMPFID;
        String prompt = PromptUtil.getPromptById(promptId);
        LOGGER.info("commonCrossValidateMsg PromptUtil  getPromptById is : {}", (Object)prompt);
        if (prompt != null) {
            String msgInfo = MessageFormat.format(prompt, persionName, validateResult.get("actionName").toString(), validateResult.get("billNo").toString());
            LOGGER.info("commonCrossValidateMsg msgInfo is : {}", (Object)msgInfo);
            msg.setMsgInfo(msgInfo);
        }
        return msg;
    }

    public static CrossValidateMsg dispbackGetCrossValidateMsg(String persionName, Map<String, Object> validateResult, Long promptId, DispBackCrossActionEnum actionEnum) {
        CrossValidateMsg msg = new CrossValidateMsg();
        msg.setMsgType(PersonChangeUtils.getMsgType(validateResult));
        String prompt = PromptUtil.getPromptById(promptId);
        if (actionEnum == DispBackCrossActionEnum.DISPBACK_QUIT) {
            msg.setMsgType("warn");
        }
        if (prompt != null) {
            String msgInfo = MessageFormat.format(prompt, persionName, validateResult.get("billNo").toString());
            msg.setMsgInfo(msgInfo);
        }
        return msg;
    }

    public static String getMsgType(Map<String, Object> validateResult) {
        String msgType = "";
        String crossValidRes = validateResult.get("crossValidRes").toString();
        msgType = HRStringUtils.equals((String)crossValidRes, (String)"0") ? "warn" : "error";
        return msgType;
    }
}

