/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.domain.vid.service.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.service.invoke.InvokeHandler;
import kd.hr.ham.business.domain.service.invoke.InvokeParam;
import kd.hr.ham.business.domain.vid.UpdateVidDto;
import kd.hr.ham.business.domain.vid.VidPropType;
import kd.hr.ham.business.domain.vid.service.UpdateHistoryVidService;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import org.apache.http.util.Asserts;

public class UpdateHistoryVidServiceImpl
implements UpdateHistoryVidService {
    private static final Log LOG = LogFactory.getLog(UpdateHistoryVidServiceImpl.class);
    private final Map<VidPropType, MyConsumer<UpdateVidDto>> map = Maps.newLinkedHashMapWithExpectedSize((int)VidPropType.values().length);
    private static final InvokeParam INVOKE_PARAM_ADMIN_ORG = new InvokeParam("hrmp", "haos", "IHAOSBatchAdminOrgInfoQueryService", "adminOrgInfoQuery");
    private static final InvokeParam INVOKE_PARAM_ADMIN_ORG_STRUCT = new InvokeParam("hrmp", "haos", "IHAOSBatchAdminOrgStructQueryService", "adminOrgStructQuery");
    private static final InvokeParam INVOKE_PARAM_POSITION = new InvokeParam("hrmp", "hbpm", "IPositionService", "queryPositionHis");
    private static final InvokeParam INVOKE_PARAM_STAND_POSITION = new InvokeParam("hrmp", "hbpm", "IStandardPositionQueryService", "queryStandardPosition");
    private static final InvokeParam INVOKE_PARAM_JOB = new InvokeParam("hrmp", "hbjm", "IHBJMHisVerService", "selectJobHisinfo");

    public UpdateHistoryVidServiceImpl() {
        this.map.put(VidPropType.ADMIN_ORG_STRUCT, this::updateOrgStructRelateInfo);
        this.map.put(VidPropType.ADMIN_ORG, this::updateAdminOrgRelateInfo);
        this.map.put(VidPropType.POSITION, this::updatePositionRelateInfo);
        this.map.put(VidPropType.STAND_POSITION, this::updateStandPositionRelateInfo);
        this.map.put(VidPropType.NEW_HISTORY_MODEL, this::updateNewHistoryModelRelateInfo);
        this.map.put(VidPropType.JOB, this::updateJobRelateInfo);
    }

    @Override
    public void updateHistoryVid(List<UpdateVidDto> vidDtoList) {
        if (CollectionUtils.isEmpty(vidDtoList)) {
            LOG.warn("vidDtoList is null at: {}", (Object)DispatchDateUtils.now());
            return;
        }
        vidDtoList.parallelStream().forEach(this::updateHistoryVid);
    }

    @Override
    public void updateHistoryVid(UpdateVidDto vidDto) {
        Assert.notNull((Object)vidDto, (String)"vidDto");
        Asserts.check((!CollectionUtils.isEmpty(vidDto.getDynamicObjectList()) ? 1 : 0) != 0, (String)"dynamicObjectList");
        Asserts.check((!CollectionUtils.isEmpty(vidDto.getPropMapping()) ? 1 : 0) != 0, (String)"propMapping");
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateHistoryVid:{}", (Object)vidDto.toString());
            }
            vidDto.getPropMapping().keySet().stream().sorted(Comparator.comparing(VidPropType::getOrder)).forEach(vidPropType -> this.map.get(vidPropType).consumer(vidDto));
        }
        catch (Exception exception) {
            LOG.error("updateHistoryVid error: ", (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("UpdateHistoryVidServiceImpl.updateHistoryVid", ResManager.loadKDString((String)"\u66f4\u65b0\u5207\u7247\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"UpdateHistoryVidServiceImpl_0", (String)"hr-ham-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void updateAdminOrgRelateInfo(UpdateVidDto updateVidDto) {
        List<String> properties = updateVidDto.getPropMapping().get((Object)VidPropType.ADMIN_ORG);
        List<Long> adminOrgIdList = this.getIds(updateVidDto.getDynamicObjectList(), properties);
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return;
        }
        Map map = (Map)InvokeHandler.getInstance().invokeService(INVOKE_PARAM_ADMIN_ORG, adminOrgIdList, DispatchDateUtils.now());
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        updateVidDto.getDynamicObjectList().forEach(dy -> properties.forEach(prop -> Optional.ofNullable(dy.getDynamicObject(prop)).flatMap(dynamicObject -> Optional.ofNullable(map.get(dynamicObject.getString("id")))).ifPresent(adminOrgInfo -> {
            dy.set(prop, adminOrgInfo.get("vid"));
            if (LOG.isDebugEnabled()) {
                LOG.debug("update AdminOrg id:{}, vid:{}", adminOrgInfo.get("id"), adminOrgInfo.get("vid"));
            }
        })));
    }

    private void updateOrgStructRelateInfo(UpdateVidDto updateVidDto) {
        List<String> adminOrgProps = updateVidDto.getPropMapping().get((Object)VidPropType.ADMIN_ORG);
        List<Long> adminOrgIdList = this.getIds(updateVidDto.getDynamicObjectList(), adminOrgProps);
        if (CollectionUtils.isEmpty(adminOrgIdList)) {
            return;
        }
        Map map = (Map)InvokeHandler.getInstance().invokeService(INVOKE_PARAM_ADMIN_ORG_STRUCT, adminOrgIdList, DispatchDateUtils.now(), Boolean.TRUE);
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        updateVidDto.getDynamicObjectList().forEach(dy -> adminOrgProps.forEach(adminOrgProp -> Optional.ofNullable(dy.getDynamicObject(adminOrgProp)).flatMap(subDy -> Optional.ofNullable(map.get(String.valueOf(subDy.getLong("id"))))).ifPresent(structInfo -> {
            Object adminOrgStructVid = structInfo.get("adminorgstructvid");
            Map<String, String> relatedPropMapping = updateVidDto.getRelatedPropMapping();
            if (Objects.isNull(relatedPropMapping) || Objects.isNull(relatedPropMapping.get(adminOrgProp))) {
                LOG.warn("update AdminOrgStruct getRelatedPropMapping error prop:{}, mapping:{} ", adminOrgProp, relatedPropMapping);
                return;
            }
            String adminOrgStructProp = relatedPropMapping.get(adminOrgProp);
            dy.set(adminOrgStructProp, adminOrgStructVid);
            if (LOG.isDebugEnabled()) {
                LOG.debug("update AdminOrgStruct adminOrgId:{}, structVid:{}", structInfo.get("id"), adminOrgStructVid);
            }
        })));
    }

    private void updatePositionRelateInfo(UpdateVidDto updateVidDto) {
        List<String> positionProps = updateVidDto.getPropMapping().get((Object)VidPropType.POSITION);
        List<Long> positionIds = this.getIds(updateVidDto.getDynamicObjectList(), positionProps);
        if (positionIds.isEmpty()) {
            return;
        }
        Map map = (Map)InvokeHandler.getInstance().invokeService(INVOKE_PARAM_POSITION, positionIds, DispatchDateUtils.now());
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Map data = (Map)map.get("data");
        if (null == data) {
            LOG.warn("UpdateHistoryVidService.position data is null");
            return;
        }
        List hisData = (List)data.get("hisdata");
        if (null == hisData) {
            LOG.warn("UpdateHistoryVidService.position hisdata is null");
            return;
        }
        Map<String, Object> groupByBoId = hisData.stream().collect(Collectors.toMap(dataInfo -> String.valueOf(dataInfo.get("boid")), dataInfo -> dataInfo.get("id")));
        updateVidDto.getDynamicObjectList().forEach(dy -> positionProps.forEach(prop -> Optional.ofNullable(dy.getDynamicObject(prop)).ifPresent(dynamicObject -> {
            String id = dynamicObject.getString("id");
            dy.set(prop, groupByBoId.get(id));
            if (LOG.isDebugEnabled()) {
                LOG.debug("update position id:{}, vid:{}", (Object)id, groupByBoId.get(id));
            }
        })));
    }

    private void updateStandPositionRelateInfo(UpdateVidDto updateVidDto) {
        List<String> standPositionProps = updateVidDto.getPropMapping().get((Object)VidPropType.STAND_POSITION);
        List<Long> standPositionParams = this.getIds(updateVidDto.getDynamicObjectList(), standPositionProps);
        if (CollectionUtils.isEmpty(standPositionParams)) {
            return;
        }
        Map map = (Map)InvokeHandler.getInstance().invokeService(INVOKE_PARAM_STAND_POSITION, standPositionParams, DispatchDateUtils.now());
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Object data = map.get("data");
        if (Objects.isNull(data)) {
            LOG.warn("UpdateHistoryVidService.standPosition data is null");
            return;
        }
        List resultList = (List)data;
        Map<String, Object> groupByBoId = resultList.stream().collect(Collectors.toMap(dataInfo -> String.valueOf(dataInfo.get("boid")), dataInfo -> dataInfo.get("id")));
        updateVidDto.getDynamicObjectList().forEach(dy -> standPositionProps.forEach(prop -> Optional.ofNullable(dy.getDynamicObject(prop)).ifPresent(dynamicObject -> {
            String id = dynamicObject.getString("id");
            dy.set(prop, groupByBoId.get(id));
            if (LOG.isDebugEnabled()) {
                LOG.debug("update standardPosition id:{}, vid:{}", (Object)id, groupByBoId.get(id));
            }
        })));
    }

    private void updateNewHistoryModelRelateInfo(UpdateVidDto updateVidDto) {
        List<String> properties = updateVidDto.getPropMapping().get((Object)VidPropType.NEW_HISTORY_MODEL);
        updateVidDto.getDynamicObjectList().parallelStream().forEach(dy -> properties.forEach(prop -> {
            DynamicObject fieldDy = dy.getDynamicObject(prop);
            Optional.ofNullable(fieldDy).filter(filterDy -> Objects.nonNull(filterDy.getDynamicObjectType().getProperty("sourcevid"))).ifPresent(dynamicObject -> {
                dynamicObject.set(prop, fieldDy.get("sourcevid"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("update newHistoryModel id:{}, vid:{}", (Object)fieldDy.getLong("id"), (Object)fieldDy.getLong("sourcevid"));
                }
            });
        }));
    }

    private void updateJobRelateInfo(UpdateVidDto updateVidDto) {
        List<String> jobProps = updateVidDto.getPropMapping().get((Object)VidPropType.JOB);
        List<Long> jobParams = this.getIds(updateVidDto.getDynamicObjectList(), jobProps);
        if (CollectionUtils.isEmpty(jobParams)) {
            return;
        }
        Map returnData = (Map)InvokeHandler.getInstance().invokeService(INVOKE_PARAM_JOB, jobParams, DispatchDateUtils.now());
        if (CollectionUtils.isEmpty((Map)returnData)) {
            return;
        }
        Object dataObj = returnData.get("data");
        if (Objects.isNull(dataObj)) {
            return;
        }
        List data = (List)dataObj;
        Map<String, Object> boId2Id = data.stream().collect(Collectors.toMap(map -> String.valueOf(map.get("boid")), map -> map.get("id")));
        updateVidDto.getDynamicObjectList().forEach(dy -> jobProps.forEach(prop -> Optional.ofNullable(dy.getDynamicObject(prop)).ifPresent(dynamicObject -> {
            String boId = dynamicObject.getString("id");
            dy.set(prop, boId2Id.get(boId));
            if (LOG.isDebugEnabled()) {
                LOG.debug("update job id:{}, vid:{}", (Object)boId, boId2Id.get(boId));
            }
        })));
    }

    private List<Long> getIds(List<DynamicObject> dynamicObjects, List<String> properties) {
        ArrayList<Long> idList = new ArrayList<Long>(dynamicObjects.size());
        dynamicObjects.forEach(dynamicObject -> properties.forEach(prop -> Optional.ofNullable(dynamicObject.get(prop)).ifPresent(obj -> {
            if (obj instanceof DynamicObject) {
                DynamicObject subDy = (DynamicObject)obj;
                idList.add(subDy.getLong("id"));
            }
            if (obj instanceof Long) {
                Long subObj = (Long)obj;
                idList.add(subObj);
            }
        })));
        return idList;
    }

    @FunctionalInterface
    private static interface MyConsumer<TT extends UpdateVidDto> {
        public void consumer(TT var1);
    }
}

