/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.util.MsgPublisherUtil;

public class DispatchPersonChangeEffectCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(DispatchPersonChangeEffectCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billId";
    private static final String ERROR_MESSAGE = "errMsg";
    private static final String NEW_ERFILE_ID = "newErfileId";
    private static final String MSGPUBNO = "MP20220524001001";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info("DispatchPersonChangeEffectCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
        JSONObject chgResult = (JSONObject)messageArray.get(0);
        Long billId = chgResult.getLong(BILL_ID);
        Long newErfileId = chgResult.getLong(NEW_ERFILE_ID);
        try {
            if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
                LOGGER.error("Dispatch DispatchPersonChangeEffectCallBack is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, (Object)chgResult.get((Object)ERROR_MESSAGE).toString());
                IDispatchPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
            } else {
                LOGGER.info("Dispatch DispatchPersonChangeEffectCallBack is success, the billId is : [{}]", (Object)billId);
                IDispatchPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId, newErfileId);
                LOGGER.info("Center DispatchPersonChangeNoticCallBack Message Start");
                Long recordId = chgResult.getLong("recordId");
                Long msgSynActionId = chgResult.getLong("msgSynActionId");
                DynamicObject dispatchBillDO = IDispatchBillService.getInstance().queryOneDispatch(billId);
                String personName = dispatchBillDO.getDynamicObject("ermanfile").getString("name");
                Map<String, Object> messageContent = MsgPublisherUtil.getMessageContent(recordId, dispatchBillDO);
                String msgTitle = personName + dispatchBillDO.getString("affaction.name");
                MsgPublisherUtil.dispPublishAction(MSGPUBNO, billId, msgTitle, msgSynActionId, messageContent);
                LOGGER.info("Center DispatchPersonChangeNoticCallBack Message End");
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Dispatch DispatchPersonChangeEffectCallBack is fail, the billId is :");
            stringBuilder.append(billId.toString());
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Throwable)exception);
        }
    }
}

