/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.util.MsgPublisherUtil;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;

public class DispbackPersonChangeEffectCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(DispbackPersonChangeEffectCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billId";
    private static final String ERROR_MESSAGE = "errMsg";
    private static final String NEW_ERFILE_ID = "newErfileId";
    private static final String KEY_DARK_POSITION = "position";
    private static final String KEY_RESULT_DATA = "data";
    private static final String CODE_SUCCESS = "200";
    private static final String KEY_RESULT_CODE = "code";
    private static final String MSGPUBNO = "MP20220524001002";
    private static final String MSGPUGNO_DISDARKPOSITION = "MP20220906002004";
    private static final Long ACTIONID_DISDARKPOSITION = 101340L;

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info("DispbackPersonChangeEffectCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
        JSONObject chgResult = (JSONObject)messageArray.get(0);
        Long billId = chgResult.getLong(BILL_ID);
        Long newErfileId = chgResult.getLong(NEW_ERFILE_ID);
        try {
            if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
                LOGGER.error("Dispback DispbackPersonChangeEffectCallBack is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, (Object)chgResult.get((Object)ERROR_MESSAGE).toString());
                IDispabackPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
            } else {
                LOGGER.info("Dispback DispbackPersonChangeEffectCallBack is success, the billId is : [{}]", (Object)billId);
                IDispabackPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId, newErfileId);
                LOGGER.info("Center DispbackPersonChangeEffectCallBack Message Start");
                Long recordId = chgResult.getLong("recordId");
                Long msgSynActionId = chgResult.getLong("msgSynActionId");
                DynamicObject dispbackBillDO = IDispatchBackBillService.getInstance().queryOneDispatchBack(billId);
                String personName = dispbackBillDO.getDynamicObject("ermanfile").getString("name");
                Map<String, Object> messageContent = MsgPublisherUtil.getMessageContent(recordId, dispbackBillDO);
                String msgTitle = personName + dispbackBillDO.getString("affaction.name");
                MsgPublisherUtil.dispPublishAction(MSGPUBNO, billId, msgTitle, msgSynActionId, messageContent);
                LOGGER.info("Center DispbackPersonChangeEffectCallBack Message End");
                LOGGER.info("disableDarkPosition Start");
                String pospatternin = dispbackBillDO.getDynamicObject("dispatchrecord").getString("pospatternin");
                LOGGER.info("disableDarkPosition pospatternin is : [{}]", (Object)pospatternin);
                if (pospatternin.equals("0") || pospatternin.equals("2")) {
                    Long indarkposition = dispbackBillDO.getDynamicObject("dispatchrecord").getLong("positionin.id");
                    LOGGER.info("disableDarkPosition indarkposition is : [{}]", (Object)indarkposition.toString());
                    this.disableDarkPosition(indarkposition, billId, ACTIONID_DISDARKPOSITION);
                }
                LOGGER.info("disableDarkPosition End");
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DispbackPersonChangeEffectCallBack is fail, the billId is :");
            stringBuilder.append(billId.toString());
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Throwable)exception);
        }
    }

    private void disableDarkPosition(Long darkPosition, Long billId, Long msgSynActionId) {
        if (darkPosition == null || darkPosition == 0L) {
            LOGGER.info("DispbackPersonChangeEffectCallBack disableDarkPosition end, the darkPosition is empty, the billId is : [{}]", (Object)billId);
            return;
        }
        try {
            LOGGER.info("sendDisableDarkPositionMsg Start");
            this.sendDisableDarkPositionMsg(billId, darkPosition, msgSynActionId);
            LOGGER.info("sendDisableDarkPositionMsg End");
        }
        catch (Exception e) {
            LOGGER.error("DispbackPersonChangeEffectCallBack sendDisableDarkPositionMsg error, the billId is [{}]", (Object)billId);
        }
    }

    private void sendDisableDarkPositionMsg(Long billId, Long darkPosition, Long msgSynActionId) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>();
        HashMap<String, List<Long>> content = new HashMap<String, List<Long>>();
        content.put(KEY_DARK_POSITION, Collections.singletonList(darkPosition));
        String msgTitle = ResManager.loadKDString((String)"\u5916\u6d3e\u5931\u6548\u6697\u5c97", (String)"DispbackPersonChangeEffectCallBack_0", (String)"hr-ham-business", (Object[])new Object[0]);
        String msgDesc = ResManager.loadKDString((String)"\u5916\u6d3e\u5931\u6548\u6697\u5c97\u901a\u77e5", (String)"DispbackPersonChangeEffectCallBack_1", (String)"hr-ham-business", (Object[])new Object[0]);
        String msgNumber = String.format("%1$s_%2$s", billId, System.currentTimeMillis());
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", MSGPUGNO_DISDARKPOSITION);
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("msgDesc", msgDesc);
        messageParams.put("msgTag", msgTitle);
        messageParams.put("actionId", msgSynActionId);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(content));
        LOGGER.info("DispbackPersonChangeEffectCallBack disableDarkPosition----messageParms: {}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }
}

