/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.common.IDispchgPersonChangeService;
import kd.hr.ham.business.mq.consumer.DispbackPersonChangeEffectCallBack;
import kd.hr.ham.business.util.MsgPublisherUtil;

public class DispchgPersonChangeEffectCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(DispbackPersonChangeEffectCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billId";
    private static final String ERROR_MESSAGE = "errMsg";
    private static final String NEW_ERFILE_ID = "newErfileId";
    private static final String MSGPUBNO = "MP20220623001003";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        LOGGER.info("DispchgPersonChangeEffectCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
        JSONObject chgResult = (JSONObject)messageArray.get(0);
        Long billId = chgResult.getLong(BILL_ID);
        Long newErfileId = chgResult.getLong(NEW_ERFILE_ID);
        try {
            if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
                LOGGER.error("Dispchg DispchgPersonChangeEffectCallBack is fail, the billId is : [{}], the error message is :[{}]", (Object)billId, (Object)chgResult.get((Object)ERROR_MESSAGE).toString());
                IDispchgPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
            } else {
                LOGGER.info("Dispchg DispchgPersonChangeEffectCallBack is success, the billId is : [{}]", (Object)billId);
                IDispchgPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId, newErfileId);
                LOGGER.info("Center DispchgPersonChangeEffectCallBack Message Start");
                Long recordId = chgResult.getLong("recordId");
                Long msgSynActionId = chgResult.getLong("msgSynActionId");
                DynamicObject dispchgBillDO = IRecordChangeBillService.getInstance().queryOneDispatchChange(billId);
                String personName = dispchgBillDO.getDynamicObject("ermanfile").getString("name");
                Map<String, Object> messageContent = MsgPublisherUtil.getMessageContent(recordId, dispchgBillDO);
                String msgTitle = personName + dispchgBillDO.getString("affaction.name");
                MsgPublisherUtil.dispPublishAction(MSGPUBNO, billId, msgTitle, msgSynActionId, messageContent);
                LOGGER.info("Center DispchgPersonChangeEffectCallBack Message End");
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DispchgPersonChangeEffectCallBack is fail, the billId is :");
            stringBuilder.append(billId.toString());
            stringBuilder.append(",the exception is {}");
            LOGGER.error(stringBuilder.toString(), (Throwable)exception);
        }
    }
}

