/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.mq.sender;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.ham.business.util.PersonChangeHelper;
import kd.hr.ham.common.dispatch.bean.ChgRecordExecutorDto;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class DispatchPersonChangeSend {
    private static final Log LOGGER = LogFactory.getLog(DispatchPersonChangeSend.class);
    private static final String ERMANFILEID = "ermanfile_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendNoticePersonChangeMsg(DynamicObject dispatchBill, Integer operateType) {
        ChgRecordExecutorDto cred = new ChgRecordExecutorDto();
        cred.setOperation(operateType.toString());
        cred.setBillId(dispatchBill.getString("id"));
        cred.setBillNo(dispatchBill.getString("billno"));
        cred.setAppId("ham");
        cred.setResultCallBackQueue("ham_dispatchNotice_result_queue");
        cred.setBillSource("ham_dispatch");
        cred.setBsed(Long.valueOf(DispatchPersonChangeSend.getDispatchTimestamp(dispatchBill)));
        cred.setActionId(dispatchBill.getString("affaction.id"));
        cred.setPersonId(dispatchBill.getDynamicObject("ermanfile").getString("person_id"));
        cred.setEmployeeId(dispatchBill.getDynamicObject("ermanfile").getString("employee_id"));
        cred.setManagingScopeId(dispatchBill.getDynamicObject("ermanfile").getString("cmpemp_id"));
        cred.setDepEmpId(dispatchBill.getDynamicObject("ermanfile").getString("depemp_id"));
        LOGGER.info("Dispatch sendPersonChangeMsg, the message info is : [{}]", (Object)JSONObject.toJSONString((Object)cred));
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_chgrecord_queue");){
            pub.publish(JSONObject.toJSONString((Object)cred));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAckPersonChangeEffectMsg(DynamicObject dispatchBill, Integer operateType) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("operatetype", operateType);
        paramMap.put("billdata", (Integer)DispatchPersonChangeSend.buildPersonChangParam(dispatchBill));
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_perchg_queue");){
            LOGGER.info("Dispatch sendAckPersonChangeEffectMsg, the message info is : [{}]", (Object)JSONObject.toJSONString(paramMap));
            pub.publish(JSONObject.toJSONString(paramMap));
        }
    }

    private static PerChgParam buildPersonChangParam(DynamicObject dispatchBill) {
        PerChgParam perchgParam = new PerChgParam();
        perchgParam.setAppId("ham");
        perchgParam.setUserId(Long.valueOf(0L));
        perchgParam.setResultCallBackQueue("ham_dispatchAck_result_queue");
        perchgParam.setBizInfoList(Collections.singletonList(DispatchPersonChangeSend.buildPersonChangBizInfo(dispatchBill)));
        return perchgParam;
    }

    private static PerChgBizInfo buildPersonChangBizInfo(DynamicObject dispatchBill) {
        PerChgBizInfo perchg = new PerChgBizInfo();
        perchg.setActionId(Long.valueOf(dispatchBill.getLong("affaction.id")));
        perchg.setBillId(Long.valueOf(dispatchBill.getLong("id")));
        perchg.setBillNo(dispatchBill.getString("billno"));
        perchg.setBillSource("ham_dispatch");
        perchg.setOldPersonId(Long.valueOf(dispatchBill.getDynamicObject("ermanfile").getLong("person_id")));
        perchg.setOldComempId(Long.valueOf(dispatchBill.getDynamicObject("ermanfile").getLong("cmpemp_id")));
        perchg.setOldDepempId(Long.valueOf(dispatchBill.getDynamicObject("ermanfile").getLong("depemp_id")));
        perchg.setOldEmployeeId(Long.valueOf(dispatchBill.getDynamicObject("ermanfile").getLong("employee_id")));
        perchg.setOldErfileId(Long.valueOf(dispatchBill.getDynamicObject("ermanfile").getLong("id")));
        perchg.setBsed(dispatchBill.getDate("startdate"));
        HashMap<String, List<Long>> dataRowMap = new HashMap<String, List<Long>>();
        dataRowMap.put("ham_dispatch", Collections.singletonList(dispatchBill.getLong("id")));
        Long baseLocationId = PersonChangeHelper.getDispatchBaseLocationId(dispatchBill.getLong(ERMANFILEID));
        if (!ObjectUtils.isEmpty((Object)baseLocationId)) {
            LOGGER.info("Dispatch baseLocationId is : [{}]", (Object)baseLocationId);
            dataRowMap.put("hrpi_baselocation", Collections.singletonList(baseLocationId));
        }
        perchg.setDataRow(dataRowMap);
        return perchg;
    }

    private static long getDispatchTimestamp(DynamicObject dispatchBill) {
        if (ObjectUtils.isEmpty((Object)dispatchBill) || dispatchBill.getDate("startdate") == null) {
            return 0L;
        }
        return dispatchBill.getDate("startdate").getTime();
    }
}

