/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.mq.sender;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.ham.business.util.PersonChangeHelper;
import kd.hr.ham.common.dispatch.bean.ChgRecordExecutorDto;
import kd.hr.ham.common.dispatch.utils.ObjectUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;
import org.apache.commons.lang3.StringUtils;

public class DispbackPersonChangeSend {
    private static final Log LOGGER = LogFactory.getLog(DispbackPersonChangeSend.class);
    private static final String ERMANFILEID = "ermanfile_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendNoticePersonChangeMsg(DynamicObject dispbackhBill, Integer operateType) {
        ChgRecordExecutorDto cred = new ChgRecordExecutorDto();
        cred.setOperation(operateType.toString());
        cred.setBillId(dispbackhBill.getString("id"));
        cred.setBillNo(dispbackhBill.getString("billno"));
        cred.setAppId("ham");
        cred.setResultCallBackQueue("ham_dispbackNotice_result_queue");
        cred.setBillSource("ham_dispback");
        cred.setBsed(Long.valueOf(DispbackPersonChangeSend.getDispbackTimestamp(dispbackhBill)));
        String actionId = dispbackhBill.getString("affaction.id");
        if (StringUtils.isBlank((CharSequence)actionId)) {
            cred.setActionId(dispbackhBill.getString("affaction"));
        } else {
            cred.setActionId(actionId);
        }
        cred.setPersonId(dispbackhBill.getDynamicObject("ermanfile").getString("person_id"));
        cred.setEmployeeId(dispbackhBill.getDynamicObject("ermanfile").getString("employee_id"));
        cred.setManagingScopeId(dispbackhBill.getDynamicObject("ermanfile").getString("cmpemp_id"));
        cred.setDepEmpId(dispbackhBill.getDynamicObject("ermanfile").getString("depemp_id"));
        LOGGER.info("Dispback sendPersonChangeMsg, the message info is : [{}]", (Object)JSONObject.toJSONString((Object)cred));
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_chgrecord_queue");){
            pub.publish(JSONObject.toJSONString((Object)cred));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAckPersonChangeEffectMsg(DynamicObject dispbackBill, Integer operateType) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("operatetype", operateType);
        paramMap.put("billdata", (Integer)DispbackPersonChangeSend.buildPersonChangParam(dispbackBill));
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_perchg_queue");){
            LOGGER.info("Dispback sendAckPersonChangeEffectMsg, the message info is : [{}]", (Object)JSONObject.toJSONString(paramMap));
            pub.publish(JSONObject.toJSONString(paramMap));
        }
    }

    private static PerChgParam buildPersonChangParam(DynamicObject dispbackBill) {
        PerChgParam perchgParam = new PerChgParam();
        perchgParam.setAppId("ham");
        perchgParam.setUserId(Long.valueOf(0L));
        perchgParam.setResultCallBackQueue("ham_dispbackAck_result_queue");
        perchgParam.setBizInfoList(Collections.singletonList(DispbackPersonChangeSend.buildPersonChangBizInfo(dispbackBill)));
        return perchgParam;
    }

    private static PerChgBizInfo buildPersonChangBizInfo(DynamicObject dispbackBill) {
        PerChgBizInfo perchg = new PerChgBizInfo();
        Long actionId = dispbackBill.getLong("affaction.id");
        if (actionId == 0L) {
            perchg.setActionId(Long.valueOf(dispbackBill.getLong("affaction")));
        } else {
            perchg.setActionId(actionId);
        }
        perchg.setBillId(Long.valueOf(dispbackBill.getLong("id")));
        perchg.setBillNo(dispbackBill.getString("billno"));
        perchg.setBillSource("ham_dispback");
        perchg.setOldPersonId(Long.valueOf(dispbackBill.getDynamicObject("ermanfile").getLong("person_id")));
        perchg.setOldComempId(Long.valueOf(dispbackBill.getDynamicObject("ermanfile").getLong("cmpemp_id")));
        perchg.setOldDepempId(Long.valueOf(dispbackBill.getDynamicObject("ermanfile").getLong("depemp_id")));
        perchg.setOldEmployeeId(Long.valueOf(dispbackBill.getDynamicObject("ermanfile").getLong("employee_id")));
        perchg.setOldErfileId(Long.valueOf(dispbackBill.getDynamicObject("ermanfile").getLong("id")));
        Date dispEnddate = dispbackBill.getDate("enddate");
        Date bsedDate = HRDateTimeUtils.addDay((Date)dispEnddate, (long)1L);
        perchg.setBsed(bsedDate);
        LOGGER.info("Dispback buildPersonChangBizInfo enddate is : [{}]", (Object)dispbackBill.getDate("enddate").toString());
        HashMap<String, List<Long>> dataRowMap = new HashMap<String, List<Long>>();
        dataRowMap.put("ham_dispback", Collections.singletonList(dispbackBill.getLong("id")));
        Long baseLocationId = PersonChangeHelper.getDispatchBaseLocationId(dispbackBill.getLong(ERMANFILEID));
        if (!ObjectUtils.isEmpty((Object)baseLocationId)) {
            LOGGER.info("Dispback baseLocationId is : [{}]", (Object)baseLocationId);
            dataRowMap.put("hrpi_baselocation", Collections.singletonList(baseLocationId));
        }
        perchg.setDataRow(dataRowMap);
        return perchg;
    }

    private static long getDispbackTimestamp(DynamicObject dispbackhBill) {
        if (ObjectUtils.isEmpty((Object)dispbackhBill) || dispbackhBill.getDate("enddate") == null) {
            return 0L;
        }
        return dispbackhBill.getDate("enddate").getTime();
    }
}

