/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.business.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.ham.business.domain.service.validator.DyObjValidateContext;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchBackStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchInStatusEnum;
import kd.hr.ham.common.dispatch.enums.DispatchOutStatusEnum;
import kd.hr.ham.common.dispatch.enums.RecordChangeStatusEnum;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExcelUtils {
    private ExcelUtils() {
    }

    public static List<HRExportHeadObject> initDisChangeConfirmExcelHead(String keyword) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ExcelUtils_0", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExcelUtils_1", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"ExcelUtils_2", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("changestatus", ResManager.loadKDString((String)"\u53d8\u66f4\u5ba1\u6279\u72b6\u6001", (String)"ExcelUtils_12", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"ExcelUtils_4", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("islegal", String.format(ResManager.loadKDString((String)"\u662f\u5426\u53ef%s", (String)"ExcelUtils_3", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        headObjectList.add(new HRExportHeadObject("reason", String.format(ResManager.loadKDString((String)"\u4e0d\u53ef%s\u539f\u56e0", (String)"ExcelUtils_5", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        return headObjectList;
    }

    public static List<Map<String, Object>> initDisChangeConfirmExportData(List<DyObjValidateContext> dyObjValidateContexts) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(1 << dyObjValidateContexts.size()));
        for (int index = 0; index < dyObjValidateContexts.size(); ++index) {
            DynamicObject bill = dyObjValidateContexts.get(index).getDynamicObject();
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", bill.getLong("id"));
            exportData.put("person.name", bill.getString("ermanfile.name"));
            exportData.put("person.number", bill.getString("ermanfile.number"));
            exportData.put("org", bill.getDynamicObject("org").getLocaleString("name").toString());
            exportData.put("billstatus", DispatchAuditStatusEnum.getName((String)bill.getString("billstatus")));
            exportData.put("changestatus", RecordChangeStatusEnum.getName((String)bill.getString("changestatus")));
            if (dyObjValidateContexts.get(index).getValidatorContext().getValidateResult().size() > 0) {
                exportData.put("islegal", ResManager.loadKDString((String)"\u5426", (String)"ExcelUtils_7", (String)"hr-ham-business", (Object[])new Object[0]));
                exportData.put("reason", dyObjValidateContexts.get(index).getValidatorContext().getValidateResultStr());
            } else {
                exportData.put("islegal", ResManager.loadKDString((String)"\u662f", (String)"ExcelUtils_8", (String)"hr-ham-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    public static List<HRExportHeadObject> initDisBackConfirmExcelHead(String keyword) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ExcelUtils_0", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExcelUtils_1", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"ExcelUtils_2", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("backstatus", ResManager.loadKDString((String)"\u6d3e\u8fd4\u5ba1\u6279\u72b6\u6001", (String)"ExcelUtils_11", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"ExcelUtils_4", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("islegal", String.format(ResManager.loadKDString((String)"\u662f\u5426\u53ef%s", (String)"ExcelUtils_3", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        headObjectList.add(new HRExportHeadObject("reason", String.format(ResManager.loadKDString((String)"\u4e0d\u53ef%s\u539f\u56e0", (String)"ExcelUtils_5", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        return headObjectList;
    }

    public static List<Map<String, Object>> initDisBackConfirmExportData(List<DyObjValidateContext> dyObjValidateContexts) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(1 << dyObjValidateContexts.size()));
        for (int index = 0; index < dyObjValidateContexts.size(); ++index) {
            DynamicObject bill = dyObjValidateContexts.get(index).getDynamicObject();
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", bill.getLong("id"));
            exportData.put("person.name", bill.getString("ermanfile.name"));
            exportData.put("person.number", bill.getString("ermanfile.number"));
            exportData.put("org", bill.getDynamicObject("org").getLocaleString("name").toString());
            exportData.put("billstatus", DispatchAuditStatusEnum.getName((String)bill.getString("billstatus")));
            exportData.put("backstatus", DispatchBackStatusEnum.getName((String)bill.getString("backstatus")));
            if (dyObjValidateContexts.get(index).getValidatorContext().getValidateResult().size() > 0) {
                exportData.put("islegal", ResManager.loadKDString((String)"\u5426", (String)"ExcelUtils_7", (String)"hr-ham-business", (Object[])new Object[0]));
                exportData.put("reason", dyObjValidateContexts.get(index).getValidatorContext().getValidateResultStr());
            } else {
                exportData.put("islegal", ResManager.loadKDString((String)"\u662f", (String)"ExcelUtils_8", (String)"hr-ham-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    public static List<HRExportHeadObject> initDisBillConfirmExcelHead(String keyword, String billFormId) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ExcelUtils_0", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExcelUtils_1", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"ExcelUtils_2", (String)"hr-ham-business", (Object[])new Object[0])));
        if (HRStringUtils.equals((String)billFormId, (String)"ham_dispatchin")) {
            headObjectList.add(new HRExportHeadObject("instatus", ResManager.loadKDString((String)"\u6d3e\u5165\u5ba1\u6279\u72b6\u6001", (String)"ExcelUtils_6", (String)"hr-ham-business", (Object[])new Object[0])));
        } else {
            headObjectList.add(new HRExportHeadObject("outstatus", ResManager.loadKDString((String)"\u6d3e\u51fa\u5ba1\u6279\u72b6\u6001", (String)"ExcelUtils_9", (String)"hr-ham-business", (Object[])new Object[0])));
        }
        headObjectList.add(new HRExportHeadObject("billstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"ExcelUtils_4", (String)"hr-ham-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("islegal", String.format(ResManager.loadKDString((String)"\u662f\u5426\u53ef%s", (String)"ExcelUtils_3", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        headObjectList.add(new HRExportHeadObject("reason", String.format(ResManager.loadKDString((String)"\u4e0d\u53ef%s\u539f\u56e0", (String)"ExcelUtils_5", (String)"hr-ham-business", (Object[])new Object[0]), keyword)));
        return headObjectList;
    }

    public static List<Map<String, Object>> initDisBillConfirmExportData(List<DyObjValidateContext> dyObjValidateContexts, String billFormId) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(1 << dyObjValidateContexts.size()));
        for (int index = 0; index < dyObjValidateContexts.size(); ++index) {
            DynamicObject bill = dyObjValidateContexts.get(index).getDynamicObject();
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", bill.getLong("id"));
            exportData.put("person.name", bill.getString("ermanfile.name"));
            exportData.put("person.number", bill.getString("ermanfile.number"));
            exportData.put("org", bill.getDynamicObject("org").getLocaleString("name").toString());
            exportData.put("billstatus", DispatchAuditStatusEnum.getName((String)bill.getString("billstatus")));
            exportData.put("outstatus", DispatchOutStatusEnum.getName((String)bill.getString("outstatus")));
            exportData.put("instatus", DispatchInStatusEnum.getName((String)bill.getString("instatus")));
            if (dyObjValidateContexts.get(index).getValidatorContext().getValidateResult().size() > 0) {
                exportData.put("islegal", ResManager.loadKDString((String)"\u5426", (String)"ExcelUtils_7", (String)"hr-ham-business", (Object[])new Object[0]));
                exportData.put("reason", dyObjValidateContexts.get(index).getValidatorContext().getValidateResultStr());
            } else {
                exportData.put("islegal", ResManager.loadKDString((String)"\u662f", (String)"ExcelUtils_8", (String)"hr-ham-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }
}

