/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.mservice;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.service.bill.IDispatchBackBillService;
import kd.hr.ham.business.domain.service.bill.IDispatchBillService;
import kd.hr.ham.business.domain.service.bill.IRecordChangeBillService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.dto.QuitParamDto;
import kd.hr.ham.mservice.api.IHAMQuitService;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HAMQuitService
implements IHAMQuitService {
    private static final Log LOGGER = LogFactory.getLog(HAMQuitService.class);

    public Map<String, Object> quitEffectHam(Map<String, Object> params) {
        boolean quitEffectHamResult;
        Map<String, Object> checkRes = this.checkQuitParam(params);
        if (!((Boolean)checkRes.get("success")).booleanValue()) {
            return checkRes;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String errorMsg = "";
        try {
            QuitParamDto quitParam = QuitParamDto.format(params);
            LOGGER.info("quitEffectHam quitParam:{}", (Object)JSON.toJSONString((Object)quitParam));
            Long personId = quitParam.getPersonId();
            Date effectTimeDate = quitParam.getEffectTime();
            LOGGER.info("HAMQuitService quitEffectHam personId:{} ;effectTimeDate:{};termReason\uff1a{}", (Object)personId, (Object)effectTimeDate);
            LOGGER.info("HAMQuitService quitEffectHam dispatch start");
            String termReason = ResManager.loadKDString((String)"\u79bb\u804c\u7ec8\u6b62", (String)"HAMService_0", (String)"hr-ham-mservice", (Object[])new Object[0]);
            IDispatchBillService.getInstance().terminateDispatch(personId, new Date(), termReason, quitParam.getAlaborrelstatusId());
            LOGGER.info("HAMQuitService quitEffectHam dispatch end");
            LOGGER.info("HAMQuitService quitEffectHam dispback  start");
            IDispatchBackBillService.getInstance().terminateByPerson(personId, (Object)termReason, effectTimeDate, quitParam.getAlaborrelstatusId());
            LOGGER.info("HAMQuitService quitEffectHam dispback end");
            LOGGER.info("HAMQuitService quitEffectHam dispchg  start");
            IRecordChangeBillService.getInstance().updateDeptChgByDepEmpId(personId, effectTimeDate, quitParam.getAlaborrelstatusId());
            LOGGER.info("HAMQuitService quitEffectHam dispchg  end");
            LOGGER.info("HAMQuitService quitEffectHam disprecord start");
            Date enddate = HRDateTimeUtils.addDay((Date)effectTimeDate, (long)-1L);
            DispatchRecordService.getInstance().terminateRecordByPerson(personId.longValue(), (Object)termReason, enddate);
            LOGGER.info("HAMQuitService quitEffectHam disprecord end");
            quitEffectHamResult = true;
        }
        catch (Exception exception) {
            errorMsg = exception.toString();
            quitEffectHamResult = false;
            LOGGER.error("HAMQuitService quitEffectHam error: ", (Throwable)exception);
        }
        map.put("success", quitEffectHamResult);
        map.put("msg", errorMsg);
        return map;
    }

    private Map<String, Object> checkQuitParam(Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String errorMsg = "";
        boolean quitEffectHamResult = true;
        try {
            Long.valueOf(params.get("person_id").toString());
            Long.valueOf(params.get("alaborrelstatus_id").toString());
            Date date = (Date)params.get("effecttime");
        }
        catch (Exception exception) {
            errorMsg = exception.toString();
            quitEffectHamResult = false;
        }
        String title = ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff1a", (String)"HAMService_1", (String)"hr-ham-mservice", (Object[])new Object[0]);
        if (!quitEffectHamResult) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(title);
            stringBuilder.append(errorMsg);
        }
        map.put("success", quitEffectHamResult);
        map.put("msg", errorMsg);
        return map;
    }
}

