/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.service.common.IDispatchHRCSService;
import kd.hr.ham.common.dispatch.constants.DispatchBillConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public class DispatchBillOpUtil
implements DispatchBillConstants {
    private static final Log log = LogFactory.getLog(DispatchBillOpUtil.class);

    private DispatchBillOpUtil() {
    }

    public static DispatchBillOpUtil getInstance() {
        return DispatchBillOpUtilHolder.INSTANCE;
    }

    public void addValidateField(List<String> fieldKeys) {
        fieldKeys.add("disoutinorder");
        fieldKeys.add("instatus");
        fieldKeys.add("outstatus");
        fieldKeys.add("leavedate");
        fieldKeys.add("planreachdate");
        fieldKeys.add("reachdate");
        fieldKeys.add("planstartdate");
        fieldKeys.add("planenddate");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("plandisptype");
        fieldKeys.add("plandispreason");
        fieldKeys.add("plancountry");
        fieldKeys.add("plancompanyin");
        fieldKeys.add("plandepin");
        fieldKeys.add("plancmpempin");
        fieldKeys.add("radiogroupfield");
        fieldKeys.add("planpositionin");
        fieldKeys.add("planstandardposin");
        fieldKeys.add("disptype");
        fieldKeys.add("dispreason");
        fieldKeys.add("planjob");
        fieldKeys.add("jobin");
        fieldKeys.add("countryin");
        fieldKeys.add("companyin");
        fieldKeys.add("deptin");
        fieldKeys.add("cmpempin");
        fieldKeys.add("empgroupin");
        fieldKeys.add("inradiogroupfield");
        fieldKeys.add("positionin");
        fieldKeys.add("standardposin");
        fieldKeys.add("baselocationin");
        fieldKeys.add("affaction");
    }

    public void setPlanSubmitToInInfo(DynamicObject[] dys) {
        log.info("submit_data_id_setPlanToIn_start");
        for (DynamicObject dyObj : dys) {
            String order = dyObj.getString("disoutinorder");
            String inStatus = dyObj.getString("instatus");
            log.info("id:{}_submit_data_id_setPlanToIn_end_order: {}", dyObj.getPkValue(), (Object)order);
            log.info("submit_data_id_setPlanToIn_end_inStatus: {}", (Object)inStatus);
            if (!"1".equals(order) || !HRStringUtils.isEmpty((String)inStatus)) continue;
            DispatchBillOpUtil.setPlanToIn(dyObj);
        }
        log.info("submit_data_id_setPlanToIn_end");
    }

    public static void setPlanToIn(DynamicObject billObj) {
        DynamicObject personFile = billObj.getDynamicObject("ermanfile");
        long depEmpId = personFile.getLong("depemp_id");
        log.info("depEmpId: {}", (Object)depEmpId);
        billObj.set("personfield", personFile.get("depemp"));
        billObj.set("countryin", billObj.get("plancountry"));
        log.info("plancountry:{}", billObj.get("plancountry"));
        billObj.set("companyin", billObj.get("plancompanyin"));
        billObj.set("deptin", billObj.get("plandepin"));
        billObj.set("adminorgin", billObj.get("plandepin"));
        billObj.set("orgin", DispatchBillOpUtil.getHrBuId(billObj.getLong("plandepin.id")));
        billObj.set("cmpempin", billObj.get("plancmpempin"));
        billObj.set("inradiogroupfield", billObj.get("radiogroupfield"));
        log.info("radiogroupfield:{}", billObj.get("radiogroupfield"));
        billObj.set("positionin", billObj.get("planpositionin"));
        billObj.set("standardposin", billObj.get("planstandardposin"));
        billObj.set("jobin", billObj.get("planjob"));
        DispatchBillOpUtil.copyProperty(billObj, "dispatchplansup", "dispatchinsuperior");
        DispatchBillOpUtil.copyProperty(billObj, "dispatchplanincha", "dispatchinincharge");
        billObj.set("reachdate", billObj.get("planreachdate"));
        billObj.set("empgroupin", (Object)1010L);
        billObj.set("dispreason", billObj.get("plandispreason"));
        log.info("plandispreason:{}", billObj.get("plandispreason"));
        billObj.set("disptype", billObj.get("plandisptype"));
        billObj.set("startdate", billObj.get("planstartdate"));
        billObj.set("enddate", billObj.get("planenddate"));
        billObj.set("duration", billObj.get("planduration"));
    }

    private static Object getHrBuId(long deptId) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)4);
        param.put(deptId, Collections.singleton(103010L));
        log.info("IDispatchHRCSService.invokeGetHrBuByBusinessType type_id {}", (Object)1010L);
        List maps = IDispatchHRCSService.getInstance().invokeGetHrBuByBusinessType((Map)param, Long.valueOf(1010L));
        if (Objects.isNull(maps) || maps.isEmpty()) {
            log.info("IDispatchHRCSService.invokeGetHrBuByBusinessType => null");
            return 0L;
        }
        return ((Map)maps.get(0)).get("hrBuId");
    }

    private static void copyProperty(DynamicObject obj, String fromKey, String toKey) {
        DynamicObjectCollection fromColl = obj.getDynamicObjectCollection(fromKey);
        DynamicObjectCollection toColl = obj.getDynamicObjectCollection(toKey);
        toColl.clear();
        for (DynamicObject fromObj : fromColl) {
            DynamicObject toBaseDataIdObj = new DynamicObject(toColl.getDynamicObjectType());
            toBaseDataIdObj.set("fbasedataid", (Object)fromObj.getDynamicObject("fbasedataid"));
            toColl.add((Object)toBaseDataIdObj);
        }
        obj.set(toKey, (Object)toColl);
    }

    private static class DispatchBillOpUtilHolder {
        private static final DispatchBillOpUtil INSTANCE = new DispatchBillOpUtil();

        private DispatchBillOpUtilHolder() {
        }
    }
}

