/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.status.handler.DispatchBillStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.opplugin.validate.DispatchBillUnSubmitValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class DispatchBillUnSubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(DispatchBillUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        super.onPreparePropertys(preparePropertysEventArgs);
        preparePropertysEventArgs.getFieldKeys().add("dispatchstatus");
        preparePropertysEventArgs.getFieldKeys().add("disoutinorder");
        preparePropertysEventArgs.getFieldKeys().add("outstatus");
        preparePropertysEventArgs.getFieldKeys().add("instatus");
        preparePropertysEventArgs.getFieldKeys().add("auditstatus");
        preparePropertysEventArgs.getFieldKeys().add("modifytime");
        preparePropertysEventArgs.getFieldKeys().add("modifier");
        preparePropertysEventArgs.getFieldKeys().add("stopnoticstatus");
        preparePropertysEventArgs.getFieldKeys().add("startdate");
        preparePropertysEventArgs.getFieldKeys().add("planstartdate");
        preparePropertysEventArgs.getFieldKeys().add("ermanfile");
        preparePropertysEventArgs.getFieldKeys().add("billno");
        preparePropertysEventArgs.getFieldKeys().add("billstatus");
        preparePropertysEventArgs.getFieldKeys().add("submitnoticstatus");
        preparePropertysEventArgs.getFieldKeys().add("affaction");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        super.onAddValidators(addValidatorsEventArgs);
        addValidatorsEventArgs.addValidator((AbstractValidator)new DispatchBillUnSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            String dispatchOrder = dynamicObject.getString("disoutinorder");
            String statusHandleKey = this.getStatusHandleKey(dispatchOrder);
            StatusHandleUtils.handle((StatusHandler)new DispatchBillStatusHandler(), (String)statusHandleKey, (DynamicObject)dynamicObject);
            dynamicObject.set("submitnoticstatus", (Object)"0");
        });
        IDispatchPersonChangeService dispatchPersonChangeService = (IDispatchPersonChangeService)ServiceFactory.getService(IDispatchPersonChangeService.class);
        LOGGER.info("start excutePersonChangeNotice cx");
        dispatchPersonChangeService.excutePersonChangeNotice(dataEntities, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO, true);
        LOGGER.info("end excutePersonChangeNotice cx");
    }

    private String getStatusHandleKey(String dispatchOrder) {
        DispatchOrderEnum dispatchOrderEnum = DispatchOrderEnum.getEnumByCode((String)dispatchOrder);
        String statusHandleKey = "";
        if (dispatchOrderEnum == DispatchOrderEnum.IN_2_OUT) {
            statusHandleKey = "in_fir_in_rollback";
        }
        if (dispatchOrderEnum == DispatchOrderEnum.OUT_2_IN) {
            statusHandleKey = "out_fir_out_rollback";
        }
        return statusHandleKey;
    }
}

