/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.ham.business.domain.repository.DispatchRepository;
import kd.hr.ham.business.domain.service.ServiceFactory;
import kd.hr.ham.business.domain.service.common.DispatchEffectService;
import kd.hr.ham.business.domain.service.common.IDispatchPersonChangeService;
import kd.hr.ham.business.domain.status.handler.DispatchBillStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.constants.operate.DispatchAuditOpCode;
import kd.hr.ham.common.dispatch.enums.DispatchOrderEnum;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.opplugin.utils.AuditBillStatusConvert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import org.apache.commons.lang3.time.StopWatch;

public class DispatchBillWorkFlowOp
extends HRCoreBaseBillOp
implements DispatchAuditOpCode {
    private static final Log LOG = LogFactory.getLog(DispatchBillWorkFlowOp.class);
    private static final Table<String, String, String> STATUS_HANDLE_KEY_TABLE = HashBasedTable.create((int)16, (int)3);
    private static final String OUT_2_IN = DispatchOrderEnum.OUT_2_IN.getOrder();
    private static final String IN_2_OUT = DispatchOrderEnum.IN_2_OUT.getOrder();

    public void onPreparePropertys(PreparePropertysEventArgs propertysEventArgs) {
        super.onPreparePropertys(propertysEventArgs);
        propertysEventArgs.getFieldKeys().add("disoutinorder");
        propertysEventArgs.getFieldKeys().add("instatus");
        propertysEventArgs.getFieldKeys().add("outstatus");
        propertysEventArgs.getFieldKeys().add("dispatchstatus");
        propertysEventArgs.getFieldKeys().add("auditstatus");
        propertysEventArgs.getFieldKeys().add("billstatus");
        propertysEventArgs.getFieldKeys().add("inradiogroupfield");
        propertysEventArgs.getFieldKeys().add("indarkposition");
        propertysEventArgs.getFieldKeys().add("person_id");
        propertysEventArgs.getFieldKeys().add("startdate");
        propertysEventArgs.getFieldKeys().add("standardposin");
        propertysEventArgs.getFieldKeys().add("deptin");
        propertysEventArgs.getFieldKeys().add("jobin");
        propertysEventArgs.getFieldKeys().add("positionin");
        propertysEventArgs.getFieldKeys().add("workrole");
        propertysEventArgs.getFieldKeys().add("affaction");
        propertysEventArgs.getFieldKeys().add("startdate");
        propertysEventArgs.getFieldKeys().add("submitnoticstatus");
        propertysEventArgs.getFieldKeys().add("stopnoticstatus");
        propertysEventArgs.getFieldKeys().add("effectstatus");
        propertysEventArgs.getFieldKeys().add("effecttime");
        propertysEventArgs.getFieldKeys().add("billno");
        propertysEventArgs.getFieldKeys().add("ermanfile");
        propertysEventArgs.getFieldKeys().add("id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        StopWatch stopWatch = this.startWatch("monitor DispatchBillWorkFlowOp");
        String operationKey = beginOperationTransactionArgs.getOperationKey();
        DynamicObject[] dynamicObjects = beginOperationTransactionArgs.getDataEntities();
        DispatchBillStatusHandler dispatchBillStatusHandler = new DispatchBillStatusHandler();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            String dispatchOrder = dynamicObject.getString("disoutinorder");
            String statusHandleKey = (String)STATUS_HANDLE_KEY_TABLE.get((Object)dispatchOrder, (Object)operationKey);
            if (HRStringUtils.isEmpty((String)statusHandleKey)) {
                LOG.error("DispatchBillWorkFlowOp error: dispatchOrder-{},operationKey-{}", (Object)dispatchOrder, (Object)operationKey);
                return;
            }
            StatusHandleUtils.handle((StatusHandler)dispatchBillStatusHandler, (String)statusHandleKey, (DynamicObject)dynamicObject);
            AuditBillStatusConvert.updateAuditStatus(dynamicObject);
        });
        DispatchRepository.getInstance().save(dynamicObjects);
        this.stopWatch(stopWatch);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        super.afterExecuteOperationTransaction(afterOperationArgs);
        String operationKey = afterOperationArgs.getOperationKey();
        this.handleAfterAuditNotPass(afterOperationArgs.getDataEntities(), operationKey);
        this.handleAfterAuditPass(operationKey, afterOperationArgs.getDataEntities());
    }

    private void handleAfterAuditNotPass(DynamicObject[] dynamicObjects, String operationKey) {
        if (!HRStringUtils.equals((String)operationKey, (String)"dispout_wfauditnotpass") && !HRStringUtils.equals((String)operationKey, (String)"dispin_auditnotpass")) {
            return;
        }
        LOG.info("DispatchBillWorkFlowOp auditNotPass dispatchIds:{}", Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        IDispatchPersonChangeService changeService = (IDispatchPersonChangeService)ServiceFactory.getService(IDispatchPersonChangeService.class);
        changeService.excutePersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO, false);
    }

    private void handleAfterAuditPass(String operationKey, DynamicObject[] dynamicObjects) {
        List auditPassDts = Arrays.stream(dynamicObjects).filter(dy -> this.isFinalPass(operationKey, dy.getString("disoutinorder"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(auditPassDts)) {
            return;
        }
        DispatchEffectService.getInstance().executeEffect((DynamicObject[])auditPassDts.stream().filter(dy -> {
            Date date = dy.getDate("startdate");
            boolean beforeOrEqualNow = DispatchDateUtils.isBeforeOrEqualNow((Date)date);
            LOG.info("DispatchBillWorkFlowOp dispatch effect, result:{} dispatchId:{} ", (Object)beforeOrEqualNow, (Object)dy.getLong("id"));
            return beforeOrEqualNow;
        }).toArray(DynamicObject[]::new));
    }

    private boolean isFinalPass(String operationKey, String dispatchOrder) {
        return HRStringUtils.equals((String)operationKey, (String)"dispin_auditpass") && HRStringUtils.equals((String)dispatchOrder, (String)OUT_2_IN) || HRStringUtils.equals((String)operationKey, (String)"dispout_wfauditpass") && HRStringUtils.equals((String)dispatchOrder, (String)IN_2_OUT);
    }

    private StopWatch startWatch(String message) {
        StopWatch stopWatch = new StopWatch(message);
        stopWatch.start();
        return stopWatch;
    }

    private void stopWatch(StopWatch stopWatch) {
        stopWatch.stop();
        LOG.info(stopWatch.toString());
    }

    static {
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispout_wfauditing", (Object)"out_fir_out_work_approving");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispout_wfrejecttosubmit", (Object)"out_fir_out_work_fir_reject");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispout_wfauditpass", (Object)"out_fir_out_work_last_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispout_wfauditnotpass", (Object)"out_fir_out_work_no_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispin_auditing", (Object)"out_fir_in_work_approving");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispin_auditpass", (Object)"out_fir_in_work_last_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispin_auditnotpass", (Object)"out_fir_in_work_no_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)OUT_2_IN, (Object)"dispin_wfrejecttosubmit", (Object)"out_fir_in_work_fir_reject");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispin_auditing", (Object)"in_fir_in_work_approving");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispin_wfrejecttosubmit", (Object)"in_fir_in_work_fir_reject");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispin_auditpass", (Object)"in_fir_in_work_last_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispin_auditnotpass", (Object)"in_fir_in_work_no_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispout_wfauditing", (Object)"in_fir_out_work_approving");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispout_wfauditpass", (Object)"in_fir_out_work_last_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispout_wfauditnotpass", (Object)"in_fir_out_work_no_pass");
        STATUS_HANDLE_KEY_TABLE.put((Object)IN_2_OUT, (Object)"dispout_wfrejecttosubmit", (Object)"in_fir_out_work_fir_reject");
    }
}

