/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply.back;

import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.service.common.DispatchBackEffectService;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.handler.DispBackStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.HamEntityFieldUtils;
import kd.hr.ham.opplugin.utils.AuditBillStatusConvert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class DispBackWorkFlowOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(DispBackWorkFlowOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(HamEntityFieldUtils.getAllFields((String)DispatchBackRepository.getInstance().getEntityName()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] entities = args.getDataEntities();
        StatusHandleUtils.batchHandle((StatusHandler)new DispBackStatusHandler(), (String)operationKey, Arrays.asList(entities));
        Arrays.stream(entities).forEach(AuditBillStatusConvert::updateAuditStatus);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        LOG.info("DispBackWorkFlowOp afterExecuteOperationTransaction");
        super.afterExecuteOperationTransaction(afterOperationArgs);
        this.handlePass(afterOperationArgs);
        this.handleNotPass(afterOperationArgs);
    }

    private void handleNotPass(AfterOperationArgs afterOperationArgs) {
        if (!HRStringUtils.equals((String)afterOperationArgs.getOperationKey(), (String)"wfauditnotpass")) {
            return;
        }
        DynamicObject[] dynamicObjects = afterOperationArgs.getDataEntities();
        IDispabackPersonChangeService.getInstance().excutePersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_TERMINATIO);
    }

    private void handlePass(AfterOperationArgs afterOperationArgs) {
        LOG.info("DispBackWorkFlowOp handlePass: {}", (Object)afterOperationArgs.getOperationKey());
        if (!HRStringUtils.equals((String)afterOperationArgs.getOperationKey(), (String)"audit")) {
            return;
        }
        DynamicObject[] dynamicObjects = afterOperationArgs.getDataEntities();
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            Date endDate = dynamicObject.getDate("enddate");
            boolean beforeNow = DispatchDateUtils.isBeforeNow((Date)endDate);
            LOG.info("DispBackWorkFlowOp beforeNow:{}, endDate:{}, backId:{}", new Object[]{beforeNow, endDate, dynamicObject.getLong("id")});
            if (beforeNow) {
                DispatchBackEffectService.getInstance().executeEffect(new DynamicObject[]{dynamicObject});
            } else {
                DispatchRecordService.getInstance().backPreValid(dynamicObject);
            }
        });
    }
}

