/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply.back;

import java.util.Arrays;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.DispatchBackRepository;
import kd.hr.ham.business.domain.service.common.IDispabackPersonChangeService;
import kd.hr.ham.business.domain.status.handler.DispBackStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.enums.PersonChangeOperateTypeEnum;
import kd.hr.ham.common.dispatch.utils.DispatchDateUtils;
import kd.hr.ham.common.dispatch.utils.DyObjOperateUtils;
import kd.hr.ham.opplugin.apply.back.DispatchBackBillUnSubmitOp;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class DispatchBackBillSubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(DispatchBackBillUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs preparePropertysEventArgs) {
        super.onPreparePropertys(preparePropertysEventArgs);
        preparePropertysEventArgs.getFieldKeys().add("id");
        preparePropertysEventArgs.getFieldKeys().add("billno");
        preparePropertysEventArgs.getFieldKeys().add("backdate");
        preparePropertysEventArgs.getFieldKeys().add("submitnoticstatus");
        preparePropertysEventArgs.getFieldKeys().add("stopnoticstatus");
        preparePropertysEventArgs.getFieldKeys().add("ermanfile");
        preparePropertysEventArgs.getFieldKeys().add("enddate");
        preparePropertysEventArgs.getFieldKeys().add("backstatus");
        preparePropertysEventArgs.getFieldKeys().add("issubmit");
        preparePropertysEventArgs.getFieldKeys().add("billstatus");
        preparePropertysEventArgs.getFieldKeys().add("affaction");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        super.onAddValidators(addValidatorsEventArgs);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beginOperationTransactionArgs) {
        super.beginOperationTransaction(beginOperationTransactionArgs);
        DynamicObject[] dataEntities = beginOperationTransactionArgs.getDataEntities();
        Date now = DispatchDateUtils.now();
        long currUserId = RequestContext.get().getCurrUserId();
        Arrays.stream(dataEntities).forEach(dynamicObject -> {
            StatusHandleUtils.handle((StatusHandler)new DispBackStatusHandler(), (String)"submit", (DynamicObject)dynamicObject);
            dynamicObject.set("issubmit", (Object)"1");
            DyObjOperateUtils.updateModifyInfo((DynamicObject)dynamicObject, (Long)currUserId, (Date)now);
        });
        DispatchBackRepository.getInstance().update(dataEntities);
        try {
            IDispabackPersonChangeService.getInstance().excutePersonChangeNotice(dataEntities, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_CREATE);
        }
        catch (Exception exception) {
            LOGGER.error("DispatchBack submit op-> excutePersonChange error:", (Throwable)exception);
        }
    }
}

