/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.apply.change;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.business.domain.repository.bill.RecordChangeRepository;
import kd.hr.ham.business.domain.service.common.IDispchgPersonChangeService;
import kd.hr.ham.business.domain.service.record.DispatchRecordService;
import kd.hr.ham.business.domain.status.handler.RecordChangeStatusHandler;
import kd.hr.ham.business.domain.status.handler.StatusHandler;
import kd.hr.ham.business.domain.status.util.StatusHandleUtils;
import kd.hr.ham.common.dispatch.utils.HamEntityFieldUtils;
import kd.hr.ham.opplugin.utils.AuditBillStatusConvert;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;

public class RecordChangeWorkFlowOp
extends HRCoreBaseBillOp {
    private static final Log LOG = LogFactory.getLog(RecordChangeWorkFlowOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs propertysEventArgs) {
        super.onPreparePropertys(propertysEventArgs);
        propertysEventArgs.getFieldKeys().addAll(HamEntityFieldUtils.getAllFields((String)RecordChangeRepository.getInstance().getEntityName()));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] entities = args.getDataEntities();
        StatusHandleUtils.batchHandle((StatusHandler)new RecordChangeStatusHandler(), (String)operationKey, Arrays.asList(entities));
        Arrays.stream(entities).forEach(AuditBillStatusConvert::updateAuditStatus);
        Arrays.stream(entities).forEach(dynamicObject -> {
            if (HRStringUtils.equals((String)"audit", (String)operationKey)) {
                try {
                    DispatchRecordService.getInstance().changeRecord(dynamicObject);
                    IDispchgPersonChangeService.getInstance().dispchgSentMsg(dynamicObject);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

