/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.ham.common.dispatch.enums.DispatchAuditStatusEnum;

public class AuditBillStatusConvert {
    private static final String BILL_PRE = "BILL_";
    private static final String KEY_AUDIT_STATUS = "auditstatus";
    private static final String KEY_BILL_STATUS = "billstatus";
    private static final Map<String, String> BILL_2_AUDIT = Maps.newHashMapWithExpectedSize((int)8);

    public static String bill2AuditConvert(String billStatus) {
        return BILL_2_AUDIT.get(AuditBillStatusConvert.getBillPre(billStatus));
    }

    public static String bill2AuditConvert(DynamicObject dynamicObject) {
        String billStatus = dynamicObject.getString(KEY_BILL_STATUS);
        return AuditBillStatusConvert.bill2AuditConvert(billStatus);
    }

    public static void updateAuditStatus(DynamicObject dynamicObject) {
        String auditStatus = AuditBillStatusConvert.bill2AuditConvert(dynamicObject);
        dynamicObject.set(KEY_AUDIT_STATUS, (Object)auditStatus);
    }

    private static String getBillPre(String billStatus) {
        return BILL_PRE + billStatus;
    }

    static {
        BILL_2_AUDIT.put(AuditBillStatusConvert.getBillPre(DispatchAuditStatusEnum.APPROVING.getCode()), "D");
        BILL_2_AUDIT.put(AuditBillStatusConvert.getBillPre(DispatchAuditStatusEnum.WAITRESUBMIT.getCode()), "A");
        BILL_2_AUDIT.put(AuditBillStatusConvert.getBillPre(DispatchAuditStatusEnum.APPROVEPASSED.getCode()), "C");
        BILL_2_AUDIT.put(AuditBillStatusConvert.getBillPre(DispatchAuditStatusEnum.APPROVEREJECTED.getCode()), "E");
        BILL_2_AUDIT.put(AuditBillStatusConvert.getBillPre(DispatchAuditStatusEnum.TEMPSTORAGE.getCode()), "A");
    }
}

