/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.opplugin.validate;

import java.util.Date;
import java.util.Locale;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.ham.common.dispatch.bean.PosPatternConfig;
import kd.hr.ham.common.dispatch.bean.PosPatternConfigBean;
import kd.hr.ham.common.dispatch.enums.DispatchPageTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class DispatchStartDateValidator
extends HRDataBaseValidator {
    private static final Log log = LogFactory.getLog(DispatchStartDateValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String order = dataEntity.getString("disoutinorder");
            OperateOption option = this.getOption();
            String formId = option.containsVariable("id") ? option.getVariableValue("id") : option.getVariableValue("entitynumber");
            if (DispatchPageTypeEnum.DISPATCH_OUT.getPageKey().equals(formId)) {
                if (HRStringUtils.equals((String)order, (String)"1")) {
                    this.validateStartDate(extendedDataEntity, "planstartdate", "2");
                    continue;
                }
                this.validateStartDate(extendedDataEntity, "startdate", "3");
                continue;
            }
            this.validateStartDate(extendedDataEntity, "startdate", "3");
        }
    }

    private void validateStartDate(ExtendedDataEntity extendedDataEntity, String startDateKey, String configType) {
        Date dispatchStartDate = extendedDataEntity.getDataEntity().getDate(startDateKey);
        if (dispatchStartDate == null) {
            return;
        }
        PosPatternConfigBean configBean = (PosPatternConfigBean)PosPatternConfig.CONFIG.get(configType);
        String operateKey = this.getOperateKey();
        String tipPrefix = "save".equals(operateKey) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"DispatchStartDateValidator_0", (String)"hr-ham-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"DispatchStartDateValidator_1", (String)"hr-ham-opplugin", (Object[])new Object[0]);
        String patternKey = configBean.getPatternKey();
        String pattern = extendedDataEntity.getDataEntity().getString(patternKey);
        String compareKey = "1".equals(pattern) ? configBean.getPosKey() : ("0".equals(pattern) ? configBean.getStdPosKey() : configBean.getJobKey());
        DynamicObject compareObj = extendedDataEntity.getDataEntity().getDynamicObject(compareKey);
        Date compareDate = compareObj.getDate("firstbsed");
        String compareName = compareObj.getString("name");
        log.info("validateStartDate,startKey:{},pattern:{},compareKey:{},startDate:{},compareDate:{}", new Object[]{startDateKey, pattern, compareKey, HRDateTimeUtils.formatDate((Date)dispatchStartDate), HRDateTimeUtils.formatDate((Date)compareDate)});
        if (dispatchStartDate.before(compareDate)) {
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5f53\u524d\u6240\u9009\u7684\u201c%2$s\u201d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u201c%3$s\u201d\u3002", (String)"DispatchStartDateValidator_2", (String)"hr-ham-opplugin", (Object[])new Object[0]), tipPrefix, compareName, HRDateTimeUtils.formatDate((Date)dispatchStartDate)));
        }
    }
}

