/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.common.dispatch.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.hr.ham.common.dispatch.utils.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRStringUtils;

public enum DispatchBackStatusEnum {
    WAIT_SUBMIT("10", new MultiLangEnumBridge("\u5f85\u63d0\u4ea4", "DispatchBackStatusEnum_0", "hr-ham-common")),
    ALR_SUBMIT("11", new MultiLangEnumBridge("\u6d3e\u8fd4\u5df2\u63d0\u4ea4", "DispatchBackStatusEnum_1", "hr-ham-common")),
    WAIT_RESUBMIT("12", new MultiLangEnumBridge("\u5f85\u91cd\u65b0\u63d0\u4ea4", "DispatchBackStatusEnum_2", "hr-ham-common")),
    APPROVING("15", new MultiLangEnumBridge("\u6d3e\u8fd4\u5ba1\u6279\u4e2d", "DispatchBackStatusEnum_3", "hr-ham-common")),
    PASS("30", new MultiLangEnumBridge("\u6d3e\u8fd4\u5ba1\u6279\u901a\u8fc7", "DispatchBackStatusEnum_4", "hr-ham-common")),
    NOT_PASS("40", new MultiLangEnumBridge("\u6d3e\u8fd4\u7533\u8bf7\u5355\u5ba1\u6279\u672a\u901a\u8fc7\u3002", "DispatchBackStatusEnum_5", "hr-ham-common")),
    DISCARD("50", new MultiLangEnumBridge("\u5df2\u5e9f\u5f03", "DispatchBackStatusEnum_6", "hr-ham-common"));

    private String code;
    private MultiLangEnumBridge bridge;

    private DispatchBackStatusEnum(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public static String getName(String code) {
        if (code == null) {
            return null;
        }
        for (DispatchBackStatusEnum se : DispatchBackStatusEnum.values()) {
            if (!code.equals(se.getCode())) continue;
            return se.getName();
        }
        return null;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static DispatchBackStatusEnum getEnumByCode(String code) {
        return Arrays.stream(DispatchBackStatusEnum.values()).filter(status -> HRStringUtils.equals((String)code, (String)status.getCode())).findFirst().orElse(null);
    }

    public static boolean isInProcess(String code) {
        return DispatchBackStatusEnum.inProcessCode().stream().anyMatch(processCode -> processCode.equals(code));
    }

    public static List<String> inProcessCode() {
        return Stream.of(ALR_SUBMIT, WAIT_RESUBMIT, APPROVING).map(DispatchBackStatusEnum::getCode).collect(Collectors.toList());
    }

    public static List<String> usefulCode() {
        List<String> processCode = DispatchBackStatusEnum.inProcessCode();
        processCode.add(PASS.getCode());
        return processCode;
    }

    public static List<String> onGoingCode() {
        return Stream.of(WAIT_SUBMIT, ALR_SUBMIT, WAIT_RESUBMIT, APPROVING, PASS).map(DispatchBackStatusEnum::getCode).collect(Collectors.toList());
    }
}

