/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.common.dispatch.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.hr.ham.common.dispatch.utils.MultiLangEnumBridge;
import kd.hr.hbp.common.util.HRStringUtils;

public enum RecordChangeStatusEnum {
    WAIT_SUBMIT("10", new MultiLangEnumBridge("\u5f85\u63d0\u4ea4", "RecordChangeStatusEnum_0", "hr-ham-common")),
    ALR_SUBMIT("11", new MultiLangEnumBridge("\u53d8\u66f4\u5df2\u63d0\u4ea4", "RecordChangeStatusEnum_1", "hr-ham-common")),
    WAIT_RESUBMIT("12", new MultiLangEnumBridge("\u5f85\u91cd\u65b0\u63d0\u4ea4", "RecordChangeStatusEnum_2", "hr-ham-common")),
    APPROVING("15", new MultiLangEnumBridge("\u53d8\u66f4\u5ba1\u6279\u4e2d", "RecordChangeStatusEnum_3", "hr-ham-common")),
    PASS("30", new MultiLangEnumBridge("\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7", "RecordChangeStatusEnum_4", "hr-ham-common")),
    NOT_PASS("40", new MultiLangEnumBridge("\u53d8\u66f4\u5ba1\u6279\u4e0d\u901a\u8fc7", "RecordChangeStatusEnum_5", "hr-ham-common")),
    DISCARD("50", new MultiLangEnumBridge("\u5df2\u5e9f\u5f03", "RecordChangeStatusEnum_6", "hr-ham-common"));

    private String code;
    private MultiLangEnumBridge bridge;

    private RecordChangeStatusEnum(String code, MultiLangEnumBridge bridge) {
        this.code = code;
        this.bridge = bridge;
    }

    public String getCode() {
        return this.code;
    }

    public static String getName(String code) {
        if (code == null) {
            return null;
        }
        for (RecordChangeStatusEnum se : RecordChangeStatusEnum.values()) {
            if (!code.equals(se.getCode())) continue;
            return se.getName();
        }
        return null;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static RecordChangeStatusEnum getEnumByCode(String code) {
        return Arrays.stream(RecordChangeStatusEnum.values()).filter(status -> HRStringUtils.equals((String)code, (String)status.getCode())).findFirst().orElse(null);
    }

    public static boolean isInProcess(String code) {
        return RecordChangeStatusEnum.inProcessCode().stream().anyMatch(processCode -> processCode.equals(code));
    }

    public static List<String> inProcessCode() {
        return Stream.of(ALR_SUBMIT, WAIT_RESUBMIT, APPROVING).map(RecordChangeStatusEnum::getCode).collect(Collectors.toList());
    }

    public static List<String> inOnGoingCode() {
        return Stream.of(WAIT_SUBMIT, ALR_SUBMIT, WAIT_RESUBMIT, APPROVING).map(RecordChangeStatusEnum::getCode).collect(Collectors.toList());
    }
}

