/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.common.dispatch.utils;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class DispatchDateUtils {
    public static Date now() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static boolean isBeforeOrEqualNow(Date date) {
        Objects.requireNonNull(date);
        LocalDate now = LocalDate.now();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.isBefore(now) || localDate.isEqual(now);
    }

    public static boolean isBeforeNow(Date date) {
        Objects.requireNonNull(date);
        LocalDate now = LocalDate.now();
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return localDate.isBefore(now);
    }

    public static Date getDate(Object date, String pattern) {
        Date endDate;
        if (Objects.isNull(date)) {
            return null;
        }
        try {
            endDate = HRDateTimeUtils.parseDate((String)String.valueOf(date), (String)pattern);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return endDate;
    }
}

