/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.ham.common.dispatch.utils;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.hr.hbp.common.util.HRStringUtils;

public class HamEntityFieldUtils {
    private HamEntityFieldUtils() {
    }

    public static String getAllProperties(String entityNumber) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return "id";
        }
        List<String> allFields = HamEntityFieldUtils.getAllFields(entityNumber);
        return Joiner.on((char)',').skipNulls().join(allFields);
    }

    public static List<String> getAllFields(String entityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return HamEntityFieldUtils.getAllFields(mainEntityType);
    }

    public static List<String> getAllFields(MainEntityType mainEntityType) {
        ArrayList<String> fields = new ArrayList<String>();
        Map fieldTypeMap = mainEntityType.getAllFields();
        for (Map.Entry entry : fieldTypeMap.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (entityProperty instanceof BasedataProp) {
                fields.add(entityProperty.getName() + ".id");
                continue;
            }
            fields.add(entityProperty.getName());
        }
        return fields;
    }
}

