/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.application.reg.service.IRegBillServiceForQuit;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.mservice.api.IRegBillService;

public class RegBillServiceImpl
implements IRegBillService {
    private static final Log LOGGER = LogFactory.getLog(RegBillServiceImpl.class);

    public Map<String, Object> getRegBillById(Long billPKId) {
        LOGGER.info(String.format("HRMP sys have received our msg , and call back to query this bill %s", billPKId));
        String selectProperties = "effectdate,regbilltype,regcategory";
        DynamicObject reObj = HDMRegBaseBillRepository.getInstance().queryOne(selectProperties, (Object)billPKId);
        return this.buildReturnMap(reObj);
    }

    public Map<String, Object> executePersonQuitEffect(Map<String, Object> personQuitMessage) {
        return IRegBillServiceForQuit.getInstance().executePersonQuit(personQuitMessage);
    }

    public Map<String, Object> executePersonQuitRevoke(Map<String, Object> personQuitRevokeMessage) {
        return IRegBillServiceForQuit.getInstance().executePersonQuitRevoke(personQuitRevokeMessage);
    }

    private Map<String, Object> buildReturnMap(DynamicObject reObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("effectdate", reObj.getDate("effectdate"));
        RegBillTypeEnum regBillTypeEnum = RegBillTypeEnum.getRegBillTypeEnumByStatus((String)reObj.getString("regbilltype"));
        String regBillTypeValue = "";
        if (regBillTypeEnum != null) {
            regBillTypeValue = regBillTypeEnum.getConment();
        }
        map.put("regbilltype", regBillTypeValue);
        map.put("regcategory", reObj.getDynamicObject("regcategory").getString("name"));
        return map;
    }
}

