/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.secondment.repository.SecondmentApplyRepository;
import kd.hr.hdm.mservice.api.ISecondmentApplyBillService;

public class SecondmentApplyBillServiceImpl
implements ISecondmentApplyBillService {
    private static final Log LOGGER = LogFactory.getLog(SecondmentApplyBillServiceImpl.class);

    public Map<String, Object> queryBillById(Long billId) {
        try {
            LOGGER.info("SecondmentApplyBillServiceImpl query bill Id: {}", (Object)billId);
            DynamicObject secondmentApplyBill = SecondmentApplyRepository.getInstance().queryOne("countryin,reachdate,startdate,person,secdreason,countryout,leavedate,enddate,planduration,billno", billId);
            if (secondmentApplyBill != null) {
                Map<String, Object> result = this.buildMap(secondmentApplyBill);
                LOGGER.info("SecondmentApplyBillServiceImpl query result {}", (Object)result.toString());
                return result;
            }
            LOGGER.info("secondmentApplyBill is null");
            return null;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            return null;
        }
    }

    private Map<String, Object> buildMap(DynamicObject secondmentApplyBill) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("billno", secondmentApplyBill.getString("billno"));
        result.put("countryin", secondmentApplyBill.getLong("countryin.id"));
        result.put("countryout", secondmentApplyBill.getLong("countryout.id"));
        result.put("enddate", secondmentApplyBill.getDate("enddate"));
        result.put("leavedate", secondmentApplyBill.getDate("leavedate"));
        result.put("person", secondmentApplyBill.getLong("person.id"));
        result.put("planduration", secondmentApplyBill.getInt("planduration"));
        result.put("reachdate", secondmentApplyBill.getDate("reachdate"));
        result.put("secdreason", secondmentApplyBill.getLong("secdreason.id"));
        result.put("startdate", secondmentApplyBill.getDate("startdate"));
        return result;
    }
}

