/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.parttime.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;

public class ParttimeUtils {
    private static final Log LOGGER = LogFactory.getLog(ParttimeUtils.class);

    public static void showPersonCard(Map<String, Object> erManFile, IFormView view) {
        String personHeadImage = (String)erManFile.get("headsculpture");
        String personName = (String)erManFile.get("name");
        String genderName = (String)erManFile.get("gender");
        String empNumber = (String)erManFile.get("number");
        String adminOrgName = (String)erManFile.get("adminorg");
        String laborTypeName = (String)erManFile.get("laborreltype");
        String laborStatusName = (String)erManFile.get("laborrelstatus");
        String posType = (String)erManFile.get("postype");
        String company = (String)erManFile.get("company");
        String positionType = (String)erManFile.get("apositiontype");
        List superiorInfoList = (List)erManFile.get("superiorinfo");
        if (CollectionUtils.isEmpty((Collection)superiorInfoList)) {
            view.setVisible(Boolean.FALSE, new String[]{"superiorpanelap"});
        } else {
            ParttimeUtils.setLeaderInfo(view, (Map)superiorInfoList.get(0), "superiorimage");
        }
        List chargeInfoList = (List)erManFile.get("chargeinfo");
        if (CollectionUtils.isEmpty((Collection)chargeInfoList)) {
            view.setVisible(Boolean.FALSE, new String[]{"chargepanelap"});
        } else {
            ParttimeUtils.setLeaderInfo(view, (Map)chargeInfoList.get(0), "chargeimage");
        }
        Image imgHeadSculpture = (Image)view.getControl("headsculpturecard");
        if (!HRStringUtils.isEmpty((String)personHeadImage) && !personHeadImage.contains("/images/pc/emotion/default_person_82_82.png")) {
            imgHeadSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)personHeadImage));
        }
        Label lblPersonName = (Label)view.getControl("label_name");
        lblPersonName.setText(personName);
        Label gender = (Label)view.getControl("label_gender");
        if (HRStringUtils.isNotEmpty((String)genderName)) {
            gender.setText(genderName);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flexgender"});
        }
        Label lblNumber = (Label)view.getControl("label_number");
        lblNumber.setText(empNumber);
        Label labelDependencyType = (Label)view.getControl("label_dependencytype");
        labelDependencyType.setText(posType);
        Label lblLaborType = (Label)view.getControl("label_laborreltype");
        lblLaborType.setText(laborTypeName);
        Label lblLaborStatus = (Label)view.getControl("label_laborrelstatus");
        lblLaborStatus.setText(laborStatusName);
        Label companyLab = (Label)view.getControl("label_company");
        companyLab.setText(company);
        view.setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)company)), new String[]{"flexcompany"});
        Label lblJobName = (Label)view.getControl("label_position");
        view.setVisible(Boolean.FALSE, new String[]{"flexjob", "flexposition", "stdpositioncoin", "positioncoin", "jobcoin"});
        if (positionType != null && positionType.equals(PosTypeEnum.STD_POS.getCode()) && null != erManFile.get("stdposition")) {
            lblJobName.setText((String)erManFile.get("stdposition"));
            view.setVisible(Boolean.TRUE, new String[]{"flexposition", "stdpositioncoin"});
            ParttimeUtils.setAssociatedJob(erManFile, view);
        } else if (positionType != null && positionType.equals(PosTypeEnum.POS.getCode()) && null != erManFile.get("position")) {
            lblJobName.setText((String)erManFile.get("position"));
            view.setVisible(Boolean.TRUE, new String[]{"flexposition", "positioncoin"});
            ParttimeUtils.setAssociatedJob(erManFile, view);
        } else if (positionType != null && positionType.equals(PosTypeEnum.JOB.getCode()) && null != erManFile.get("job")) {
            lblJobName.setText((String)erManFile.get("job"));
            view.setVisible(Boolean.TRUE, new String[]{"flexposition", "jobcoin"});
        } else {
            LOGGER.error("error when drawing personCard , please check the positionType and the value under this type ");
        }
        Label lblOrgName = (Label)view.getControl("label_adminorg");
        view.setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)adminOrgName)), new String[]{"flexorg"});
        lblOrgName.setText(adminOrgName);
    }

    private static void setAssociatedJob(Map<String, Object> erManFile, IFormView view) {
        Object job = erManFile.get("job");
        if (job == null) {
            return;
        }
        String associatedJob = (String)job;
        Label lblJobName = (Label)view.getControl("label_job");
        lblJobName.setText(associatedJob);
        view.setVisible(Boolean.TRUE, new String[]{"flexjob"});
    }

    public static void showWarnConfirmOrErrorMsg(IFormView view, ConfirmCallBackListener confirmCallBacks, DataValidate<DynamicObject> dataValidate) {
        ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
        String message = dataValidate.getValidatorContext().map2String();
        switch (range) {
            case VALIDATE_ERROR: {
                view.showErrorNotification(message);
                break;
            }
            case VALIDATE_CONFIRM: {
                view.showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBacks);
            }
        }
    }

    private static void setLeaderInfo(IFormView view, Map<String, Object> leaderInfo, String chargeimage3) {
        Image chargeImage = (Image)view.getControl(chargeimage3);
        String personHeadImage = (String)leaderInfo.get("headsculpture");
        if (!HRStringUtils.isEmpty((String)personHeadImage) && !personHeadImage.contains("/images/pc/emotion/default_person_82_82.png")) {
            chargeImage.setUrl(HRImageUrlUtil.getImageFullUrl((String)personHeadImage));
        }
    }
}

