/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.common.transfer.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class DyTransferUtil {
    private static final Log LOGGER = LogFactory.getLog(DyTransferUtil.class);

    public static Map<String, Object> getPropMap(DynamicObject dy) {
        return DyTransferUtil.getPropMap(dy, null, false);
    }

    public static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey, boolean isIgnore) {
        HashMap<String, Object> resultMap;
        if (dy == null) {
            return Collections.emptyMap();
        }
        try {
            IDataEntityType dataEntityType = dy.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            resultMap = new HashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                if (isIgnore && !ObjectUtils.isEmpty(ignoreKey) && isIgnore && ignoreKey.contains(property.getName())) continue;
                Object propObj = dy.get(property);
                Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                resultMap.put(property.getName(), propObj instanceof DynamicObject ? DyTransferUtil.getBaseDataValue((DynamicObject)propObj) : mapValue);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPropMap property fail:", (Throwable)ex);
            throw new KDBizException("getPropMap property fail.");
        }
        return resultMap;
    }

    private static Object getBaseDataValue(DynamicObject baseDataDy) {
        return baseDataDy.getDataEntityType().getProperties().get((Object)"name") == null ? baseDataDy.get("id") : (baseDataDy.get("name") instanceof ILocaleString ? baseDataDy.getLocaleString("name").getLocaleValue() : baseDataDy.get("name"));
    }
}

