/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.file;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.container.FieldgroupPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.business.repository.ParttimeEndRepository;
import kd.hr.hdm.common.parttime.constants.ParttimeErmanFileConstants;
import kd.hr.hdm.common.parttime.enums.FieldTypeEnum;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.sdk.hr.hspm.common.dto.DrawFormFieldDto;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.base.AbstractFormDrawEdit;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.drawutil.ApCreateUtils;

public class PartFileCustomDrawPlugin
extends AbstractFormDrawEdit {
    private static final Log LOGGER = LogFactory.getLog(PartFileCustomDrawPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        this.addItem(args);
    }

    private void addItem(LoadCustomControlMetasArgs args) {
        FlexPanelAp headPanelAp = this.createFieldPanelAp((FormShowParameter)args.getSource());
        HashMap<String, String> mapHead = new HashMap<String, String>(8);
        mapHead.put("id", "container");
        mapHead.put("items", (String)headPanelAp.createControl().get("items"));
        args.getItems().add(mapHead);
    }

    public void beforeBindData(EventObject args) {
        Container myFldPanel = (Container)this.getView().getControl("container");
        FlexPanelAp headPanelAp = this.createFieldPanelAp(this.getView().getFormShowParameter());
        myFldPanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object person = formShowParameter.getCustomParam("person");
        Long personId = HRJSONUtils.getLongValOfCustomParam((Object)person);
        Object erFile = formShowParameter.getCustomParam("erfileid");
        Long erFileId = HRJSONUtils.getLongValOfCustomParam((Object)erFile);
        LOGGER.info(MessageFormat.format("personId is ->: {0}, erfileId is :{1}", personId, erFileId));
        Object customParam = formShowParameter.getCustomParam("depemp");
        LOGGER.info(MessageFormat.format("depemp is ->: {0}", customParam));
        if (HRStringUtils.equals((String)formShowParameter.getFormId(), (String)"hdm_partfileinfo_dv")) {
            this.setValueOfPartInfo(formShowParameter, erFileId);
        } else if (HRStringUtils.equals((String)formShowParameter.getFormId(), (String)"hdm_partempposorgrel_dv")) {
            this.setValueOfEmpPosorgrel(formShowParameter, personId);
        }
        this.getView().setStatus(OperationStatus.VIEW);
    }

    private void setValueOfEmpPosorgrel(FormShowParameter formShowParameter, Long personId) {
        DynamicObject primaryErManFile = HRServiceUtil.getPrimaryErmanFile((Long)personId);
        if (ObjectUtils.isEmpty((Object)primaryErManFile)) {
            LOGGER.info("primaryErmanfFile is null");
            return;
        }
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        Map erManFile = HRServiceUtil.getErManFileById((Long)primaryErManFile.getLong("id"));
        List<DrawFormFieldDto> list = this.getDrawFormFieldDtos(formShowParameter);
        for (DrawFormFieldDto drawFormFieldDto : list) {
            String field = drawFormFieldDto.getField();
            LOGGER.info("config field : {}", (Object)field);
            if (!properties.containsKey((Object)field)) continue;
            switch (field) {
                case "psuperior": {
                    this.setPrimaryLeaderInfo(erManFile, "superiorinfo", "psuperior");
                    break;
                }
                case "porgleader": {
                    this.setPrimaryLeaderInfo(erManFile, "chargeinfo", "porgleader");
                    break;
                }
                case "pcmpemp": {
                    this.getModel().setValue("pcmpemp", erManFile.get("managingscope_id"));
                    break;
                }
                case "company": {
                    this.getModel().setValue("company", erManFile.get("company_id"));
                    break;
                }
                case "adminorg": {
                    this.getModel().setValue("adminorg", erManFile.get("adminorg_id"));
                    break;
                }
                case "position": {
                    this.getModel().setValue("position", erManFile.get("position_id"));
                    break;
                }
                case "stdposition": {
                    Long stdPositionId = (Long)erManFile.get("stdposition_id");
                    this.getModel().setValue("stdposition", (Object)stdPositionId);
                    break;
                }
                case "primarycity": {
                    this.getModel().setValue("primarycity", erManFile.get("location_id"));
                    break;
                }
                case "apositiontype": {
                    String posType = (String)erManFile.get("apositiontype");
                    this.getModel().setValue("apositiontype", (Object)PosTypeEnum.getName((String)posType));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"job", "position", "stdposition"});
                    this.getView().setVisible(Boolean.TRUE, PosTypeEnum.getFiledName((String)posType));
                    break;
                }
                case "job": {
                    Object job = erManFile.get("job_id");
                    this.getModel().setValue("job", job);
                    break;
                }
            }
        }
    }

    private void setValueOfPartInfo(FormShowParameter formShowParameter, Long erManFileId) {
        List partErManFiles = PersonExternalService.getInstance().invokeGetCardFields(Collections.singletonList(erManFileId));
        if (partErManFiles == null || partErManFiles.size() < 1) {
            return;
        }
        QFilter partFileFilter = new QFilter("partfile", "=", (Object)erManFileId);
        DynamicObject partBill = ParttimeApplyRepository.getInstance().queryOneByFilter("apositiontype, parttimereason", partFileFilter);
        QFilter erManFileFilter = new QFilter("partfile", "=", (Object)erManFileId);
        DynamicObject partEndBill = ParttimeEndRepository.getInstance().queryOneByFilter("enddate", erManFileFilter);
        Map<String, Object> partTimeMap = this.buildPartTimeInfo(partErManFiles, partBill, partEndBill);
        List<DrawFormFieldDto> list = this.getDrawFormFieldDtos(formShowParameter);
        for (DrawFormFieldDto drawFormFieldDto : list) {
            String field = drawFormFieldDto.getField();
            LOGGER.info("config field : {}", (Object)field);
            if (ObjectUtils.isEmpty((Object)partTimeMap.get(field))) continue;
            this.getModel().setValue(field, partTimeMap.get(field));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"astdposition", "bjob", "aposition"});
        this.getView().setVisible(Boolean.TRUE, PosTypeEnum.getFiledNameOfPartTime((String)((String)((Map)partErManFiles.get(0)).get("apositiontype"))));
    }

    private Map<String, Object> buildPartTimeInfo(List<Map<String, Object>> partErmanFiles, DynamicObject partBill, DynamicObject partEndBill) {
        String enddate;
        HashMap<String, Object> partTimeMap = new HashMap<String, Object>();
        if (!ObjectUtils.isEmpty(partErmanFiles)) {
            Map<String, Object> erManFile = partErmanFiles.get(0);
            partTimeMap.put("effectdate", erManFile.get("filestartdate"));
            partTimeMap.put("enddate", erManFile.get("fileenddate"));
            partTimeMap.put("lastworkdate", erManFile.get("fileenddate"));
            partTimeMap.put("acompany", erManFile.get("company_id"));
            partTimeMap.put("aadminorg", erManFile.get("adminorg_id"));
            partTimeMap.put("aposition", erManFile.get("position_id"));
            partTimeMap.put("astdposition", erManFile.get("stdposition_id"));
            partTimeMap.put("bjob", erManFile.get("job_id"));
            partTimeMap.put("apositiontype", PosTypeEnum.getName((String)((String)erManFile.get("apositiontype"))));
            if (!ObjectUtils.isEmpty((Object)erManFile.get("superiorinfo"))) {
                List superiorinfoList = (List)erManFile.get("superiorinfo");
                Long[] superiorIds = (Long[])superiorinfoList.stream().map(superior -> (Long)superior.get("id")).toArray(Long[]::new);
                partTimeMap.put("asuperior", superiorIds);
            }
        }
        if (!ObjectUtils.isEmpty((Object)partBill)) {
            partTimeMap.put("parttimereason", partBill.get("parttimereason"));
        }
        if (!ObjectUtils.isEmpty((Object)partEndBill) && !ObjectUtils.isEmpty((Object)partEndBill.get("enddate"))) {
            partTimeMap.put("enddate", partEndBill.get("enddate"));
            partTimeMap.put("lastworkdate", partEndBill.get("enddate"));
        }
        if (null != partTimeMap.get("enddate") && ParttimeErmanFileConstants.FILTER_DATES.contains(enddate = HRDateTimeUtils.format((Date)((Date)partTimeMap.get("enddate")), (String)"yyyy-MM-dd"))) {
            partTimeMap.put("enddate", null);
            partTimeMap.put("lastworkdate", null);
        }
        return partTimeMap;
    }

    private void setPrimaryLeaderInfo(Map<String, Object> erManfile, String superiorinfo, String psuperior) {
        List superiorinfoList = (List)erManfile.get(superiorinfo);
        if (CollectionUtils.isEmpty((Collection)superiorinfoList)) {
            return;
        }
        Long[] superiorIds = (Long[])superiorinfoList.stream().map(superior -> (Long)superior.get("id")).toArray(Long[]::new);
        this.getModel().setValue(psuperior, (Object)superiorIds);
    }

    private FlexPanelAp createFieldPanelAp(FormShowParameter formShowParameter) {
        FieldgroupPanelAp headPanelAp = new FieldgroupPanelAp();
        headPanelAp.setKey("headAp");
        List<DrawFormFieldDto> list = this.getDrawFormFieldDtos(formShowParameter);
        for (DrawFormFieldDto row : list) {
            FieldAp fieldAp = null;
            if (row.getClassSimpleName().equals(FieldTypeEnum.MULQUERYPROP.getCodeSimpleName())) {
                fieldAp = new FieldAp();
                fieldAp.setId(row.getField());
                fieldAp.setKey(row.getField());
                fieldAp.setName(new LocaleString(row.getName()));
                fieldAp.setFireUpdEvt(true);
                fieldAp.setLock(row.getLock());
                MulBasedataField basedataField = new MulBasedataField();
                basedataField.setBaseEntityId(row.getBaseEntityId());
                basedataField.setAllowAutoList(true);
                basedataField.setFieldName(row.getField());
                basedataField.setCacheLookUpList(true);
                basedataField.setLableHyperlink(false);
                basedataField.setMustInput(row.isMustInput());
                basedataField.setAllowAutoList(true);
                basedataField.setEntityMetadata(new EntityMetadata());
                basedataField.setOrgFuncs(row.getField());
                basedataField.setId(row.getField());
                basedataField.setKey(row.getField());
                fieldAp.setField((Field)basedataField);
            } else {
                fieldAp = ApCreateUtils.createFieldAp((DrawFormFieldDto)row);
            }
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }

    private List<DrawFormFieldDto> getDrawFormFieldDtos(FormShowParameter formShowParameter) {
        LOGGER.info("loadCustomParams is ->: {}", (Object)formShowParameter.getCustomParams());
        return super.getAllFieldList((String)formShowParameter.getCustomParam("params"));
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        MainEntityType newMainType;
        MainEntityType oldMainType = args.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var8) {
            throw new KDException((Throwable)var8, new ErrorCode("PartFileBaseInfoDrawPlugin", var8.getMessage()), new Object[0]);
        }
        List<DrawFormFieldDto> drawFormFields = this.getDrawFormFieldDtos(this.getView().getFormShowParameter());
        this.registDynamicProps(newMainType, drawFormFields);
        args.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, List<DrawFormFieldDto> drawFormFields) {
        if (null == drawFormFields || drawFormFields.size() == 0) {
            return;
        }
        for (DrawFormFieldDto drawFormField : drawFormFields) {
            DateProp fieldProp;
            LOGGER.info("========{}", (Object)drawFormField.getBaseEntityId());
            if (drawFormField.getClassSimpleName().equals(FieldTypeEnum.BASE_DATA.getCodeSimpleName())) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)drawFormField.getBaseEntityId());
                BasedataProp basedataProp = new BasedataProp();
                basedataProp.setName(drawFormField.getField());
                basedataProp.setComplexType((IDataEntityType)dataEntityType);
                basedataProp.setBaseEntityId(drawFormField.getBaseEntityId());
                basedataProp.setRefIdProp((IDataEntityProperty)dataEntityType.getProperty("id"));
                basedataProp.setDisplayName(new LocaleString(drawFormField.getName()));
                basedataProp.setDbIgnore(true);
                basedataProp.setAlias("");
                newMainType.registerComplexProperty((DynamicComplexProperty)basedataProp);
                LongProp idProp = new LongProp(true);
                idProp.setName(drawFormField.getField() + "_id");
                idProp.setDisplayName(new LocaleString(drawFormField.getName() + "_id"));
                idProp.setDbIgnore(true);
                newMainType.registerSimpleProperty((DynamicSimpleProperty)idProp);
                continue;
            }
            if (drawFormField.getClassSimpleName().equals(FieldTypeEnum.DATE.getCodeSimpleName())) {
                fieldProp = new DateProp();
                fieldProp.setName(drawFormField.getField());
                fieldProp.setDisplayName(new LocaleString(drawFormField.getName()));
                fieldProp.setDbIgnore(true);
                newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
                continue;
            }
            if (drawFormField.getClassSimpleName().equals("MulQueryProp")) {
                PartFileCustomDrawPlugin.addMulBasedataProp(newMainType, drawFormField.getField(), drawFormField.getName(), drawFormField);
                continue;
            }
            if (!drawFormField.getClassSimpleName().equals(FieldTypeEnum.TEXT.getCodeSimpleName())) continue;
            fieldProp = new TextProp();
            fieldProp.setName(drawFormField.getField());
            fieldProp.setDisplayName(new LocaleString(drawFormField.getName()));
            fieldProp.setDbIgnore(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
        }
    }

    private static void addMulBasedataProp(MainEntityType mainType, String fieldName, String displayName, DrawFormFieldDto drawFormField) {
        MulBasedataProp mulBasedataProp = new MulBasedataProp();
        mulBasedataProp.setName(fieldName);
        mulBasedataProp.setBaseEntityId(drawFormField.getBaseEntityId());
        mulBasedataProp.setDisplayProp(fieldName);
        mulBasedataProp.setDisplayName(new LocaleString(displayName));
        mulBasedataProp.setDbIgnore(true);
        DynamicSimpleProperty pkidPro = new DynamicSimpleProperty("pkid", Long.class, null);
        MainEntityType newtype = new MainEntityType();
        newtype.setName(fieldName);
        newtype.registerSimpleProperty(pkidPro);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)drawFormField.getBaseEntityId());
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName("fbasedataid");
        basedataProp.setComplexType((IDataEntityType)dataEntityType);
        basedataProp.setBaseEntityId(drawFormField.getBaseEntityId());
        LongProp idProp = new LongProp(true);
        idProp.setName("fbasedataid_id");
        idProp.setDisplayName(new LocaleString("fbasedataid_id"));
        idProp.setDbIgnore(false);
        idProp.setOrdinal(2);
        basedataProp.setRefIdProp((IDataEntityProperty)idProp);
        basedataProp.setDisplayName(new LocaleString(displayName));
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        basedataProp.setOrdinal(1);
        newtype.registerComplexProperty((DynamicComplexProperty)basedataProp);
        mulBasedataProp.setItemType((IDataEntityType)newtype);
        PartFileCustomDrawPlugin.addFieldProp((DynamicObjectType)newtype, "fbasedataid_id", (FieldProp)new LongProp(), displayName);
        mainType.registerCollectionProperty((DynamicCollectionProperty)mulBasedataProp);
    }

    private static void addFieldProp(DynamicObjectType mainType, String fieldName, FieldProp fieldProp, String displayName) {
        fieldProp.setName(fieldName);
        fieldProp.setDisplayName(new LocaleString(displayName));
        fieldProp.setDbIgnore(true);
        mainType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
    }
}

