/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.file;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;

public class PartFilePlugin
extends HRDataBaseList {
    private static final String CALLBACK_ENDPARTTIMEFILE = "endparttimefile";
    private static final String KEY_ENDPARTTIME = "endparttime";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)KEY_ENDPARTTIME)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long erFileId = (Long)formShowParameter.getCustomParam("erfileid");
            Map erManFile = IParttimePersonService.getInstance().getErManFile(erFileId);
            HashSet effectPkIds = Sets.newHashSetWithExpectedSize((int)1);
            HashMap reasonMap = Maps.newHashMapWithExpectedSize((int)1);
            this.parseErManFileInfo(erManFile, effectPkIds, reasonMap);
            if (effectPkIds.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"PartFilePlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, String> startDateMap = this.getPartStartDate(erManFile);
            HashMap<String, Object> idParams = new HashMap<String, Object>(8);
            idParams.put("partfilepkid", effectPkIds);
            idParams.put("selectIds", effectPkIds);
            idParams.put("partstartdata", startDateMap);
            this.showEndPartTimeFile(idParams);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long erFileId = (Long)formShowParameter.getCustomParam("erfileid");
        Map erManFile = IParttimePersonService.getInstance().getErManFile(erFileId);
        String businessStatus = String.valueOf(erManFile.get("businessstatus"));
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)businessStatus, (String)"1")), new String[]{KEY_ENDPARTTIME});
    }

    private void parseErManFileInfo(Map<String, Object> erManFile, Set<Long> effectPkIds, Map<Long, Object> reasonMap) {
        String status = String.valueOf(erManFile.get("businessstatus"));
        Long erManFileId = (Long)erManFile.get("id");
        if (HRStringUtils.equals((String)status, (String)"1")) {
            effectPkIds.add(erManFileId);
        } else {
            reasonMap.put(erManFileId, ResManager.loadKDString((String)"\u517c\u804c\u6863\u6848\u5df2\u5931\u6548\u3002", (String)"PartFilePlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, String> getPartStartDate(Map<String, Object> ermanFile) {
        HashMap<String, String> startDateMap = new HashMap<String, String>(2);
        String status = (String)ermanFile.get("businessstatus");
        Date startDate = (Date)ermanFile.get("startdate");
        String erManFileId = ermanFile.get("id").toString();
        if (StringUtils.equals((CharSequence)status, (CharSequence)"1")) {
            startDateMap.put(erManFileId, String.valueOf(startDate.getTime()));
        }
        return startDateMap;
    }

    private void showEndPartTimeFile(Map<String, Object> customParams) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hdm_endparttime");
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ENDPARTTIMEFILE));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "endparttimefile": {
                if (returnData == null) break;
                String success = (String)returnData.get("success");
                if (StringUtils.equals((CharSequence)success, (CharSequence)"true")) {
                    view.invokeOperation("refresh");
                }
                return;
            }
        }
    }
}

