/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.impt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.common.impl.ImportValidateServiceImpl;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import org.apache.commons.lang3.time.StopWatch;

public class ParttimeApplyListImportPlugin
implements HRImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(ParttimeApplyListImportPlugin.class);

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        if ("affaction".equals(args.getFieldId()) && "hpfs_chgaction".equals(args.getBaseDataName())) {
            List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_parttime_hpfs_new", (String)"hdm_parttimeapplybill");
            args.setFilters(new QFilter("id", "in", (Object)affactionIds).toArray());
        } else if ("partperson".equals(args.getFieldId()) && "hspm_ermanfile".equals(args.getBaseDataName()) && args.isImportInvoke()) {
            StopWatch stopWatch = new StopWatch("beforeQueryRefBd partperson start");
            stopWatch.start();
            LOGGER.info("beforeQueryRefBd partperson");
            ArrayList empNumberList = new ArrayList(args.getBillDataList().size());
            args.getBillDataList().forEach(data -> {
                JSONObject jsonObject = data.getData().getJSONObject(args.getEntityId()).getJSONObject("partperson");
                if (jsonObject != null && jsonObject.containsKey((Object)"number")) {
                    empNumberList.add(jsonObject.getString("number"));
                }
            });
            args.setFilters(new ImportValidateServiceImpl().filterPrimaryErManFilesByEmpNumber(args.getFilters(), empNumberList));
            stopWatch.stop();
            LOGGER.info("beforeQueryRefBd partperson end ,cost time :{}", (Object)stopWatch.getNanoTime());
        }
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        OperateOption operateOption = (OperateOption)args.getOperateOptions().values().stream().findFirst().get();
        operateOption.setVariableValue("source", "hr_import");
    }
}

