/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.common.batch.EntryImportDataBuilder;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportDataBuilder;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportValidateServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hdm.formplugin.parttime.validator.ParttimeBaseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;

public class ErmanfileValidator
extends ParttimeBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(ErmanfileValidator.class);
    private Map<Integer, String> partpersonNumbers;
    private Long orgId;
    private PartTimeEntryImportValidateServiceImpl service = new PartTimeEntryImportValidateServiceImpl();
    private EntryImportDataBuilder builder = new PartTimeEntryImportDataBuilder();
    private static final Map<String, String> ermanfileMap = new HashMap<String, String>(64);

    public ErmanfileValidator(Map<Integer, String> partpersonNumbers, Long orgId) {
        this.partpersonNumbers = partpersonNumbers;
        this.orgId = orgId;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        LOGGER.info("BatchBusinessValidator.partpersonNumbers={}", this.partpersonNumbers);
        HashMap<Long, List> dataMap = new HashMap<Long, List>(billDataList.size());
        HashSet adminorgIds = new HashSet();
        billDataList.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            JSONObject partperson = entry.getJSONObject("partperson");
            String number = partperson != null ? partperson.getString("number") : "";
            int startIndex = importBillData.getStartIndex();
            if (this.partpersonNumbers.containsKey(startIndex) && number.equals(this.partpersonNumbers.get(startIndex))) {
                return;
            }
            Long ermanfileId = entry.getJSONObject("partperson").getLong("id");
            List list = dataMap.getOrDefault(ermanfileId, new ArrayList());
            list.add(importBillData);
            dataMap.put(ermanfileId, list);
            adminorgIds.add(entry.getJSONObject("aadminorg").getLong("boid"));
        });
        List ermanfiles = PersonExternalService.getInstance().invokeGetCardFields(new ArrayList(dataMap.keySet()));
        Map ermanfileMaps = ermanfiles.stream().collect(Collectors.toMap(map -> (Long)map.get("id"), Function.identity()));
        if (CollectionUtils.isEmpty((Collection)ermanfiles)) {
            LOGGER.info("BatchBusinessValidator.invokeGetCardFields error, partpersonNumbers ={}", this.partpersonNumbers);
            return;
        }
        Map orgInfoMap = HRServiceUtil.adminOrgInfoQuery(new ArrayList(adminorgIds));
        dataMap.forEach((ermanfileId, list) -> list.forEach(importBillData -> {
            JSONObject entry = importBillData.getData().getJSONObject("entryentity");
            Map ermanfile = (Map)ermanfileMaps.get(ermanfileId);
            Date startDate = (Date)ermanfile.get("startdate");
            if (HRDateTimeUtils.dayBefore((Date)entry.getDate("effectdate"), (Date)startDate)) {
                String errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u4e0d\u53ef\u65e9\u4e8e\u5165\u804c\u65e5\u671f({0})", (String)"ErmanfileValidator_2", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")});
                this.writeErrorInfo((ImportBillData)importBillData, importLog, errorMsg);
            }
            Long partpersonOrg = (Long)ermanfile.get("org_id");
            if (this.orgId != 0L && partpersonOrg.longValue() != this.orgId.longValue()) {
                this.writeErrorInfo((ImportBillData)importBillData, importLog, ResManager.loadKDString((String)"\u517c\u804c\u4eba\u5458\u4e0d\u5728\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u7684\u7ba1\u7406\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u53d1\u8d77\u517c\u804c\u7533\u8bf7\u3002", (String)"ErmanfileValidator_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            Long aadminorgId = entry.getJSONObject("aadminorg").getLong("id");
            Map map = (Map)orgInfoMap.get(String.valueOf(aadminorgId));
            Object companyId = map.get("belongcompany");
            entry.put("acompany", (Object)this.genJsonObject((Long)companyId));
            ermanfileMap.forEach((transferMetaField, ermanfileField) -> entry.put(transferMetaField, (Object)this.builder.genJSONObject(ermanfile, ermanfileField)));
            entry.put("positiontype", ermanfile.get("apositiontype"));
            entry.put("ename", (Object)((String)ermanfile.get("name")));
            entry.put("affiliateadminorg", (Object)this.genJsonObject(aadminorgId));
        }));
    }

    static {
        ermanfileMap.put("company", "company_id");
        ermanfileMap.put("adminorg", "adminorg_id");
        ermanfileMap.put("primarycity", "location_id");
        ermanfileMap.put("stdposition", "stdposition_id");
        ermanfileMap.put("position", "position_id");
        ermanfileMap.put("job", "job_id");
        ermanfileMap.put("blaborreltype", "laborreltype_id");
        ermanfileMap.put("blaborrelstatus", "laborrelstatus_id");
        ermanfileMap.put("primaryhrbu", "org_id");
        ermanfileMap.put("primaryaftadminorg", "affiliateadminorg_id");
        ermanfileMap.put("primaryempgroup", "empgroup_id");
        ermanfileMap.put("person", "person_id");
        ermanfileMap.put("primaryemployee", "employee_id");
        ermanfileMap.put("primarydepemp", "depemp_id");
        ermanfileMap.put("primarycmpemp", "cmpemp_id");
        ermanfileMap.put("pcmpemp", "managingscope_id");
    }
}

