/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;

public class EndParttimeConfirmPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(EndParttimeConfirmPlugin.class);
    private static final String FIELD_PARTENDDATE = "partenddate";
    private static final String BUSINESS_STATUS_INVALID = "-1";
    private static final String HDM_ENDPARTTIME = "hdm_endparttime";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Button button = (Button)this.getControl("save");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("save".equals(key)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List selectIds = (List)formShowParameter.getCustomParam("selectIds");
            HashMap<Long, String> failMap = new HashMap<Long, String>(selectIds.size());
            List erManFiles = PersonExternalService.getInstance().invokeGetCardFields(selectIds);
            List<Map<String, Object>> passvalidateFiles = this.businessStatusInvalid(selectIds, failMap, erManFiles);
            if (selectIds.size() == 1 && failMap.size() == 1) {
                this.getView().getParentView().showErrorNotification((String)failMap.get(selectIds.get(0)));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                return;
            }
            DynamicObject action = (DynamicObject)this.getModel().getValue("affaction");
            Date partEndDate = (Date)this.getModel().getValue(FIELD_PARTENDDATE);
            if (!passvalidateFiles.isEmpty()) {
                ParttimeServiceHelper.batchEndParttime((Long)action.getLong("id"), (Date)partEndDate, passvalidateFiles);
            }
            if (failMap.isEmpty()) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u517c\u804c\u7ec8\u6b62\u6210\u529f\u3002", (String)"EndParttimePlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("hdm_confirmresult");
                Map excelHeads = ParttimeServiceHelper.getExcelHeads();
                List excelExportHeads = ParttimeServiceHelper.getExcelExportHeads((Map)excelHeads);
                List exportDataList = ParttimeServiceHelper.buildExceportInfo(failMap, (List)erManFiles);
                String excelName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u7ec8\u6b62\u517c\u804c\u64cd\u4f5c\u53cd\u9988_%s", (String)"PartTimeFileListPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), DateUtils.dateToString((Date)new Date(), (DatePattern)DatePattern.YYYY_MM_DD_PURE));
                String excelUrl = ParttimeServiceHelper.getExcelUrl((String)excelName, (List)exportDataList, (List)excelExportHeads);
                parameter.setCustomParam("total", (Object)selectIds.size());
                parameter.setCustomParam("success", (Object)passvalidateFiles.size());
                parameter.setCustomParam("fail", (Object)(selectIds.size() - passvalidateFiles.size()));
                parameter.setCustomParam("excelUrl", (Object)excelUrl);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, HDM_ENDPARTTIME));
                this.getView().getParentView().showForm(parameter);
            }
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private List<Map<String, Object>> businessStatusInvalid(List<Long> filePkIds, Map<Long, String> failMap, List<Map<String, Object>> erManFiles) {
        Date partEndDate = (Date)this.getModel().getValue(FIELD_PARTENDDATE);
        DynamicObject[] erManFileArray = IParttimePersonService.getInstance().listErManFileByPkIds(filePkIds);
        Arrays.stream(erManFileArray).forEach(erManFile -> {
            String businessStatus = erManFile.getString("businessstatus");
            Long id = erManFile.getLong("id");
            Date startDate = erManFile.getDate("startdate");
            if (BUSINESS_STATUS_INVALID.equals(businessStatus)) {
                failMap.put(id, ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u5df2\u7ec8\u6b62\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"EndParttimePlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            } else if (HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)startDate), (Date)partEndDate)) {
                failMap.put(id, ResManager.loadKDString((String)"\u517c\u804c\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u517c\u804c\u5f00\u59cb\u65e5\u671f\u201c{0}\u201d\u3002", (String)"EndParttimePlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd")}));
            }
        });
        if (!failMap.isEmpty()) {
            Set<Long> failIds = failMap.keySet();
            List<Map<String, Object>> crossValidateErManFiles = erManFiles.stream().filter(erManFile -> !failIds.contains((Long)erManFile.get("id"))).collect(Collectors.toList());
            if (crossValidateErManFiles.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return crossValidateErManFiles;
        }
        return erManFiles;
    }
}

