/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.NumberGenerater;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.domain.parttime.ParttimeServiceHelper;
import kd.hr.hdm.business.domain.parttime.external.IParttimePersonService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.service.impl.helper.DirectLeaderHelper;
import kd.hr.hdm.business.domain.parttime.validate.ParttimeValidateHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.parttime.service.ParttimeStatusHandler;
import kd.hr.hdm.common.parttime.util.ParttimeUtils;
import kd.hr.hdm.common.util.HRServiceUtil;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ParttimeApplyBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener,
TipsListener {
    private static final String FLEX_STATUS = "flexstatus";
    private static final Log LOGGER = LogFactory.getLog(ParttimeApplyBillEdit.class);
    private static final String CACHE_STARTDATE = "startdate";
    private static final String IS_SHOW_EFFECT_DATE_CONTROL = "isShowEffDateControl";
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        if (OperationStatus.ADDNEW.equals((Object)formShowParameter.getStatus())) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u517c\u804c\u7533\u8bf7\u5355", (String)"ParttimeApplyBillList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit positionF7 = (BasedataEdit)this.getView().getControl("aposition");
        positionF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit stdPositionF7 = (BasedataEdit)this.getView().getControl("astdposition");
        stdPositionF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hisJob = (BasedataEdit)this.getView().getControl("bjob");
        hisJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
        BasedataEdit partperson = (BasedataEdit)this.getView().getControl("partperson");
        partperson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.showPersonInfo();
        this.setFieldPropertyOfPositionType();
        this.setBarCode();
        this.setBillBarShow();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject event) {
        IDataModel model = this.getModel();
        if (model.getValue("b_ermanfile") == null) {
            model.setValue("b_ermanfile", model.getValue("partperson"));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        ChangeData[] changeDataArray = args.getChangeSet();
        switch (propertyName) {
            case "apositiontype": {
                Arrays.asList("bjob", "aposition", "astdposition", "asuperior").forEach(filed -> this.getModel().setValue(filed, null));
                this.setFieldPropertyOfPositionType();
                DynamicObject adminOrgDynamicObject = this.getModel().getDataEntity().getDynamicObject("aadminorg");
                this.setAdminOrgLeader(adminOrgDynamicObject);
                break;
            }
            case "partperson": {
                Map<String, Object> erManFile = this.showPersonInfo();
                this.hiddenThePosAndJob();
                DynamicObject partPerson = (DynamicObject)changeDataArray[0].getNewValue();
                this.setPersonFieldsValue(partPerson, erManFile);
                this.clearPartInfo();
                this.getModel().setValue("b_ermanfile", this.getModel().getValue("partperson"));
                break;
            }
            case "aadminorg": {
                this.adminOrgChange(changeDataArray[0]);
                break;
            }
            case "aposition": {
                this.positionChange();
                break;
            }
            case "astdposition": {
                this.stdPositionChange();
                break;
            }
            case "effectdate": {
                this.effectDateChange(changeDataArray, propertyName);
                break;
            }
            case "appdispatchnum": {
                this.appDispatchNumChange(changeDataArray[0]);
                break;
            }
        }
    }

    private void appDispatchNumChange(ChangeData changeData) {
        String newDispatchNum = (String)changeData.getNewValue();
        this.getModel().setValue("appremoverel", null);
        if (StringUtils.isNotBlank((CharSequence)newDispatchNum)) {
            Boolean enableSihc = SihcConfigUtil.enableSihc();
            if (!enableSihc.booleanValue()) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long employeeId = dataEntity.getLong("partperson.employee_id");
            String appDispatchNum = dataEntity.getString("appdispatchnum");
            DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId);
            if (!HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) {
                long appRemRelId = appointRemoveRelObj.getLong("id");
                if (ITransferBillApplicationService.getInstance().needConfirmAppointmentWritten()) {
                    this.getPageCache().put("prop_change_save", "1");
                    this.getPageCache().put("appremoverel", String.valueOf(appRemRelId));
                    String tipContent = ParttimeServiceHelper.getAppDispatchNumChangeTip((DynamicObject)appointRemoveRelObj, (DynamicObject)dataEntity);
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("appdispatchnum", (IFormPlugin)this);
                    this.getView().showConfirm(tipContent, MessageBoxOptions.OKCancel, confirmCallBack);
                } else {
                    this.getModel().setValue("appremoverel", (Object)appRemRelId);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        List customQFilters = evt.getCustomQFilters();
        switch (fieldKey) {
            case "aposition": {
                this.filterPosition(evt, customQFilters);
                break;
            }
            case "astdposition": {
                this.filterStdPosition(evt, customQFilters);
                break;
            }
            case "bjob": {
                this.filterBJob(evt, customQFilters);
                break;
            }
            case "partperson": {
                if (this.getModel().getValue("org") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u6dfb\u52a0\u4eba\u5458\u3002", (String)"ParttimeApplyBillEdit_30", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)this.getModel().getValue("org")).getPkValue());
                ListShowParameter showParameterErManFileList = (ListShowParameter)evt.getFormShowParameter();
                showParameterErManFileList.getListFilterParameter().setFilter(orgFilter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "submiteffect".equals(operateKey)) {
            Object dispatchNum = this.getModel().getValue("appdispatchnum");
            Object appRemoveRel = this.getModel().getValue("appremoverel");
            LOGGER.info("appDispatchNum val: {}, appRemoveRel val: {}", dispatchNum, appRemoveRel);
            String appNumChange = this.getPageCache().get("prop_change_save");
            if (StringUtils.isNotBlank((CharSequence)appNumChange)) {
                args.setCancel(true);
                this.getPageCache().remove("prop_change_save");
            }
        }
        if (ParttimeValidateHelper.mustValidOp((OperateOption)option, (String)operateKey)) {
            DynamicObject partBill = this.getModel().getDataEntity();
            if (this.calculateMissedMustInputFiled(partBill)) {
                args.setCancel(true);
                return;
            }
            if (this.effectDateValidate().booleanValue()) {
                args.setCancel(true);
                return;
            }
            if (!ParttimeValidateHelper.validateBillStatus.test(partBill.getString("billstatus"))) {
                return;
            }
            if (ParttimeValidateHelper.illegalSubmitEffect((String)operateKey, (DynamicObject)partBill)) {
                return;
            }
            DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)partBill);
            boolean validateResult = ParttimeValidateHelper.quitValidate.and(ParttimeValidateHelper.ermanfFileChangeValidate).and(ParttimeValidateHelper.singleCheckRepeat).and(ParttimeValidateHelper.crossValidate).test(dataValidate);
            if (!validateResult) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(formOperate.getOperateKey(), (IFormPlugin)this);
                ParttimeUtils.showWarnConfirmOrErrorMsg((IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBacks, (DataValidate)dataValidate);
                args.setCancel(true);
            }
        }
    }

    private Boolean effectDateValidate() {
        Date effectDate = (Date)this.getModel().getValue("effectdate");
        String startDateTime = this.getPageCache().get(CACHE_STARTDATE);
        if (HRStringUtils.isEmpty((String)startDateTime)) {
            long employeeId = this.getModel().getDataEntity().getLong("partperson.employee.id");
            Map empentrel = IParttimePersonService.getInstance().getEmpentrel(employeeId);
            if (empentrel != null) {
                Date startDate = (Date)empentrel.get(CACHE_STARTDATE);
                startDateTime = String.valueOf(startDate.getTime());
                this.getPageCache().put(CACHE_STARTDATE, startDateTime);
            }
        }
        if (!HRStringUtils.isEmpty((String)startDateTime) && HRDateTimeUtils.dayAfter((Date)new Date(Long.parseLong(startDateTime)), (Date)effectDate)) {
            String startDate = HRDateTimeUtils.format((Date)new Date(Long.parseLong(startDateTime)), (String)"yyyy-MM-dd");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u201c{0}\u201d\u3002", (String)"ParttimeApplyBillEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{startDate}));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        boolean isSaveOrSubmit;
        super.afterDoOperation(event);
        String operateKey = event.getOperateKey();
        OperationResult operationResult = event.getOperationResult();
        if (HRStringUtils.equals((String)"bar_close", (String)operateKey) || HRStringUtils.equals((String)"bar_viewflowchart", (String)operateKey) || null != operationResult && !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "save": 
            case "unsubmit": {
                this.getView().setStatus(OperationStatus.VIEW);
                break;
            }
            case "modify": {
                this.getView().setStatus(OperationStatus.EDIT);
                break;
            }
        }
        DynamicObject partBill = this.getModel().getDataEntity();
        Date effectDate = partBill.getDate("effectdate");
        boolean bl = isSaveOrSubmit = "save".equals(operateKey) || "submit".equals(operateKey);
        if (isSaveOrSubmit && (effectDate.after(new Date()) || DateUtils.isSameDay((Date)effectDate, (Date)new Date())) || "submiteffect".equals(operateKey) && effectDate.after(new Date())) {
            IParttimeBillService.getInstance().changeToBoId(partBill);
            IParttimeBillService.getInstance().update(partBill);
        }
        if (isSaveOrSubmit && effectDate.before(new Date()) && !DateUtils.isSameDay((Date)effectDate, (Date)new Date())) {
            IParttimeBillService.getInstance().changeBoIdToVId(partBill);
            IParttimeBillService.getInstance().update(partBill);
        }
        this.setBillBarShow();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((HRStringUtils.equals((String)"save", (String)callBackId) || HRStringUtils.equals((String)"submit", (String)callBackId) || HRStringUtils.equals((String)"submiteffect", (String)callBackId)) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(callBackId, "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(callBackId, operateOption);
        }
        if ("appdispatchnum".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                String appRemRelIdStr = this.getPageCache().get("appremoverel");
                long appRemRelId = Long.parseLong(appRemRelIdStr);
                this.getModel().setValue("appremoverel", (Object)appRemRelId);
            }
            this.getPageCache().remove("prop_change_save");
        }
    }

    private void filterStdPosition(BeforeF7SelectEvent evt, List<QFilter> customQFilters) {
        Date effectDate;
        Date filterDate;
        List<QFilter> qFilters;
        DynamicObject parttimeEntity = this.getModel().getDataEntity();
        DynamicObject mainStandardPosition = parttimeEntity.getDynamicObject("stdposition");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (mainStandardPosition != null) {
            long boId = mainStandardPosition.getLong("boid");
            qFilters = this.buildFilterMainAdminOrg(PosTypeEnum.STD_POS.getCode(), boId);
            if (qFilters.size() > 0) {
                filters.addAll(qFilters);
            }
        }
        if ((qFilters = this.buildFilterDate(filterDate = HRObjectUtils.isEmpty((Object)(effectDate = parttimeEntity.getDate("effectdate"))) ? new Date() : effectDate)).size() > 0) {
            filters.addAll(qFilters);
        }
        evt.getFormShowParameter().getCustomParams().put(IS_SHOW_EFFECT_DATE_CONTROL, Boolean.TRUE);
        if (customQFilters == null) {
            evt.setCustomQFilters(filters);
        } else {
            evt.getCustomQFilters().addAll(filters);
        }
        evt.getFormShowParameter().getCustomParams().put("effectdate", filterDate);
    }

    private List<QFilter> buildFilterMainAdminOrg(String partPosType, long boId) {
        String posType = (String)this.getModel().getValue("positiontype");
        DynamicObject partAdminOrg = (DynamicObject)this.getModel().getValue("aadminorg");
        DynamicObject mainAdminOrg = (DynamicObject)this.getModel().getValue("adminorg");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (partAdminOrg == null || mainAdminOrg == null) {
            return filters;
        }
        if (posType.equals(partPosType) && partAdminOrg.get("boid").equals(mainAdminOrg.get("boid"))) {
            filters.add(new QFilter("boid", "!=", (Object)boId));
        }
        return filters;
    }

    private List<QFilter> buildFilterDate(Date filterDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("bsed", "<=", (Object)filterDate));
        filters.add(new QFilter("bsled", ">=", (Object)filterDate));
        return filters;
    }

    private void filterBJob(BeforeF7SelectEvent evt, List<QFilter> customQFilters) {
        Date effectDate;
        Date filterDate;
        List<QFilter> qFilters;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject mainJob = (DynamicObject)this.getModel().getValue("job");
        if (mainJob != null) {
            long boId = mainJob.getLong("boid");
            qFilters = this.buildFilterMainAdminOrg(PosTypeEnum.JOB.getCode(), boId);
            if (qFilters.size() > 0) {
                filters.addAll(qFilters);
            }
        }
        if ((qFilters = this.buildFilterDate(filterDate = HRObjectUtils.isEmpty((Object)(effectDate = (Date)this.getModel().getValue("effectdate"))) ? new Date() : effectDate)).size() > 0) {
            filters.addAll(qFilters);
        }
        evt.getFormShowParameter().getCustomParams().put(IS_SHOW_EFFECT_DATE_CONTROL, Boolean.TRUE);
        if (customQFilters == null) {
            evt.setCustomQFilters(filters);
        } else {
            evt.getCustomQFilters().addAll(filters);
        }
        evt.getFormShowParameter().getCustomParams().put("effectdate", filterDate);
    }

    private void judgeEffectDateWithHis() {
        Arrays.asList("aposition", "astdposition", "bjob").forEach(this::changeByeEffectDate);
    }

    private void changeByeEffectDate(String filed) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(filed);
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        Date effectDate = (Date)this.getModel().getValue("effectdate");
        Date startDate = dynamicObject.getDate("bsed");
        Date endDate = dynamicObject.getDate("bsled");
        if (DateUtils.isSameDay((Date)effectDate, (Date)startDate) || DateUtils.isSameDay((Date)effectDate, (Date)endDate) || effectDate.after(startDate) && effectDate.before(endDate)) {
            return;
        }
        if ("aposition".equals(filed)) {
            this.changePositionByEffectDate();
        }
        if ("astdposition".equals(filed)) {
            this.changeStdPositionByEffectDate();
        }
        String postType = this.getModel().getDataEntity().getString("apositiontype");
        if (PosTypeEnum.JOB.getCode().equals(postType) && "bjob".equals(filed)) {
            this.changeJobByEffectDate();
        }
    }

    private void changeJobByEffectDate() {
        Object obj = this.getModel().getValue("bjob");
        if (obj == null) {
            return;
        }
        DynamicObject jobObject = (DynamicObject)obj;
        long boId = jobObject.getLong("boid");
        Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
        Map hisJobMap = IParttimeBillService.getInstance().getNewHisJob(Long.valueOf(boId), effectDate);
        this.getModel().setValue("bjob", hisJobMap.get("jobVid"));
    }

    private void changePositionByEffectDate() {
        Object obj = this.getModel().getValue("aposition");
        if (obj == null) {
            return;
        }
        DynamicObject positionObject = (DynamicObject)obj;
        Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
        Map map = IParttimeBillService.getInstance().getJobHisOfPosition(Long.valueOf(positionObject.getLong("boid")), effectDate);
        this.getModel().setValue("aposition", map.get("vid"));
        this.getModel().setValue("bjob", map.get("jobVid"));
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        this.setAdminOrgAndSuperior(dataEntity);
    }

    private void changeStdPositionByEffectDate() {
        Object obj = this.getModel().getValue("astdposition");
        if (obj == null) {
            return;
        }
        DynamicObject stdPositionObject = (DynamicObject)obj;
        Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
        Map map = IParttimeBillService.getInstance().getJobHisOfStdPosition(Long.valueOf(stdPositionObject.getLong("boid")), effectDate);
        this.getModel().setValue("astdposition", map.get("vid"));
        this.getModel().setValue("bjob", map.get("jobVid"));
    }

    private void hiddenThePosAndJob() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bjob", "aposition", "astdposition"});
        Arrays.asList("bjob", "aposition", "astdposition").forEach(baseDataEdit -> ((BasedataEdit)this.getControl((String)baseDataEdit)).setMustInput(false));
    }

    private void clearPartInfo() {
        Arrays.asList("aposition", "acompany", "affiliateadminorg", "hrbu", "aadminorg", "aadminorgleader", "effectdate", "acity", "astdposition", "asuperior", "apositiontype", "aworkrole", "appdispatchnum", "appremoverel", "parttimereason").forEach(filed -> this.getModel().setValue(filed, null));
    }

    private void setFieldPropertyOfPositionType() {
        String aPositionType = (String)this.getModel().getValue("apositiontype");
        BasedataEdit job = (BasedataEdit)this.getView().getControl("bjob");
        BasedataEdit aPosition = (BasedataEdit)this.getView().getControl("aposition");
        BasedataEdit standardPosition = (BasedataEdit)this.getView().getControl("astdposition");
        this.getView().setVisible(Boolean.FALSE, new String[]{"astdposition", "aposition", "bjob"});
        if (HRStringUtils.equals((String)aPositionType, (String)PosTypeEnum.POS.getCode())) {
            this.getView().setVisible(Boolean.TRUE, PosTypeEnum.getFiledNameOfPartTime((String)PosTypeEnum.POS.getCode()));
            this.getView().setEnable(Boolean.FALSE, new String[]{"bjob"});
            aPosition.setMustInput(true);
            job.setMustInput(false);
        } else if (HRStringUtils.equals((String)aPositionType, (String)PosTypeEnum.JOB.getCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bjob"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bjob"});
            job.setMustInput(true);
            aPosition.setMustInput(false);
        } else if (HRStringUtils.equals((String)aPositionType, (String)PosTypeEnum.STD_POS.getCode())) {
            this.getView().setVisible(Boolean.TRUE, PosTypeEnum.getFiledNameOfPartTime((String)PosTypeEnum.STD_POS.getCode()));
            this.getView().setEnable(Boolean.FALSE, new String[]{"bjob"});
            standardPosition.setMustInput(true);
            job.setMustInput(false);
        }
    }

    private Map<String, Object> showPersonInfo() {
        Map<String, Object> erManFile = this.getErManFile();
        if (ObjectUtils.isEmpty(erManFile)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personcard", "businesspanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"placeholderflexpanelap"});
            return erManFile;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"businesspanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"placeholderflexpanelap"});
        String positionType = (String)this.getModel().getValue("positiontype");
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)positionType, (String)"1")), new String[]{"position"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)positionType, (String)"0")), new String[]{"stdposition"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        ParttimeUtils.showPersonCard(erManFile, (IFormView)this.getView());
        if (!HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personcard"});
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hdm_partpersoncard");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("personcard");
            showParameter.setCustomParam("erManfile", erManFile);
            this.getView().showForm(showParameter);
        }
        this.setPrimaryLeaderInfo(erManFile, "superiorinfo", "psuperior");
        this.setPrimaryLeaderInfo(erManFile, "chargeinfo", "porgleader");
        return erManFile;
    }

    private void setPrimaryLeaderInfo(Map<String, Object> erManfile, String superiorinfo2, String psuperior) {
        List superiorInfoList = (List)erManfile.get(superiorinfo2);
        LOGGER.info("psuperior:{},superiorInfoList:{}", (Object)psuperior, (Object)superiorInfoList);
        if (CollectionUtils.isEmpty((Collection)superiorInfoList)) {
            this.getModel().setValue(psuperior, null);
            return;
        }
        Long[] superiorIds = (Long[])superiorInfoList.stream().map(superiorinfo -> (Long)superiorinfo.get("id")).toArray(Long[]::new);
        LOGGER.info("psuperior:{},superiorIds:{}", (Object)psuperior, (Object)superiorIds);
        this.getModel().setValue(psuperior, (Object)superiorIds);
    }

    private Map<String, Object> getErManFile() {
        Object partPerson = this.getModel().getValue("partperson");
        if (null == partPerson) {
            return Collections.EMPTY_MAP;
        }
        Long ermanFiledId = (Long)((DynamicObject)partPerson).getPkValue();
        return HRServiceUtil.getErManFileById((Long)ermanFiledId);
    }

    private boolean calculateMissedMustInputFiled(DynamicObject partBill) {
        String posType = partBill.getString("apositiontype");
        Object position = partBill.get("aposition");
        Object job = partBill.get("bjob");
        if (null == position && PosTypeEnum.POS.getCode().equals(posType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u517c\u804c\u5c97\u4f4d\u201d\u3002", (String)"ParttimeApplyBillEdit_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (job == null && PosTypeEnum.JOB.getCode().equals(posType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u517c\u804c\u804c\u4f4d\u201d\u3002", (String)"ParttimeApplyBillEdit_15", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setBillBarShow() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (HRStringUtils.isEmpty((String)billStatus)) {
            view.setVisible(Boolean.FALSE, new String[]{FLEX_STATUS});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{FLEX_STATUS});
        Label lblAuditStatus = (Label)view.getControl("lblauditstatus");
        ParttimeStatusHandler statusStr = ParttimeStatusHandler.getInstance((String)billStatus);
        if (statusStr != null) {
            lblAuditStatus.setText(statusStr.localString());
        }
        String partTimeStatus = (String)this.getModel().getValue("parttimestatus");
        Set status = Arrays.stream(new String[]{"B", "C", "D", "G"}).collect(Collectors.toSet());
        Boolean showBarDiscard = status.contains(billStatus) && HRStringUtils.equals((String)partTimeStatus, (String)"0");
        view.setVisible(showBarDiscard, new String[]{"bar_discard"});
        boolean isExistWorkFlow = HRStringUtils.equals((String)billStatus, (String)"C") && (Boolean)this.getModel().getValue("isexistsworkflow") == false;
        boolean notShowWfPanel = HRStringUtils.equals((String)view.getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getEntityId(), (String)"wf_approvalpage_bac") || HRStringUtils.equals((String)billStatus, (String)"A") || isExistWorkFlow;
        view.setVisible(Boolean.valueOf(!notShowWfPanel), new String[]{"rightmainpanel"});
    }

    private void cleanPartJobOrStandardPosition(long adminOrgBoId) {
        String posType = (String)this.getModel().getValue("positiontype");
        String partPosType = (String)this.getModel().getValue("apositiontype");
        if (PosTypeEnum.POS.getCode().equals(partPosType) || !posType.equals(partPosType)) {
            return;
        }
        DynamicObject mainAdminOrg = (DynamicObject)this.getModel().getValue("adminorg");
        if (mainAdminOrg == null || !mainAdminOrg.get("boid").equals(adminOrgBoId)) {
            return;
        }
        if (PosTypeEnum.STD_POS.getCode().equals(partPosType)) {
            DynamicObject mainStandardPosition = (DynamicObject)this.getModel().getValue("stdposition");
            DynamicObject partStandardPosition = (DynamicObject)this.getModel().getValue("astdposition");
            if (mainStandardPosition == null || partStandardPosition == null) {
                return;
            }
            if (mainStandardPosition.get("boid").equals(partStandardPosition.get("boid"))) {
                this.getModel().setValue("astdposition", null);
            }
        }
        if (PosTypeEnum.JOB.getCode().equals(partPosType)) {
            DynamicObject mainJob = (DynamicObject)this.getModel().getValue("job");
            DynamicObject partJob = (DynamicObject)this.getModel().getValue("bjob");
            if (mainJob == null || partJob == null) {
                return;
            }
            if (partJob.get("boid").equals(mainJob.get("boid"))) {
                this.getModel().setValue("bjob", null);
            }
        }
    }

    private void adminOrgChange(ChangeData changeData) {
        List result;
        DynamicObject adminOrg = (DynamicObject)changeData.getNewValue();
        if (adminOrg == null) {
            Arrays.asList("aposition", "acompany", "affiliateadminorg", "hrbu", "aadminorgleader", "asuperior", "astdposition", "aworkrole").forEach(temp -> this.getModel().setValue(temp, null));
            return;
        }
        long boId = adminOrg.getLong("boid");
        this.cleanPartJobOrStandardPosition(boId);
        long cityId = HRDyObjectPropUtil.getId((DynamicObject)((DynamicObject)adminOrg.get("city")));
        this.getModel().setValue("acity", (Object)(cityId != 0L ? Long.valueOf(cityId) : null));
        Long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)adminOrg);
        this.getModel().setValue("affiliateadminorg", (Object)(adminOrgId != 0L ? adminOrgId : null));
        Map orgInfo = HRServiceUtil.adminOrgInfoQuery(Collections.singletonList(adminOrgId));
        if (!ObjectUtils.isEmpty((Object)orgInfo)) {
            Map map = (Map)orgInfo.get(String.valueOf(adminOrgId));
            Object companyId = map.get("belongcompany");
            this.getModel().setValue("acompany", !ObjectUtils.isEmpty(companyId) ? companyId : null);
        }
        if (!ObjectUtils.isEmpty((Object)(result = HRServiceUtil.getHrBuByBusinessType(Collections.singletonList(adminOrgId))))) {
            long hrBuId = (Long)((Map)result.get(0)).get("hrBuId");
            this.getModel().setValue("hrbu", (Object)hrBuId);
        }
        if (!ObjectUtils.isEmpty((Object)changeData.getOldValue())) {
            this.getModel().setValue("aposition", null);
            this.getModel().setValue("astdposition", null);
        }
        this.setAdminOrgLeader(adminOrg);
    }

    private void setAdminOrgLeader(DynamicObject adminOrg) {
        if (adminOrg == null) {
            return;
        }
        String aPositionType = (String)this.getModel().getValue("apositiontype");
        boolean isPositionFlag = HRStringUtils.equals((String)aPositionType, (String)"1");
        if (isPositionFlag) {
            return;
        }
        this.setSuperiorValue(this.getModel().getDataEntity());
    }

    private void positionChange() {
        DynamicObject positionObject = (DynamicObject)this.getModel().getValue("aposition");
        this.getModel().setValue("asuperior", null);
        if (ObjectUtils.isEmpty((Object)positionObject)) {
            this.getModel().setValue("bjob", null);
            return;
        }
        this.getModel().setValue("bjob", null);
        Date effectDate = this.getModel().getDataEntity().getDate("effectdate");
        Map map = IParttimeBillService.getInstance().getJobHisOfPosition(Long.valueOf(positionObject.getLong("boid")), effectDate);
        this.getModel().setValue("bjob", map.get("jobVid"));
        this.setAdminOrgAndSuperior(this.getModel().getDataEntity());
    }

    private void setAdminOrgAndSuperior(DynamicObject dataEntity) {
        DynamicObject positionDyn = dataEntity.getDynamicObject("aposition");
        if (Objects.isNull(positionDyn)) {
            this.getModel().setValue("asuperior", null);
            return;
        }
        long adminOrgId = HRDyObjectPropUtil.getId((DynamicObject)positionDyn.getDynamicObject("adminorg"));
        this.getModel().setValue("aadminorg", (Object)adminOrgId);
        Long roleId = positionDyn.getLong("workrole.id");
        LOGGER.info("workrole id: {0}", (Object)roleId);
        this.getModel().setValue("aworkrole", (Object)roleId);
        this.setSuperiorValue(dataEntity);
    }

    private void setSuperiorValue(DynamicObject dataEntity) {
        try {
            long dummyId = ORM.create().genLongId("hrpi_person");
            LinkedHashMap dynVsIdMap = Maps.newLinkedHashMapWithExpectedSize((int)1);
            dynVsIdMap.put(dataEntity, dummyId);
            List infInParamList = DirectLeaderHelper.buildParamMap((DynamicObject[])new DynamicObject[]{dataEntity}, (Map)dynVsIdMap);
            Map idVsLeaderListMap = IParttimeBillService.getInstance().getLeaderByRuleFromHRPI(infInParamList);
            List leaderList = idVsLeaderListMap.getOrDefault(dummyId, Lists.newArrayListWithExpectedSize((int)0));
            LOGGER.info("leaderList id: {}", (Object)leaderList);
            if (leaderList.size() > 0) {
                List personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
                if (Objects.nonNull(personIdList)) {
                    this.getModel().setValue("asuperior", (Object)personIdList.toArray());
                }
            } else {
                this.getModel().setValue("asuperior", null);
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    private void stdPositionChange() {
        DynamicObject stdPositionObject = (DynamicObject)this.getModel().getValue("astdposition");
        if (ObjectUtils.isEmpty((Object)stdPositionObject)) {
            this.getModel().setValue("bjob", null);
            return;
        }
        this.getModel().setValue("bjob", null);
        long jobId = stdPositionObject.getLong("job.id");
        this.getModel().setValue("bjob", (Object)jobId);
    }

    private void effectDateChange(ChangeData[] changeDataArray, String propertyName) {
        if (changeDataArray[0].getNewValue() == null) {
            return;
        }
        Date effectDate = (Date)this.getModel().getValue(propertyName);
        Date now = HRDateTimeUtils.truncateDate((Date)new Date());
        String startDateTime = this.getPageCache().get(CACHE_STARTDATE);
        if (HRStringUtils.isEmpty((String)startDateTime)) {
            long employeeId = this.getModel().getDataEntity().getLong("partperson.employee.id");
            Map empentrel = IParttimePersonService.getInstance().getEmpentrel(employeeId);
            if (empentrel != null) {
                Date startDate = (Date)empentrel.get(CACHE_STARTDATE);
                startDateTime = String.valueOf(startDate.getTime());
                this.getPageCache().put(CACHE_STARTDATE, startDateTime);
            }
        }
        this.judgeEffectDateWithHis();
        if (!HRStringUtils.isEmpty((String)startDateTime) && HRDateTimeUtils.dayAfter((Date)new Date(Long.parseLong(startDateTime)), (Date)effectDate)) {
            String startDate = HRDateTimeUtils.format((Date)new Date(Long.parseLong(startDateTime)), (String)"yyyy-MM-dd");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u201c{0}\u201d\u3002", (String)"ParttimeApplyBillEdit_0", (String)"hr-hdm-formplugin", (Object[])new Object[]{startDate}));
        } else if (HRDateTimeUtils.dayAfter((Date)now, (Date)effectDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"ParttimeApplyBillEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void filterPosition(BeforeF7SelectEvent evt, List<QFilter> customQFilters) {
        Date effectDate;
        Date filterDate;
        List<QFilter> qFilters;
        DynamicObject adminOrg;
        DynamicObject primaryPosition = (DynamicObject)this.getModel().getValue("position");
        String posType = (String)this.getModel().getValue("positiontype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (primaryPosition != null && PosTypeEnum.POS.getCode().equals(posType)) {
            filters.add(new QFilter("boid", "!=", primaryPosition.get("boid")));
        }
        if ((adminOrg = (DynamicObject)this.getModel().getValue("aadminorg")) != null) {
            filters.add(new QFilter("adminorg", "=", adminOrg.getPkValue()));
        }
        if ((qFilters = this.buildFilterDate(filterDate = HRObjectUtils.isEmpty((Object)(effectDate = (Date)this.getModel().getValue("effectdate"))) ? new Date() : effectDate)).size() > 0) {
            filters.addAll(qFilters);
        }
        if (null == customQFilters) {
            evt.setCustomQFilters(filters);
        } else {
            evt.getCustomQFilters().addAll(filters);
        }
        evt.getFormShowParameter().getCustomParams().put(IS_SHOW_EFFECT_DATE_CONTROL, Boolean.TRUE);
        evt.getFormShowParameter().getCustomParams().put("effectdate", filterDate);
    }

    private void setPersonFieldsValue(DynamicObject partPerson, Map<String, Object> erManFile) {
        if (partPerson == null) {
            this.setPartTimeInfoNull();
            return;
        }
        IDataModel model = this.getModel();
        if (ObjectUtils.isEmpty(erManFile) || !this.validateLicense(erManFile)) {
            return;
        }
        long empposorgrelId = partPerson.getLong("empposrel.id");
        if (empposorgrelId == 0L) {
            this.setPartTimeInfoNull();
            return;
        }
        model.setValue("company", erManFile.get("company_id"));
        model.setValue("adminorg", erManFile.get("adminorg_id"));
        Object positionId = erManFile.get("position_id");
        Object stdPositionId = erManFile.get("stdposition_id");
        model.setValue("stdposition", stdPositionId);
        model.setValue("position", positionId);
        model.setValue("job", erManFile.get("job_id"));
        model.setValue("positiontype", erManFile.get("apositiontype"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"job", "position", "stdposition"});
        this.getView().setVisible(Boolean.TRUE, PosTypeEnum.getFiledName((String)((String)erManFile.get("apositiontype"))));
        model.setValue("primarycity", erManFile.get("location_id"));
        Date startDate = (Date)erManFile.get(CACHE_STARTDATE);
        this.getPageCache().put(CACHE_STARTDATE, String.valueOf(startDate.getTime()));
        model.setValue("blaborreltype", erManFile.get("laborreltype_id"));
        model.setValue("blaborrelstatus", erManFile.get("laborrelstatus_id"));
        model.setValue("primaryhrbu", erManFile.get("org_id"));
        model.setValue("primaryaftadminorg", erManFile.get("affiliateadminorg_id"));
        model.setValue("primaryempgroup", erManFile.get("empgroup_id"));
        model.setValue("person", erManFile.get("person_id"));
        model.setValue("primaryemployee", erManFile.get("employee_id"));
        model.setValue("primarydepemp", erManFile.get("depemp_id"));
        model.setValue("primarycmpemp", erManFile.get("cmpemp_id"));
        model.setValue("pcmpemp", erManFile.get("managingscope_id"));
    }

    private boolean validateLicense(Map<String, Object> erManFile) {
        String businessMsg = ResManager.loadKDString((String)"\u517c\u804c", (String)"ParttimeApplyBillEdit_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        String validateMsg = HRCertValidateServiceHelper.getValidataMsg((Long)((Long)erManFile.get("person_id")), (String)businessMsg);
        if (HRStringUtils.isNotEmpty((String)validateMsg)) {
            this.getView().showErrorNotification(validateMsg);
            this.setPartTimeInfoNull();
            return false;
        }
        return true;
    }

    private void setPartTimeInfoNull() {
        IDataModel model = this.getModel();
        model.setValue("partperson", null);
        model.setValue("company", null);
        model.setValue("adminorg", null);
        model.setValue("position", null);
        model.setValue("job", null);
        model.setValue("bjob", null);
        model.setValue("bjobscm", null);
        model.setValue("primarycity", null);
        model.setValue("blaborreltype", null);
        model.setValue("blaborrelstatus", null);
        model.setValue("primarydepemp", null);
        model.setValue("pcmpemp", null);
        model.setValue("primarycmpemp", null);
        model.setValue("primaryemployee", null);
        model.setValue("person", null);
        model.setValue("primaryhrbu", null);
        model.setValue("primaryaftadminorg", null);
        model.setValue("primaryempgroup", null);
        model.setValue("psuperior", null);
        model.setValue("porgleader", null);
    }

    private void setBarCode() {
        String barCode = (String)this.getModel().getValue("barcode");
        if (HRStringUtils.isEmpty((String)barCode)) {
            String billNo = (String)this.getModel().getValue("billno");
            String prefix = billNo.substring(0, billNo.indexOf(45));
            barCode = NumberGenerater.getInstance().generaterNextNumber(new Date(), prefix);
            this.getModel().setValue("barcode", (Object)barCode);
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        Control source = (Control)evt.getSource();
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
        }
        String controlKey = source.getKey();
        Map<String, Object> erManFile = this.getErManFile();
        for (String businessKey : BUSINESS_CARD_ARR) {
            if (!controlKey.startsWith(businessKey)) continue;
            Map leaderMap = (Map)((List)erManFile.get(String.format(Locale.ROOT, "%sinfo", businessKey))).get(0);
            formshowParameter.setCustomParam("id", (Object)String.valueOf(leaderMap.get("id")));
            formshowParameter.setCustomParam("name", (Object)String.valueOf(leaderMap.get("name")));
            formshowParameter.setCustomParam("number", (Object)String.valueOf(leaderMap.get("number")));
            evt.setFormshowParameter(formshowParameter);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
    }
}

