/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.SihcConfigUtil;
import kd.hr.hdm.business.common.batch.EntryImportController;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportController;
import kd.hr.hdm.business.reg.domain.service.impl.proxy.BatchPartTimeImportExtendServiceImpl;
import kd.hr.hdm.formplugin.common.batch.CommonEntryImportEdit;
import kd.sdk.hr.hdm.business.parttime.IBatchPartTimeImportExtendService;

public class BatchPartTimeEntryImportEdit
extends CommonEntryImportEdit {
    @Override
    protected EntryImportController getEntryImportController() {
        return new PartTimeEntryImportController();
    }

    @Override
    protected void extendMethod(BeforeImportEntryEventArgs args) {
        PluginProxy pluginProxy = PluginProxy.create((Object)new BatchPartTimeImportExtendServiceImpl(), IBatchPartTimeImportExtendService.class, (String)"kd.sdk.hr.hdm.business.parttime.IBatchPartTimeImportExtendService", null);
        pluginProxy.callReplaceIfPresent(service -> {
            service.extendPartTimeEntryImport(args);
            return "";
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (("importentry".equals(operateKey) || "import_entrydata_hr".equals(operateKey)) && this.getModel().getValue("org") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\uff0c\u518d\u5bfc\u5165\u4eba\u5458\u3002", (String)"BatchPartTimeEntryImportEdit_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("importentry".equals(operateKey)) {
            this.getView().getPageCache().put("ImportEntryTypeVisible", "false");
        }
    }

    @Override
    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        super.beforeImportEntry(e);
        Map source = (Map)e.getSource();
        List entry = (List)source.get("entryentity");
        String enableSihc = SihcConfigUtil.enableSihc().toString();
        if (!Boolean.TRUE.toString().equals(enableSihc)) {
            return;
        }
        for (ImportEntryData importEntryData : entry) {
            JSONObject data = importEntryData.getData();
            String appDispatchNum = data.getString("appdispatchnum");
            if (HRStringUtils.isBlank((CharSequence)appDispatchNum)) continue;
            Long employeeId = data.getJSONObject("primaryemployee").getLong("id");
            DynamicObject appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId.longValue());
            if (HRObjectUtils.isEmpty((Object)appointRemoveRelObj)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("importprop", (Object)"id");
            jsonObject.put("id", (Object)appointRemoveRelObj.getLong("id"));
            data.put("appremoverel", (Object)jsonObject);
        }
    }
}

