/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBatchService;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.parttime.validate.BatchParttimeValidateHelper;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.parttime.web.batch.BatchParttimeListDataProvider;

public class BatchParttimeList
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(BatchParttimeList.class);
    private static final Set<String> SELECT_ONE_ONLY_OP = Sets.newHashSet((Object[])new String[]{"donothing_deletelist", "submiteffect", "donothing_unsubmitlist", "unsubmit"});

    public void setFilter(SetFilterEvent arg) {
        String orderBy = "modifytime desc";
        arg.setOrderBy(orderBy);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            operateOption.setVariableValue("currbizappid", this.getView().getFormShowParameter().getAppId());
            this.getView().invokeOperation(messageBoxClosedEvent.getCallBackId(), operateOption);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        if (SELECT_ONE_ONLY_OP.contains(operateKey) && rows.length > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"BatchParttimeList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject batchPartBill = new DynamicObject();
        if (rows.length > 0 && (batchPartBill = ParttimeBatchRepository.getInstance().queryOne("billstatus", (Object)((Long)rows[0]))) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BatchParttimeList_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "donothing_deletelist": {
                IParttimeBatchService.getInstance().beforeValidateDelete((AbstractFormPlugin)this, args, batchPartBill.getString("billstatus"));
                break;
            }
            case "submiteffect": {
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMITEFFECT);
                break;
            }
            case "submit": {
                if (rows.length > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"BatchParttimeList_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.beforeSaveAndSubmitValidate(args, TransferOperateTypeEnum.SUBMIT);
                break;
            }
            case "unsubmit": {
                IParttimeBillService.getInstance().beforeValidateUnSubmit((AbstractFormPlugin)this, args, batchPartBill.getString("billstatus"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        String caption = ResManager.loadKDString((String)"\u65b0\u589e\u6279\u91cf\u517c\u804c\u7533\u8bf7", (String)"BatchParttimeList_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
        switch (args.getOperateKey()) {
            case "donothing_add": {
                TransferPageUtil.showNewAddPage((IFormView)this.getView(), (String)"hdm_batchparttime", (String)caption);
                break;
            }
            case "donothing_unsubmitlist": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BatchParttimeList_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("callback_unsubmit", (IFormPlugin)this));
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        IListView listview = (IListView)this.getView();
        long transferBillId = (Long)listview.getFocusRowPkId();
        String billno = this.getBillNoByBillId(transferBillId);
        String caption = ResManager.loadKDString((String)"\u6279\u91cf\u517c\u804c\u7533\u8bf7-%s", (String)"BatchParttimeList_7", (String)"hr-hdm-formplugin", (Object[])new Object[]{billno});
        TransferPageUtil.showPage((IFormView)this.getView(), (String)"hdm_batchparttime", (Object)transferBillId, (String)caption, null);
    }

    private String getBillNoByBillId(long billId) {
        String billno = "";
        DynamicObject query = ParttimeBatchRepository.getInstance().queryOne("billno", (Object)billId);
        if (!ObjectUtils.isEmpty((Object)query) && !ObjectUtils.isEmpty((Object)query.getString("billno"))) {
            billno = query.getString("billno");
        }
        return billno;
    }

    private void beforeSaveAndSubmitValidate(BeforeDoOperationEventArgs args, TransferOperateTypeEnum operateTypeEnum) {
        String billstatus;
        Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject batchParttimeBill = ParttimeBatchRepository.getInstance().queryOne("billstatus,entryentity,org,affiliationord,effectdate", rows[0]);
        if (TransferOperateTypeEnum.SUBMIT == operateTypeEnum && !"A".equals(billstatus = batchParttimeBill.getString("billstatus")) && !"G".equals(billstatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"BatchParttimeList_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (TransferOperateTypeEnum.SUBMITEFFECT == operateTypeEnum && !"A".equals(billstatus = batchParttimeBill.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5e76\u751f\u6548\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"BatchParttimeList_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection batchParttimeBills = batchParttimeBill.getDynamicObjectCollection("entryentity");
        List parttimeBillIdList = batchParttimeBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> entryParttimeBillList = Arrays.asList(ParttimeApplyRepository.getInstance().queryByIds("primaryhrbu,adminorg,partperson,billno,aadminorg,apositiontype,astdposition,acompany,aposition,bjob,person,effectdate,affaction", parttimeBillIdList));
        List dataValidates = DataValidateBuilder.builderCollection(entryParttimeBillList);
        BatchParttimeValidateHelper.getInstance().saveValidate(batchParttimeBill, dataValidates);
        Map valResult = BatchParttimeValidateHelper.getInstance().buildOperateInfoByValResult(dataValidates, operateTypeEnum);
        if ((Integer)valResult.get("failperson") != 0) {
            TransferPageUtil.showFormViewOfModal((IFormView)this.getView(), (String)"hdm_parttimeoperateresult", (Map)valResult);
            args.setCancel(true);
            return;
        }
        BatchParttimeValidateHelper.validateAffiliationOrg((BeforeDoOperationEventArgs)args, (AbstractFormPlugin)this, (DynamicObject)batchParttimeBill, entryParttimeBillList);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BatchParttimeListDataProvider());
    }
}

