/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.parttime.web.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBatchService;
import kd.hr.hdm.common.parttime.util.ParttimePageHelperUtil;

public class BatchParttimeListDataProvider
extends ListDataProvider {
    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        this.addAndSetParttimeStatisticsProperty(rows);
        return rows;
    }

    private void addAndSetParttimeStatisticsProperty(DynamicObjectCollection rows) {
        DynamicSimpleProperty parttimeNumber = new DynamicSimpleProperty("parttimenumber", Integer.class, (Object)0);
        DynamicSimpleProperty parttimedNumber = new DynamicSimpleProperty("parttimednumber", Integer.class, (Object)0);
        rows.getDynamicObjectType().addProperty((DynamicProperty)parttimeNumber);
        rows.getDynamicObjectType().addProperty((DynamicProperty)parttimedNumber);
        List ids = rows.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        QFilter idsFilter = new QFilter("id", "in", ids);
        DynamicObject[] batchParttimeList = IParttimeBatchService.getInstance().query(ParttimePageHelperUtil.BATCHQUERYFIELD, idsFilter.toArray());
        HashMap<Long, DynamicObjectCollection> entryDyCollectionMap = new HashMap<Long, DynamicObjectCollection>(rows.size());
        for (DynamicObject item2 : batchParttimeList) {
            entryDyCollectionMap.put(item2.getLong("id"), item2.getDynamicObjectCollection("entryentity"));
        }
        for (DynamicObject row : rows) {
            DynamicObjectCollection entryDyCollection = (DynamicObjectCollection)entryDyCollectionMap.get(row.getLong("id"));
            Map<String, Object> statisticsMap = this.parttimeStatistics(entryDyCollection);
            row.set("parttimenumber", statisticsMap.get("parttimenumber"));
            row.set("parttimednumber", statisticsMap.get("parttimednumber"));
        }
    }

    private Map<String, Object> parttimeStatistics(DynamicObjectCollection entryDyCollection) {
        HashMap<String, Object> statisticsMap = new HashMap<String, Object>(2);
        int parttimeNumber = 0;
        int parttimeedNumber = 0;
        if (Objects.nonNull(entryDyCollection)) {
            for (DynamicObject item : entryDyCollection) {
                String parttimeStatus = item.getString("parttimestatus");
                if ("1".equals(parttimeStatus)) {
                    ++parttimeedNumber;
                }
                ++parttimeNumber;
            }
        }
        statisticsMap.put("parttimenumber", parttimeNumber);
        statisticsMap.put("parttimednumber", parttimeedNumber);
        return statisticsMap;
    }
}

