/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.common;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.utils.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class RegBillBasePlugin
extends AbstractBillPlugIn {
    private static final String POSTPONE_CHANGED_LAW_CALLBACK_ID = "POSTPONE_CHANGED_LAW_CALLBACK_ID";
    private static final String CATEGORY_CHANGED_LAW_CALLBACK_ID = "CATEGORY_CHANGED_LAW_CALLBACK_ID";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        switch (e.getProperty().getName()) {
            case "regcategory": {
                this.serviceForChangeRegCategory(changeData);
                break;
            }
            case "effectdate": {
                this.serviceForChangeEffectDate();
                break;
            }
            case "regcomment": {
                this.serviceForChangeRegComment(changeData);
                break;
            }
            case "postponeprobation": 
            case "postponeprobationunit": {
                this.serviceForChangePostponeProbation();
                break;
            }
        }
    }

    private void serviceForChangePostponeProbation() {
        DynamicObject regBill = this.getModel().getDataEntity();
        DynamicObject regCategory = regBill.getDynamicObject("regcategory");
        if (regCategory != null && RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            Map postponeInfoMap = IRegProbationService.getInstance().getPostponeInfoOfEdit(regBill);
            this.getModel().setValue("postponedate", postponeInfoMap.get("postponedate"));
            this.getModel().setValue("probationex", postponeInfoMap.get("probationex"));
            this.getModel().setValue("probationunitex", postponeInfoMap.get("probationunitex"));
            this.getModel().setValue("probationexview", postponeInfoMap.get("probationexview"));
        }
    }

    private void serviceForChangeRegCategory(ChangeData changeData) {
        DynamicObject regCategory = (DynamicObject)changeData.getNewValue();
        this.setDelayInfoControlByRegCategory(regCategory);
        if (ObjectUtils.isEmpty((Object)regCategory)) {
            return;
        }
        this.getModel().setValue("regcomment", (Object)regCategory.getLong("group_id"));
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            DynamicObject regBill = this.getModel().getDataEntity();
            String postponeProbationUnit = regBill.getString("probationunit");
            this.getModel().setValue("postponeprobationunit", (Object)postponeProbationUnit);
        } else {
            boolean isValid = this.judgeRegEarly();
            if (!isValid) {
                return;
            }
            this.validateEffectDateBeforePreDate();
        }
    }

    private void valueChangedTouchOffRuleEngine(DynamicObject regBill, String fieldSource) {
        long regCategoryId = regBill.getLong("regcategory.id");
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategoryId)) {
            Map validateMap = IRegProbationService.getInstance().batchValidateProbationPostponeByRuleEngine(Collections.singletonList(regBill), "value_changed_event", true);
            DataValidate dataValidate = (DataValidate)validateMap.get(regBill.getLong("id"));
            ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
            if (ValidateRangeEnum.VALIDATE_PASS == range) {
                return;
            }
            if (ValidateRangeEnum.VALIDATE_ERROR == range) {
                String callBackId = "";
                if ("postponeprobation".equals(fieldSource)) {
                    callBackId = POSTPONE_CHANGED_LAW_CALLBACK_ID;
                }
                if ("regcategory".equals(fieldSource)) {
                    callBackId = CATEGORY_CHANGED_LAW_CALLBACK_ID;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
                Map validateResult = dataValidate.getValidatorContext().getValidateResult();
                this.getView().showConfirm((String)validateResult.get("title"), (String)validateResult.get("content"), MessageBoxOptions.OK, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)POSTPONE_CHANGED_LAW_CALLBACK_ID, (String)callBackId)) {
            this.clearPostponeInfo();
        }
        if (HRStringUtils.equals((String)CATEGORY_CHANGED_LAW_CALLBACK_ID, (String)callBackId)) {
            this.getModel().setValue("regcategory", null);
        }
    }

    private void setDelayInfoControlByRegCategory(DynamicObject regCategory) {
        DecimalEdit postponeProbation = (DecimalEdit)this.getView().getControl("postponeprobation");
        ComboEdit postponeProbationUnit = (ComboEdit)this.getView().getControl("postponeprobationunit");
        if (regCategory == null || !RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            postponeProbation.setMustInput(false);
            postponeProbationUnit.setMustInput(false);
            this.clearPostponeInfo();
        } else {
            postponeProbation.setMustInput(true);
            postponeProbationUnit.setMustInput(true);
        }
    }

    private void clearPostponeInfo() {
        this.getModel().setValue("postponeprobation", null);
        this.getModel().setValue("postponedate", null);
        this.getModel().setValue("probationexview", null);
        this.getModel().setValue("probationex", null);
        this.getModel().setValue("probationunitex", null);
    }

    private boolean judgeRegEarly() {
        Date effectDate = (Date)this.getModel().getValue("effectdate");
        Date preEffectDate = (Date)this.getModel().getValue("preactualdate");
        if (ObjectUtils.isEmpty((Object)effectDate) || ObjectUtils.isEmpty((Object)preEffectDate)) {
            return true;
        }
        long regCategoryId = this.getModel().getDataEntity().getLong("regcategory.id");
        if (RegCategoryEnum.INADVANCE.getId().equals(regCategoryId) && (effectDate.after(preEffectDate) || DateUtils.isSameDay((Date)effectDate, (Date)preEffectDate))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5982\u679c\u5458\u5de5\u63d0\u524d\u8f6c\u6b63\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBaseBillPlugin_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateEffectDateBeforePreDate() {
        DynamicObject regCategory;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("hdm_regbasebill".equals(formId)) {
            return;
        }
        DynamicObject regBill = this.getModel().getDataEntity();
        Date effectDate = regBill.getDate("effectdate");
        Date preDate = regBill.getDate("preactualdate");
        if (effectDate != null && preDate.after(effectDate) && (regCategory = this.getModel().getDataEntity().getDynamicObject("regcategory")) != null && !RegCategoryEnum.INADVANCE.getId().equals(regCategory.getLong("id"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\uff1a\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u4f46\u8f6c\u6b63\u5206\u7c7b\u4e0d\u662f\u201c\u63d0\u524d\u8f6c\u6b63\u201d\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"RegBaseBillPlugin_18", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void serviceForChangeEffectDate() {
        boolean isValid;
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        DynamicObject regCommentObj = dataEntity.getDynamicObject("regcomment");
        Date entryDate = dataEntity.getDate("entrydate");
        Date effectDate = dataEntity.getDate("effectdate");
        if (entryDate != null && effectDate != null && effectDate.before(entryDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBaseBillPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            return;
        }
        Date preActualDate = (Date)this.getView().getModel().getValue("preactualdate");
        if (null != regCommentObj && 1010L == regCommentObj.getLong("id") && null != effectDate && null != preActualDate) {
            if (DateUtils.isSameDay((Date)effectDate, (Date)preActualDate)) {
                this.getModel().setValue("regcategory", (Object)1010L);
            } else if (effectDate.before(preActualDate)) {
                this.getModel().setValue("regcategory", (Object)1020L);
            }
        }
        if (!(isValid = this.judgeRegEarly())) {
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        if (null != effectDate && null != preActualDate && !"hdm_regbasebill".equals(formId) && effectDate.after(preActualDate) && !DateUtils.isSameDay((Date)effectDate, (Date)preActualDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u665a\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u53ef\u80fd\u4f1a\u6709\u7528\u5de5\u98ce\u9669\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"RegBaseBillPlugin_17", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void serviceForChangeRegComment(ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        this.getModel().setValue("effectdate", null);
        this.getModel().setValue("laborrelstatus", null);
        this.setRegCategoryValueByRegCommentChange(newValue);
        this.executeRegComment(newValue);
        this.getView().setEnable(Boolean.TRUE, new String[]{"regcategory", "effectdate"});
    }

    private void setRegCategoryValueByRegCommentChange(DynamicObject regComment) {
        DynamicObject regCategory = this.getModel().getDataEntity().getDynamicObject("regcategory");
        if (regCategory == null) {
            return;
        }
        long regCommentId = regCategory.getLong("group_id");
        if (regComment != null && regComment.getLong("id") != regCommentId) {
            this.getModel().setValue("regcategory", null);
        }
    }

    protected void executeRegComment(DynamicObject regComment) {
        DateEdit effectDate = (DateEdit)this.getView().getControl("effectdate");
        if (ObjectUtils.isEmpty((Object)regComment)) {
            effectDate.setMustInput(false);
        } else if (1010L == regComment.getLong("id")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"effectdate"});
            this.clearPostponeInfo();
            effectDate.setMustInput(true);
        } else {
            effectDate.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate"});
        }
    }
}

