/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.common;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.MobileListView;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import org.apache.commons.lang.StringUtils;

public class RegKeyEventBasePlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(RegKeyEventBasePlugin.class);
    private static final String FILED_OCCURDATE = "occurdate";

    public void afterCreateNewData(EventObject e) {
        String billFormId;
        Long employeeId = (Long)this.getView().getFormShowParameter().getCustomParam("employee");
        Long personId = (Long)this.getView().getFormShowParameter().getCustomParam("person");
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof MobileListView && "hdm_regevent".equals(billFormId = ((MobileListView)this.getView().getParentView()).getBillFormId())) {
            employeeId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("employee");
            personId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("person");
        }
        IDataModel dataModel = this.getModel();
        dataModel.setValue("person", (Object)personId);
        dataModel.setValue("bemployee", (Object)employeeId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)"save", (String)operate.getOperateKey())) {
            Long employeeId = (Long)this.getModel().getValue("bemployee_id");
            Map validate = RegCommonValidatorHelper.getInstance().validateKeyEvent(employeeId);
            boolean flag = Boolean.parseBoolean((String)validate.get("validateResult"));
            if (!flag) {
                String msg = (String)validate.get("msg");
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            boolean pass = this.validateOccurDate(this.getModel().getDataEntity().getDate(FILED_OCCURDATE));
            if (!pass) {
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((String)"save", (String)operate.getOperateKey()) && OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            this.getModel().setValue("bizoperator", (Object)RequestContext.get().getCurrUserId());
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                String formId = parentView.getFormShowParameter().getFormId();
                if ("hdm_personregview".equals(formId)) {
                    this.getModel().setValue("importsource", (Object)"1");
                } else {
                    this.getModel().setValue("importsource", (Object)"2");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        IFormView parentView;
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (null != operationResult && operationResult.isSuccess() && "save".equals(e.getOperateKey()) && (parentView = this.getView().getParentView()) instanceof IListView) {
            parentView.updateView();
            this.getView().sendFormAction(parentView);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        if (FILED_OCCURDATE.equals(name)) {
            Date occurDate = (Date)changeData.getNewValue();
            this.validateOccurDate(occurDate);
        }
    }

    private boolean validateOccurDate(Date occurDate) {
        Date entryDate = this.getEntryDate();
        if (occurDate != null && entryDate != null && HRDateTimeUtils.dayBefore((Date)occurDate, (Date)entryDate)) {
            String errorMsg = ResManager.loadKDString((String)"\u4e8b\u4ef6\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegKeyEventPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    private Date getEntryDate() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        Date entryDate = (Date)pageCache.get("entrydate", Date.class);
        if (entryDate == null) {
            String entryDateStr = (String)this.getView().getFormShowParameter().getCustomParam("entrydate");
            if (HRStringUtils.isNotEmpty((String)entryDateStr)) {
                try {
                    entryDate = HRDateTimeUtils.parseDate((String)entryDateStr);
                }
                catch (ParseException e) {
                    LOGGER.error("entryDate parse exception", (Throwable)e);
                    return null;
                }
            } else {
                Long employeeId = (Long)this.getModel().getValue("bemployee_id");
                List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_empentrel"});
                if (HRCollUtil.isEmpty((Collection)empentrelList)) {
                    return null;
                }
                Map empentrel = (Map)empentrelList.get(0);
                entryDate = (Date)empentrel.get("startdate");
            }
            pageCache.put("entrydate", (Object)entryDate);
        }
        return entryDate;
    }
}

