/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Timeline;
import kd.bos.form.control.TimelineContentOption;
import kd.bos.form.control.TimelineLabelOption;
import kd.bos.form.control.TimelineOption;
import kd.bos.form.control.TimelineText;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.repository.RegKeyEventRepository;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import kd.hr.hdm.formplugin.reg.web.applybill.RegularBaseUtils;
import kd.hr.hdm.formplugin.reg.web.tools.RegBillDrawLabelUtil;

public class RegAuditMobPlugin
extends AbstractMobBillPlugIn {
    private static final Log LOGGER = LogFactory.getLog(RegAuditMobPlugin.class);
    public static final String HDM_ASKDETAILS_LAYOUT_M = "hdm_askdetails_layout_m";
    public static final String BEMPLOYEE = "bemployee";
    public static final String HDM_EXAMRESULT_LAYOUT_M = "hdm_examresult_layout_m";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector tutorDown = (Vector)this.getControl("tutordown");
        Vector tutorUp = (Vector)this.getControl("tutorup");
        Vector keyEventDown = (Vector)this.getControl("keyeventdown");
        Vector keyEventUp = (Vector)this.getControl("keyeventup");
        tutorDown.addClickListener((ClickListener)this);
        tutorUp.addClickListener((ClickListener)this);
        keyEventDown.addClickListener((ClickListener)this);
        keyEventUp.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "tutordown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"emptutorinfo", "tutorup"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tutordown"});
                break;
            }
            case "tutorup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"emptutorinfo", "tutorup"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"tutordown"});
                break;
            }
            case "keyeventdown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"keyeventspanel", "keyeventup"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"keyeventdown"});
                break;
            }
            case "keyeventup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"keyeventspanel", "keyeventup"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"keyeventdown"});
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setBillHead();
        this.setTutor();
        this.setKeyEvent();
        this.setDefaultControl();
    }

    public void afterBindData(EventObject e) {
        this.setProbationExt();
        this.setAuditStatusLabelWithColorful();
        this.setPostponeInfo();
        this.showAskPage();
        this.showExamPage();
    }

    private void showExamPage() {
        DynamicObject employeeOjb;
        Long employeeId;
        DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
        Long personId = null == personOjb ? null : Long.valueOf(personOjb.getLong("id"));
        IFormView view = RegularBaseUtils.showPageNoAuth((AbstractFormPlugin)this, "panelexam", HDM_EXAMRESULT_LAYOUT_M, personId, employeeId = null == (employeeOjb = (DynamicObject)this.getView().getModel().getValue(BEMPLOYEE)) ? null : Long.valueOf(employeeOjb.getLong("id")));
        if (view != null) {
            this.getView().sendFormAction(view);
        }
    }

    private void showAskPage() {
        DynamicObject employeeOjb;
        Long employeeId;
        DynamicObject personOjb = (DynamicObject)this.getView().getModel().getValue("person");
        Long personId = null == personOjb ? null : Long.valueOf(personOjb.getLong("id"));
        IFormView view = RegularBaseUtils.showPageNoAuth((AbstractFormPlugin)this, "panelask", HDM_ASKDETAILS_LAYOUT_M, personId, employeeId = null == (employeeOjb = (DynamicObject)this.getView().getModel().getValue(BEMPLOYEE)) ? null : Long.valueOf(employeeOjb.getLong("id")));
        if (view != null) {
            this.getView().sendFormAction(view);
        }
    }

    private void setAuditStatusLabelWithColorful() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus == null) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name())) {
            LabelAp statusLabel = RegBillDrawLabelUtil.setAuditStatusLabelWithColorful("status", billStatus);
            this.getView().updateControlMetadata(statusLabel.getKey(), statusLabel.createControl());
        }
    }

    private void setPostponeInfo() {
        IDataModel model = this.getModel();
        long regCategoryId = model.getDataEntity().getLong("regcategory.id");
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategoryId)) {
            Map postponeInfoMap = IRegProbationService.getInstance().getPostponeInfoOfView(model.getDataEntity());
            model.setValue("postponeprobationview", postponeInfoMap.get("postponeprobationview"));
            model.setValue("probationexview", postponeInfoMap.get("probationexview"));
        }
    }

    private void setProbationExt() {
        Object probation = this.getModel().getValue("probation");
        String periodUnit = (String)this.getModel().getValue("probationunit");
        String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
        this.getModel().setValue("probationtext", (Object)(probation + periodUnitName));
    }

    private void setKeyEventDefaultImage() {
        Image image = (Image)this.getView().getControl("defaultimage");
        if (image == null) {
            return;
        }
        image.setUrl("/images/mobile/emotion/hr_wsjcard_112_64.png");
        Label defaultData = (Label)this.getControl("nodata");
        defaultData.setText(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"RegAuditMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
    }

    private void setKeyEvent() {
        long employeeId = this.getModel().getDataEntity().getLong("ermanfile.employee.id");
        QFilter filter = new QFilter("bemployee_id", "=", (Object)employeeId);
        DynamicObject[] keyEventObjects = RegKeyEventRepository.getInstance().query("name,occurdate,details", new QFilter[]{filter}, "occurdate desc");
        if (keyEventObjects == null || keyEventObjects.length < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"keyeventline"});
            this.setKeyEventDefaultImage();
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"defaultpanel"});
        Timeline timeline = (Timeline)this.getView().getControl("keyeventline");
        ArrayList<TimelineOption> timelineOptionList = new ArrayList<TimelineOption>(keyEventObjects.length);
        for (DynamicObject dynamicObject : keyEventObjects) {
            TimelineOption timelineOption = new TimelineOption();
            TimelineLabelOption label = new TimelineLabelOption();
            label.setTitle(new LocaleString(HRDateTimeUtils.format((Date)dynamicObject.getDate("occurdate"), (String)"yyyy-MM-dd")));
            timelineOption.setLabel(label);
            TimelineContentOption content = new TimelineContentOption();
            content.setTitle(new LocaleString(dynamicObject.getString("name")));
            TimelineText timelineText = new TimelineText();
            timelineText.setText(new LocaleString(dynamicObject.getString("details")));
            content.setDescriptions(Collections.singletonList(timelineText));
            timelineOption.setContent(content);
            timelineOptionList.add(timelineOption);
        }
        timeline.setClientTimelineOptions(timelineOptionList);
    }

    private void setBillHead() {
        Label statusLab = (Label)this.getControl("status");
        String auditStatus = (String)this.getModel().getValue("billstatus");
        statusLab.setText(RegBillStatusEnum.getName((String)auditStatus));
        Label title = (Label)this.getControl("title");
        DynamicObject person = (DynamicObject)this.getModel().getValue("person");
        title.setText(ResManager.loadKDString((String)"%s\u7684\u8f6c\u6b63\u7533\u8bf7\u5355", (String)"RegAuditMobPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[]{person.getString("name")}));
    }

    private void setDefaultControl() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"emptutorinfo", "tutorup", "keyeventspanel", "keyeventup"});
        Label regBillNo = (Label)this.getControl("regbillno");
        regBillNo.setText(this.getModel().getDataEntity().getString("billno"));
    }

    private void setTutor() {
        long employeeId = this.getModel().getDataEntity().getLong("bemployee.id");
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_emptutor"});
        if (tutorList == null || tutorList.size() < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tutorpanelap"});
            return;
        }
        Long tutorId = (Long)((Map)tutorList.get(0)).get("tutor_id");
        DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{tutorId});
        if (ermanfile == null) {
            throw new KDBizException(" query tutor exception,please contract manager");
        }
        DynamicObject person = (DynamicObject)ermanfile.get("person");
        Image image = (Image)this.getView().getControl("vatar");
        String headSculpture = HRImageUrlUtil.getImageFullUrl((String)person.getString("headsculpture"));
        image.setUrl(headSculpture);
        Label tutorName = (Label)this.getControl("tutorname");
        tutorName.setText(person.getString("name"));
        Label tutorNumber = (Label)this.getControl("tutornumber");
        tutorNumber.setText(person.getString("number"));
        DynamicObject empposorgrel = (DynamicObject)ermanfile.get("empposrel");
        Label tutorCompany = (Label)this.getControl("tutorcompany");
        tutorCompany.setText(empposorgrel.getString("company.name"));
        Label tutorAdminOrg = (Label)this.getControl("tutoradminorg");
        tutorAdminOrg.setText(empposorgrel.getString("adminorg.name"));
        Label tutorPosition = (Label)this.getControl("tutorposition");
        String position = empposorgrel.getString("position.name");
        String stdPosition = empposorgrel.getString("stdposition.name");
        tutorPosition.setText(position == null ? stdPosition : position);
        Label split = (Label)this.getControl("tutorsplit");
        split.setText("\u00b7");
    }
}

