/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.mobile;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.reg.RegDetailInfoHelper;
import kd.hr.hdm.business.repository.RegKeyEventRepository;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.enums.RegTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferPageUtil;
import kd.hr.hdm.formplugin.reg.common.ProbationKeyEventService;
import org.apache.commons.lang.StringUtils;

public class RegSelfHelpMobPlugin
extends AbstractMobBillPlugIn {
    private static final String IMAGE_KEY = "agreeregimage";
    private static final String HSSC_APP_ID = "hssc";
    private static final String CHECK_RIGHT_APP_ID = "checkRightAppId";
    public static final String TUTORDOWN = "tutordown";
    public static final String TUTORUP = "tutorup";
    public static final String EMPTUTORINFO = "emptutorinfo";
    public static final String KEYEVENT_COUNT_PANEL = "keyeventcountpanel";
    public static final String KEYEVENT_PANEL = "keyeventpanel";
    public static final String KEYEVENT_ADD_PANEL = "addpanel";
    public static final String KEYEVENT_ADD_FLEX = "keyeventaddflex";
    public static final String KEYEVENT_COUNT = "keyeventcount";
    public static final String VIEW_KEYEVENTLIST = "viewkeyeventlistpanel";
    private static final String REG_EVENT_ADD_CLOSE_BACK_ID = "reg_event_add_close_back_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Vector tutorDown = (Vector)this.getControl(TUTORDOWN);
        Vector tutorUp = (Vector)this.getControl(TUTORUP);
        Container keyEventAdd = (Container)this.getControl(KEYEVENT_ADD_FLEX);
        tutorDown.addClickListener((ClickListener)this);
        tutorUp.addClickListener((ClickListener)this);
        keyEventAdd.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "tutordown": {
                this.getView().setVisible(Boolean.TRUE, new String[]{EMPTUTORINFO, TUTORUP});
                this.getView().setVisible(Boolean.FALSE, new String[]{TUTORDOWN});
                break;
            }
            case "tutorup": {
                this.getView().setVisible(Boolean.FALSE, new String[]{EMPTUTORINFO, TUTORUP});
                this.getView().setVisible(Boolean.TRUE, new String[]{TUTORDOWN});
                break;
            }
            case "keyeventaddflex": {
                this.viewKeyEvent();
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        MobileBillShowParameter parameter = (MobileBillShowParameter)e.getSource();
        parameter.setCustomParam(CHECK_RIGHT_APP_ID, (Object)HSSC_APP_ID);
        parameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7", (String)"RegSelfHelpMobPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject entity = (DynamicObject)e.getDataEntity();
        entity.set("regbilltype", (Object)RegBillTypeEnum.EMP.getStatus());
        entity.set("isdirectregular", (Object)Boolean.FALSE);
        entity.set("regcomment_id", (Object)RegCommentEnum.AGREE.getId());
        entity.set("regcategory_id", (Object)RegCategoryEnum.NOMAL.getId());
        String entityId = "hdm_regbasebill";
        String newNum = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)entity, null);
        entity.set("billno", (Object)newNum);
        entity.set("syncstatus", (Object)"-2");
    }

    public void afterCreateNewData(EventObject e) {
        String worksum = (String)this.getModel().getValue("worksum");
        if (StringUtils.isBlank((String)worksum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"worksum_edit"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (StringUtils.equals((String)operate.getOperateKey(), (String)"selfsubmit") || StringUtils.equals((String)operate.getOperateKey(), (String)"save_mobile")) {
            this.setRegInfoOfWaitRepeatSubmit();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    private void setRegInfoOfWaitRepeatSubmit() {
        DynamicObject regBillDynamicObject = this.getModel().getDataEntity();
        String billStatus = regBillDynamicObject.getString("billstatus");
        if (RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
            regBillDynamicObject.set("regcomment_id", (Object)RegCommentEnum.AGREE.getId());
            regBillDynamicObject.set("effectdate", (Object)regBillDynamicObject.getDate("preactualdate"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result != null && result.isSuccess()) {
            switch (afterDoOperationEventArgs.getOperateKey()) {
                case "save_mobile": {
                    this.setProbationKeyEventLabelBySaveOp();
                    BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                    formShowParameter.setStatus(OperationStatus.VIEW);
                    this.getView().updateView();
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "modify": {
                    this.setProbationKeyEventLabel();
                    break;
                }
                case "editworksum": {
                    this.showWorkSum(OperationStatus.EDIT);
                    break;
                }
                case "viewworksum": {
                    this.showWorkSum(OperationStatus.VIEW);
                    AttachmentPanel attachment = (AttachmentPanel)this.getView().getControl("attachment");
                    AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                    attachmentPanel.bindData(attachment.getAttachmentData());
                    break;
                }
            }
        }
    }

    private void showWorkSum(OperationStatus status) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("hdm_regworksum_edit");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("message", this.getModel().getValue("worksum"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hdm_regworksum_edit"));
        parameter.setStatus(status);
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((String)actionId, (String)"hdm_regworksum_edit")) {
            String workSum = (String)closedCallBackEvent.getReturnData();
            this.getModel().setValue("worksum", (Object)workSum);
            this.getView().setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)workSum)), new String[]{"worksum_edit"});
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)REG_EVENT_ADD_CLOSE_BACK_ID)) {
            this.setProbationKeyEventLabel();
        }
    }

    public void afterBindData(EventObject e) {
        this.setDefaultControl();
        this.setImageRemark();
        this.setTutor();
        this.setProbationKeyEventLabel();
    }

    private void setTutor() {
        long employeeId = this.getModel().getDataEntity().getLong("ermanfile.employee.id");
        List tutorList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_emptutor"});
        if (tutorList == null || tutorList.size() < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tutorpanelap"});
            return;
        }
        Long tutorId = (Long)((Map)tutorList.get(0)).get("tutor_id");
        DynamicObject ermanfile = (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{tutorId});
        if (ermanfile == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tutorpanelap"});
            return;
        }
        DynamicObject person = (DynamicObject)ermanfile.get("person");
        Image image = (Image)this.getView().getControl("vatar");
        String headSculpture = HRImageUrlUtil.getImageFullUrl((String)person.getString("headsculpture"));
        image.setUrl(headSculpture);
        Label tutorName = (Label)this.getControl("tutorname");
        tutorName.setText(person.getString("name"));
        Label tutorNumber = (Label)this.getControl("tutornumber");
        tutorNumber.setText(person.getString("number"));
        DynamicObject empposorgrel = (DynamicObject)ermanfile.get("empposrel");
        Label tutorCompany = (Label)this.getControl("tutorcompany");
        tutorCompany.setText(empposorgrel.getString("company.name"));
        Label tutorAdminOrg = (Label)this.getControl("tutoradminorg");
        tutorAdminOrg.setText(empposorgrel.getString("adminorg.name"));
        Label tutorPosition = (Label)this.getControl("tutorposition");
        String position = empposorgrel.getString("position.name");
        String stdPosition = empposorgrel.getString("stdposition.name");
        tutorPosition.setText(position == null ? stdPosition : position);
        Label split = (Label)this.getControl("tutorsplit");
        split.setText("\u00b7");
    }

    private void setImageRemark() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String trialPeriodResultImageUrl = RegDetailInfoHelper.getInstance().getTrialPeriodResultImageMob(dataEntity.getString("regstatus"));
        if (HRStringUtils.isEmpty((String)trialPeriodResultImageUrl)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_KEY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_KEY});
            Image image = (Image)this.getView().getControl(IMAGE_KEY);
            image.setUrl(trialPeriodResultImageUrl);
        }
    }

    private void setRegBillTypeLabel() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (RegTypeEnum.APPLY_HR.getCode().equals(dataEntity.getString("regbilltype"))) {
            ((Label)this.getView().getControl("regtype")).setText(RegTypeEnum.getName((String)dataEntity.getString("regbilltype")));
            this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanelflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"regtype"});
        }
        Label regBillNo = (Label)this.getControl("regbillno");
        regBillNo.setText(this.getModel().getDataEntity().getString("billno"));
    }

    private void setDefaultControl() {
        this.setRegBillTypeLabel();
        DynamicObject regBill = this.getModel().getDataEntity();
        String regBillType = regBill.getString("regbilltype");
        if (RegTypeEnum.APPLY_HR.getCode().equals(regBillType) && StringUtils.isEmpty((String)regBill.getString("worksum"))) {
            this.getModel().setValue("worksum", (Object)"-");
            this.getView().setVisible(Boolean.FALSE, new String[]{"worksumvector"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{EMPTUTORINFO, TUTORUP});
        this.getView().setVisible(Boolean.TRUE, new String[]{TUTORDOWN});
    }

    private void setProbationKeyEventLabel() {
        boolean isPermission = PermissionValidateUtil.checkPermission((String)HSSC_APP_ID, (String)"hdm_regevent", (String)"47150e89000000ac");
        if (!isPermission) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_PANEL, VIEW_KEYEVENTLIST});
            return;
        }
        MobileBillShowParameter billShowParameter = (MobileBillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus status = billShowParameter.getBillStatus();
        if (BillOperationStatus.VIEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_PANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_KEYEVENTLIST});
            this.viewKeyEventList();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_KEYEVENTLIST});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEYEVENT_PANEL});
            DynamicObject[] dys = this.getProbationKeyEvent();
            if (dys != null && dys.length > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEYEVENT_COUNT_PANEL, KEYEVENT_ADD_FLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_ADD_PANEL});
                Label label = (Label)this.getControl(KEYEVENT_COUNT);
                label.setText(String.valueOf(dys.length));
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEYEVENT_ADD_PANEL, KEYEVENT_ADD_FLEX});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_COUNT_PANEL});
            }
        }
    }

    private void setProbationKeyEventLabelBySaveOp() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_ADD_PANEL});
        DynamicObject[] dys = this.getProbationKeyEvent();
        if (dys == null || dys.length < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEYEVENT_ADD_FLEX});
        }
    }

    private void viewKeyEvent() {
        DynamicObject[] dys = this.getProbationKeyEvent();
        if (dys == null || dys.length < 1) {
            Map<String, Object> paramMap = ProbationKeyEventService.getInstance().buildParamMap(this.getView(), this.getModel().getDataEntity());
            ProbationKeyEventService.getInstance().openKeyEventByMob((AbstractFormPlugin)this, this.getView(), paramMap, REG_EVENT_ADD_CLOSE_BACK_ID);
        } else {
            this.keyEventList();
        }
    }

    private void keyEventList() {
        ProbationKeyEventService.getInstance().showFormKeyEventListByMob(this.getView(), this.getModel().getDataEntity());
    }

    private DynamicObject[] getProbationKeyEvent() {
        long employeeId = this.getModel().getDataEntity().getLong("ermanfile.employee.id");
        QFilter qFilter = new QFilter("bemployee", "=", (Object)employeeId);
        qFilter.and(new QFilter("importsource", "=", (Object)"2"));
        return RegKeyEventRepository.getInstance().query("id", new QFilter[]{qFilter}, null);
    }

    private void viewKeyEventList() {
        TransferPageUtil.showPageInContainer((IFormView)this.getView(), (String)"hdm_regevent_selflist_m", (String)VIEW_KEYEVENTLIST, null);
    }
}

