/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.validator.ProbationKeyEventImportValidateHelper;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;

public class ProbationKeyEventImportPlugin
extends HRDataBaseList
implements HRImportPlugin {
    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        args.setFormId("hdm_regevent");
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new ProbationKeyEventImportValidateHelper());
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Object[] dynamicObjects = args.getDynamicObjects();
        this.setEmployee((DynamicObject[])dynamicObjects);
    }

    public void afterInitContext(AfterInitContextArgs args) {
        args.setDisableRepeatDataValidator(Boolean.valueOf(true));
    }

    private void setEmployee(DynamicObject[] dynamicObjects) {
        Set personIdSet = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("person.id")).collect(Collectors.toSet());
        Map trailPeriodMap = IRegProbationService.getInstance().getTrailPeriodByPersonId(personIdSet);
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            long personId = dynamicObject.getLong("person.id");
            DynamicObject trailPeriod = (DynamicObject)trailPeriodMap.get(personId);
            dynamicObject.set("bemployee", (Object)trailPeriod.getDynamicObject("employee"));
            dynamicObject.set("bizoperator_id", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("importsource", (Object)"1");
        });
    }

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        if ("person".equals(args.getFieldId()) && "hrpi_person".equals(args.getBaseDataName())) {
            QFilter[] filters = args.getFilters();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters.length);
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
            if (!args.isImportInvoke()) {
                filterList.add(new QFilter("1", "=", (Object)2));
                args.setFilters(filterList.toArray(new QFilter[0]));
                return;
            }
            List empNumberList = args.getBillDataList().stream().map(importBillData -> importBillData.getData().getJSONObject("hdm_regevent").getJSONObject("person").getString("number")).distinct().collect(Collectors.toList());
            DynamicObject[] dynamicObjects = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(empNumberList);
            Set personId = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("person.id")).collect(Collectors.toSet());
            filterList.add(new QFilter("id", "in", personId));
            args.setFilters(filterList.toArray(new QFilter[0]));
        }
    }
}

