/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.applybill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.formplugin.reg.web.applybill.RegPageUtils;

public class TerminateWorkFlowListPlugin
extends HRCoreBaseBillList {
    private static final Log LOGGER = LogFactory.getLog(TerminateWorkFlowListPlugin.class);
    private static final String DONOTHING_TERMINATE = "donothing_terminate";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_terminate": {
                if (this.getSelectedRows().size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u7ec8\u6b62\u6d41\u7a0b\u7684\u5355\u636e\u3002", (String)"RegularApplySourceList_12", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                OperateOption option = operate.getOption();
                if (option.containsVariable("confirmCallback") && "1".equals(option.getVariableValue("confirmCallback"))) {
                    if (option.containsVariable("successPkIds")) {
                        List successPkIds = (List)SerializationUtils.fromJsonString((String)option.getVariableValue("successPkIds"), List.class);
                        RegPageUtils.showTerminateConfirm((AbstractFormPlugin)this, DONOTHING_TERMINATE, successPkIds);
                    }
                    args.setCancel(true);
                    return;
                }
                DynamicObject[] regBills = this.getBills();
                Map failMap = IRegBillService.getInstance().terminateBatchValidate(regBills);
                int sum = failMap.entrySet().stream().map(entry -> (List)entry.getValue()).mapToInt(list -> list.size()).sum();
                if (failMap.size() == 1 && sum == regBills.length) {
                    RegPageUtils.showTerminateMsg(this.getView(), regBills[0].getString("regstatus"));
                    args.setCancel(true);
                    break;
                }
                if (failMap.isEmpty()) {
                    List successPkIds = Arrays.stream(regBills).map(dy -> (Long)dy.getPkValue()).collect(Collectors.toList());
                    RegPageUtils.showTerminateConfirm((AbstractFormPlugin)this, DONOTHING_TERMINATE, successPkIds);
                    args.setCancel(true);
                    break;
                }
                operate.getOption().setVariableValue("fails", SerializationUtils.toJsonString((Object)failMap));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)DONOTHING_TERMINATE)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (HRObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            Map returnMap = (Map)returnData;
            if ("btnok".equals(returnMap.get("source"))) {
                this.getView().invokeOperation("refresh");
                if ("success".equals(returnMap.get("result"))) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u8f6c\u6b63\u6d41\u7a0b\u6210\u529f\u3002", (String)"RegularApplySourceList_13", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u8f6c\u6b63\u6d41\u7a0b\u5931\u8d25\u3002", (String)"RegTermPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private DynamicObject[] getBills() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        String selectProperties = "billstatus,person,org,billno,ermanfile,probation,affaction,probationunit,probationex,probationunitex,auditstatus,regbilltype,billstatus,regstatus,entrydate,effectdate,ismobile,bemployee,regcategory,termreason,termdate,termuser,modifytime,preactualdate,postponeprobation,regcomment";
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
    }
}

