/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.ask;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.validator.RegCommonValidatorHelper;
import kd.hr.hdm.formplugin.reg.web.RegAskAndExamSingleCommon;
import org.apache.commons.lang3.StringUtils;

public class RegAskPersonPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    private static final Log logger = LogFactory.getLog(RegAskPersonPlugin.class);
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};
    private RegAskAndExamSingleCommon singleCommon = new RegAskAndExamSingleCommon();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"return"});
        Arrays.stream(BUSINESS_CARD_ARR).forEach(item -> this.addTipsListener((String)item));
    }

    public void onGetControl(OnGetControlArgs e) {
        this.singleCommon.onGetControl(e, this.getView(), (IFormPlugin)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.singleCommon.loadCustomControlMetas(e, true, false);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("RegAskPersonPlugin", exp.getMessage()), new Object[0]);
        }
        this.singleCommon.registDynamicProps(newMainType, this.getView());
        e.setNewEntityType(newMainType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        this.singleCommon.afterBindData(view, false);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        this.singleCommon.customEvent(this.getView(), e.getKey(), true);
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "headimage": {
                this.singleCommon.clickAdd(this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operateKey)) {
            String pageId = this.getView().getPageId();
            Map<String, Object> returnResult = this.singleCommon.clickReturn(this.getView(), pageId);
            HashSet askPersons = (HashSet)returnResult.get("askperson");
            Map roleMap = (Map)returnResult.get("rolemap");
            this.beforeAddAskPerson(askPersons, roleMap, args);
            if (!args.cancel) {
                OperateOption option = operate.getOption();
                option.setVariableValue("askperson", JSONObject.toJSONString((Object)askPersons));
                option.setVariableValue("rolemap", JSONObject.toJSONString((Object)roleMap));
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Long personId = (Long)formShowParameter.getCustomParam("person");
                Long employeeId = (Long)formShowParameter.getCustomParam("employee");
                Long erManFileId = (Long)formShowParameter.getCustomParam("ermanfile");
                option.setVariableValue("person", String.valueOf(personId));
                option.setVariableValue("employee", String.valueOf(employeeId));
                option.setVariableValue("ermanfile", String.valueOf(erManFileId));
                ArrayList messageIds = new ArrayList(askPersons.size());
                HashMap detailMap = new HashMap(2 * askPersons.size());
                String userId = this.getPageCache().get("cache_self");
                for (Long askPerson : askPersons) {
                    String messageTemplateNumber = HRStringUtils.equals((String)String.valueOf(askPerson), (String)userId) ? "hdm_regask_yourself" : "hdm_regask_other";
                    Map askMessageResultMap = RegAskServiceHelper.sendAskMessageToUser((Long)erManFileId, (Long)askPerson, (String)messageTemplateNumber);
                    messageIds.add(askMessageResultMap.get("messageId"));
                    detailMap.put(askMessageResultMap.get("messageId"), askMessageResultMap.get("detailId"));
                }
                option.setVariableValue("messageIds", JSONObject.toJSONString(messageIds));
                option.setVariableValue("detailMap", JSONObject.toJSONString(detailMap));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (StringUtils.equalsIgnoreCase((CharSequence)"save", (CharSequence)operateKey) && isSuccess) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.contains("cbox")) {
            this.cBoxChange(propertyName);
        }
    }

    private void cBoxChange(String propertyName) {
        Boolean isSelcet = (Boolean)this.getModel().getValue(propertyName);
        String[] proName = propertyName.split("_");
        if (!StringUtils.isNumeric((CharSequence)proName[1])) {
            if (isSelcet.booleanValue()) {
                this.getModel().setValue(propertyName, (Object)Boolean.FALSE);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u4eba\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegAskPersonPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        Long person = Long.valueOf(proName[1]);
        this.getView().setVisible(isSelcet, new String[]{"repeatasklbl" + person});
        String pageId = this.getView().getPageId();
        List<Long> hasSendNotDoList = this.singleCommon.getListTypeCache("cache_hassendnotdo", pageId);
        Map<Long, String> hasSendNotDoMap = this.singleCommon.getMapTypeCache("cache_hassendnotdomap", pageId);
        if (isSelcet.booleanValue() && hasSendNotDoList.contains(person)) {
            this.getModel().setValue(propertyName, (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.FALSE, new String[]{"repeatasklbl" + person});
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u95ee\u8be2\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegAskPersonPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), hasSendNotDoMap.get(person));
            this.getView().showErrorNotification(message);
        }
    }

    private void beforeAddAskPerson(Set<Long> askPersons, Map<Long, String> roleMap, BeforeDoOperationEventArgs args) {
        String fromForm = this.getView().getParentView().getEntityId();
        if (HRStringUtils.equals((String)fromForm, (String)"hdm_personregview") || HRStringUtils.equals((String)fromForm, (String)"bos_list")) {
            if (askPersons.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u53d1\u9001\u7684\u95ee\u8be2\u4eba\u3002", (String)"RegAskPersonPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long employeeId = (Long)formShowParameter.getCustomParam("employee");
            Map validate = RegCommonValidatorHelper.getInstance().validateAskRegStatus(employeeId, this.getView().getParentView());
            Boolean flag = Boolean.parseBoolean((String)validate.get("validateResult"));
            if (!flag.booleanValue()) {
                String msg = (String)validate.get("msg");
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"hers_ermanfilef7list")) {
            ListSelectedRowCollection selectRowCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (selectRowCollection == null || selectRowCollection.size() < 1) {
                return;
            }
            String pageId = this.getView().getPageId();
            List<Map<String, Object>> nowReturnData = this.singleCommon.getNowAllInfoCache(pageId);
            List<Long> nowPersonList = this.singleCommon.getListTypeCache("cache_nowperson", pageId);
            List<Long> tutorList = this.singleCommon.getListTypeCache("cache_tutor", pageId);
            List<Long> leaderList = this.singleCommon.getListTypeCache("cache_leader", pageId);
            List<Long> hasSendNotDoList = this.singleCommon.getListTypeCache("cache_hassendnotdo", pageId);
            Map<Long, String> hasSendNotDoMap = this.singleCommon.getMapTypeCache("cache_hassendnotdomap", pageId);
            Long self = (Long)this.getView().getFormShowParameter().getCustomParam("person");
            Object[] ids = selectRowCollection.getPrimaryKeyValues();
            HRBaseServiceHelper userServiceHelper = new HRBaseServiceHelper("bos_user");
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DynamicObject[] userObjects = userServiceHelper.query("id,name,picturefield", new QFilter[]{filter});
            StringBuilder message = new StringBuilder();
            int messagePerson = 0;
            int messageAllPerson = 0;
            for (DynamicObject userObject : userObjects) {
                Long userId = userObject.getLong("id");
                HashMap<String, Object> returnRow = new HashMap<String, Object>();
                returnRow.put("person", userId);
                returnRow.put("personName", userObject.getString("name"));
                returnRow.put("headsculpture", userObject.getString("picturefield"));
                if (!nowPersonList.contains(userId) && !hasSendNotDoList.contains(userId)) {
                    if (!(userId.equals(self) || tutorList.contains(userId) || leaderList.contains(userId))) {
                        nowPersonList.add(userId);
                        nowReturnData.add(returnRow);
                    } else {
                        String filed = "cbox" + userId;
                        boolean isChanged = this.getModel().getDataChanged();
                        this.getModel().setValue(filed, (Object)Boolean.TRUE);
                        if (!isChanged) {
                            this.getModel().setDataChanged(false);
                        }
                    }
                }
                if (!hasSendNotDoList.contains(userId)) continue;
                ++messageAllPerson;
                if (messagePerson >= 3) continue;
                message.append('\u3010');
                message.append(hasSendNotDoMap.get(userId));
                message.append('\u3011');
                ++messagePerson;
            }
            if (message.length() > 0) {
                String errorMsg = null;
                errorMsg = messagePerson > 2 ? String.format(ResManager.loadKDString((String)"%1$s\u7b49\uff08\u603b\u4eba\u6570\uff1a%2$s\uff09\u5b58\u5728\u672a\u5904\u7406\u7684\u95ee\u8be2\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegAskPersonPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]), message, messageAllPerson) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u672a\u5904\u7406\u7684\u95ee\u8be2\u4efb\u52a1\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u9001\u3002", (String)"RegAskPersonPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]), message);
                this.getView().showErrorNotification(errorMsg);
            }
            this.singleCommon.putPageCache(this.getView().getPageId(), "cache_nowInfos", nowReturnData);
            this.singleCommon.putPageCache(this.getView().getPageId(), "cache_nowperson", nowPersonList);
            FlexPanelAp panelAp = this.singleCommon.getAddFlex(nowReturnData, pageId, true);
            this.getView().updateControlMetadata("addflex", panelAp.createControl());
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        Control source = (Control)evt.getSource();
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
        }
        String controlKey = source.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map erManFile = (Map)formShowParameter.getCustomParam("erManfile");
        for (String businessKey : BUSINESS_CARD_ARR) {
            if (!controlKey.startsWith(businessKey)) continue;
            String key = businessKey;
            Map leaderMap = (Map)((List)erManFile.get(String.format(Locale.ROOT, "%sinfo", key))).get(0);
            formshowParameter.setCustomParam("id", (Object)String.valueOf(leaderMap.get("id")));
            formshowParameter.setCustomParam("name", (Object)String.valueOf(leaderMap.get("name")));
            formshowParameter.setCustomParam("number", (Object)String.valueOf(leaderMap.get("number")));
            evt.setFormshowParameter(formshowParameter);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    private void addTipsListener(String key) {
        IFormView formView = this.getView();
        Image image = (Image)formView.getControl(String.format("%simage", key));
        if (image != null) {
            image.addTipsListener((TipsListener)this);
        }
    }
}

