/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.formplugin.reg.web.batch;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.form.field.BasedataEdit;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.application.reg.service.IBatchRegService;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.formplugin.reg.web.batch.importvalidator.RegBatchCrossValidator;
import kd.hr.hdm.formplugin.reg.web.batch.importvalidator.RegBillUniqueValidator;
import kd.hr.hdm.formplugin.reg.web.batch.importvalidator.RegEntryErmanFileValidator;
import kd.hr.hdm.formplugin.reg.web.batch.importvalidator.RegEntryMustInputValidator;
import kd.hr.hdm.formplugin.reg.web.batch.importvalidator.RegLicenseValidator;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hrmp.hies.entry.common.dto.FieldHeaderWriterFormat;
import kd.hrmp.hies.entry.common.enu.EntryValidatorEnum;
import kd.hrmp.hies.entry.common.plugin.impt.AfterBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.AfterInitContextArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeBackFillDataEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateHeaderColumnEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeCreateTemplateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeInitValidatorEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeQueryRefBdEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.BeforeTemplateValidateEventArgs;
import kd.hrmp.hies.entry.common.plugin.impt.HREntryImportPlugin;
import kd.hrmp.hies.entry.core.validate.AbstractEntryValidateHandler;

public class BatchRegEntryImportPlugin
implements HREntryImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(BatchRegEntryImportPlugin.class);
    private static final String ERMANFILE_NUMBER = "ermanfile.number";
    private static final String ERMANFILE_NAME = "ermanfile.name";
    private static final String REGCOMMENT_NAME = "regcomment.name";
    private static final String LABORRELSTATUS_NAME = "laborrelstatus.name";
    private static final String AFFACTION_NAME = "affaction.name";

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List headerWriterFormats = args.getHeaderWriterFormats();
        headerWriterFormats.clear();
        headerWriterFormats.add(new KeyValue(ERMANFILE_NUMBER, (Object)ResManager.loadKDString((String)"*\u5de5\u53f7", (String)"BatchRegEntryImportPlugin_0", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(0)));
        headerWriterFormats.add(new KeyValue(ERMANFILE_NAME, (Object)ResManager.loadKDString((String)"\u59d3\u540d", (String)"BatchRegEntryImportPlugin_1", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(1)));
        headerWriterFormats.add(new KeyValue(AFFACTION_NAME, (Object)ResManager.loadKDString((String)"*\u53d8\u52a8\u64cd\u4f5c.\u540d\u79f0", (String)"BatchRegEntryImportPlugin_4", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(2)));
        headerWriterFormats.add(new KeyValue(REGCOMMENT_NAME, (Object)ResManager.loadKDString((String)"*\u8f6c\u6b63\u610f\u89c1.\u540d\u79f0", (String)"BatchRegEntryImportPlugin_2", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(3)));
        headerWriterFormats.add(new KeyValue(LABORRELSTATUS_NAME, (Object)ResManager.loadKDString((String)"\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001", (String)"BatchRegEntryImportPlugin_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(4)));
        headerWriterFormats.add(new KeyValue("effectdate", (Object)ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f", (String)"BatchRegEntryImportPlugin_5", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(5)));
        headerWriterFormats.add(new KeyValue("regcategory", (Object)ResManager.loadKDString((String)"*\u8f6c\u6b63\u5206\u7c7b", (String)"BatchRegEntryImportPlugin_3", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(6)));
        headerWriterFormats.add(new KeyValue("isviewflow", (Object)ResManager.loadKDString((String)"*\u662f\u5426\u5141\u8bb8\u5458\u5de5\u53ef\u89c1\u6d41\u7a0b", (String)"BatchRegEntryImportPlugin_6", (String)"hr-hdm-formplugin", (Object[])new Object[0]), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(7)));
        int index = 7;
        List multiLangEnabledLang = new InteServiceImpl().getMultiLangEnabledLang();
        for (EnabledLang enabledLang : multiLangEnabledLang) {
            headerWriterFormats.add(new KeyValue("comment." + enabledLang.getNumber(), (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u63cf\u8ff0.%s", (String)"BatchRegEntryImportPlugin_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]), enabledLang.getName()), new Object[]{new FieldHeaderWriterFormat()}, Integer.valueOf(++index)));
        }
    }

    public void beforeTemplateValidate(BeforeTemplateValidateEventArgs args) {
        super.beforeTemplateValidate(args);
        args.setIgnoreValidateField(this.getIgnoreValidateField());
        args.setF7formatCfg(this.getF7formatCfg());
    }

    public void afterInitContext(AfterInitContextArgs args) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add("ermanfile");
        args.setUniqueFields(list);
        args.setF7formatCfg(this.getF7formatCfg());
        args.setIgnoreValidateField(this.getIgnoreValidateField());
    }

    private List<String> getIgnoreValidateField() {
        LinkedList<String> ignoreValidateField = new LinkedList<String>();
        ignoreValidateField.add(REGCOMMENT_NAME);
        ignoreValidateField.add(AFFACTION_NAME);
        ignoreValidateField.add(LABORRELSTATUS_NAME);
        ignoreValidateField.add("regcomment");
        ignoreValidateField.add("regcategory");
        ignoreValidateField.add("affaction");
        return ignoreValidateField;
    }

    public void beforeCreateTemplate(BeforeCreateTemplateEventArgs args) {
        args.setF7formatCfg(this.getF7formatCfg());
    }

    private Map<String, String> getF7formatCfg() {
        HashMap<String, String> f7formatCfg = new HashMap<String, String>(8);
        f7formatCfg.put("ermanfile", "number");
        f7formatCfg.put("regcomment", "name");
        f7formatCfg.put("laborrelstatus", "name");
        f7formatCfg.put("affaction", "name");
        return f7formatCfg;
    }

    public void beforeQueryRefBd(BeforeQueryRefBdEventArgs args) {
        if ("ermanfile".equals(args.getFieldId()) && "hspm_ermanfile".equals(args.getBaseDataName())) {
            QFilter[] filters = args.getFilters();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(filters.length);
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
            if (!args.isImportInvoke()) {
                filterList.add(new QFilter("1", "=", (Object)2));
                args.setFilters(filterList.toArray(new QFilter[0]));
                return;
            }
            args.setFilters(filterList.toArray(new QFilter[0]));
            List empNumberList = args.getBillDataList().stream().map(data -> data.getData().getJSONObject("entryentity").getJSONObject("ermanfile").getString("number")).distinct().collect(Collectors.toList());
            DynamicObject[] dynamicObjects = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(empNumberList);
            Set ermanfileIds = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            filterList.add(new QFilter("id", "in", ermanfileIds));
            args.setFilters(filterList.toArray(new QFilter[0]));
        } else if ("affaction".equals(args.getFieldId()) && "hpfs_chgaction".equals(args.getBaseDataName())) {
            List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_reg_hpfs_new", (String)"hdm_regbasebill");
            args.setFilters(new QFilter("id", "in", (Object)affactionIds).toArray());
        } else if ("laborrelstatus".equals(args.getFieldId()) && "hbss_laborrelstatus".equals(args.getBaseDataName())) {
            List affactionIds = PersonnelChangeServiceHelper.getAffactionMapByBusinessKey((String)"hdm_reg_hpfs_new", (String)"hdm_regbasebill");
            Map laborrelstatusMap = PersonnelChangeServiceHelper.getLaborrelstatusByAffactions(new ArrayList(affactionIds));
            Set laborrelstatusIds = laborrelstatusMap.values().stream().flatMap(Collection::stream).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
            args.setFilters(new QFilter("id", "in", laborrelstatusIds).toArray());
        }
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        long org = ((DynamicObject)args.getDataModel().getValue("org")).getLong("id");
        BasedataEdit ermanfile = (BasedataEdit)args.getFormView().getControl("ermanfile");
        List filters = FilterUtil.buildBaseDataPropertyQFilters((IDataModel)args.getDataModel(), (String)((BasedataProp)ermanfile.getProperty()).getBaseEntityId(), (IBasedataField)((IBasedataField)ermanfile.getProperty()), (String)args.getFormView().getFormShowParameter().getAppId(), (String)args.getFormView().getFormShowParameter().getPermissionItemId());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("org", org);
        paramMap.put("filters", filters);
        args.setValidator(EntryValidatorEnum.MUST_FILL_IN_VALIDATOR, (AbstractEntryValidateHandler)new RegEntryMustInputValidator());
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new RegEntryErmanFileValidator(paramMap));
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new RegLicenseValidator());
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new RegBatchCrossValidator());
        Object pkValue = args.getDataModel().getDataEntity().getPkValue();
        args.setValidator(EntryValidatorEnum.CUSTOM_VALIDATOR, (AbstractEntryValidateHandler)new RegBillUniqueValidator(pkValue));
    }

    public void beforeBackFillData(BeforeBackFillDataEventArgs args) {
        for (ImportBillData data : args.getRowData()) {
            JSONObject entryentity = data.getData().getJSONObject("entryentity");
            long regcommentId = entryentity.getJSONObject("regcomment").getLong("id");
            if (1020L != regcommentId) continue;
            entryentity.put("effectdate", null);
            entryentity.put("laborrelstatus", null);
        }
    }

    public void afterBackFillData(AfterBackFillDataEventArgs args) {
        DynamicObjectCollection entryEntity = args.getDataModel().getEntryEntity("entryentity");
        IBatchRegService.getInstance().fillDynamicObjectCollection4Import(entryEntity);
        args.getFormView().updateView("entryentity");
    }
}

